/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.run.filters;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfoFactory;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;

public final class RailsViewsFileFilter
implements Filter {
    private static final Pattern LINE_START_PATTERN = Pattern.compile(".*(Rendering|Rendered).*", 32);
    private static final Pattern FILE_PATH_PATTERN = Pattern.compile("(?<=^|[\\s\\[\"])([\\p{Alnum}_][^:\\s]+(?:\\.[^:\\s]+)?)");
    private static final TextAttributes HYPERLINK_ATTRIBUTES = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.HYPERLINK_ATTRIBUTES);
    private final Project myProject;
    private final Module myModule;

    public RailsViewsFileFilter(@NotNull Project project, @NotNull Module module) {
        if (project == null) {
            RailsViewsFileFilter.$$$reportNull$$$0(0);
        }
        if (module == null) {
            RailsViewsFileFilter.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myModule = module;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        if (line == null) {
            RailsViewsFileFilter.$$$reportNull$$$0(2);
        }
        if (this.myProject.isDisposed() || this.myModule.isDisposed()) {
            return null;
        }
        if (line.length() > 255 || !LINE_START_PATTERN.matcher(line).matches()) {
            return null;
        }
        Matcher matcher = FILE_PATH_PATTERN.matcher(line);
        if (!matcher.find()) {
            return null;
        }
        ArrayList<Filter.ResultItem> items = new ArrayList<Filter.ResultItem>();
        List<VirtualFile> viewsRoots = RailsPaths.getInstance(this.myModule).findFiles("app/views");
        if (viewsRoots.isEmpty()) {
            return null;
        }
        do {
            String path = matcher.group(1);
            int start = entireLength - line.length() + matcher.start();
            int end = start + path.length();
            List files = ContainerUtil.flatMap(viewsRoots, it -> RailsViewsFileFilter.findFileByRelativePathWithOrWithoutExtension(it, path));
            if (files.isEmpty()) continue;
            HyperlinkInfo hyperlinkInfo = HyperlinkInfoFactory.getInstance().createMultipleFilesHyperlinkInfo(files, 0, this.myProject);
            items.add(new Filter.ResultItem(start, end, hyperlinkInfo, HYPERLINK_ATTRIBUTES));
        } while (matcher.find());
        return !items.isEmpty() ? new Filter.Result(items) : null;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RailsViewsFileFilter other = (RailsViewsFileFilter)obj;
        return this.myProject.equals((Object)other.myProject) && this.myModule.equals((Object)other.myModule);
    }

    public int hashCode() {
        return 31 * this.myProject.hashCode() + this.myModule.hashCode();
    }

    @NotNull
    private static List<VirtualFile> findFileByRelativePathWithOrWithoutExtension(@NotNull VirtualFile root, @NotNull String path) {
        VirtualFile directory;
        VirtualFile file;
        if (root == null) {
            RailsViewsFileFilter.$$$reportNull$$$0(3);
        }
        if (path == null) {
            RailsViewsFileFilter.$$$reportNull$$$0(4);
        }
        if ((file = root.findFileByRelativePath(path)) != null) {
            List<VirtualFile> list = List.of(file);
            if (list == null) {
                RailsViewsFileFilter.$$$reportNull$$$0(5);
            }
            return list;
        }
        String parent = path.contains("/") ? StringUtil.substringBeforeLast((String)path, (String)"/") : null;
        String name = (String)ObjectUtils.coalesce((Object)StringUtil.substringAfterLast((String)path, (String)"/"), (Object)path);
        VirtualFile virtualFile = directory = parent != null ? root.findFileByRelativePath(parent) : root;
        if (directory == null) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                RailsViewsFileFilter.$$$reportNull$$$0(6);
            }
            return list;
        }
        List list = VfsUtil.getChildren((VirtualFile)directory, child -> child.getName().startsWith(name + "."));
        if (list == null) {
            RailsViewsFileFilter.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/run/filters/RailsViewsFileFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/run/filters/RailsViewsFileFilter";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findFileByRelativePathWithOrWithoutExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFilter";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findFileByRelativePathWithOrWithoutExtension";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

