/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.run.filters;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.run.filters.FileLinksFilterUtil;
import org.jetbrains.plugins.ruby.ruby.run.filters.OpenIOFilesHyperlinkInfo;

public class RStackTraceFilter
implements Filter {
    public static final String FILE_PATH_WITHOUT_EXTENSION_PATTERN = "(?<=^|[\\s\\[])(?:\\.{1,2}|[A-Za-z]:|[/\\p{Alnum}_~])[^:\\s]+\\.";
    public static final String EXCEPTION_LINE_NUMBER_PATTERN = ":(\\d+)";
    private static final Pattern LINE_PATTERN = Pattern.compile("((?<=^|[\\s\\[])(?:\\.{1,2}|[A-Za-z]:|[/\\p{Alnum}_~])[^:\\s]+\\.[\\w~]+)(?::(\\d+))?");
    @Nullable
    private final String myWorkingDir;
    private static final String APP_FOLDER_STAMP = "/app/";
    private static final String LIB_FOLDER_STAMP = "/lib/";
    private static final String VENDOR_FOLDER_STAMP = "/vendor/";
    private static final String CONFIG_FOLDER_STAMP = "/config/";
    private static final String DB_MIGRATE_FOLDER_STAMP = "/db/migrate/";
    private static final String UNIT_TESTS_FOLDER_STAMP = "/test/";
    private static final String SPEC_TESTS_FOLDER_STAMP = "/spec/";
    private final Project myProject;
    private final Module myModule;
    private final List<@NotNull String> myModuleHomeFolders;

    public RStackTraceFilter(@NotNull Project project) {
        if (project == null) {
            RStackTraceFilter.$$$reportNull$$$0(0);
        }
        this(project, null);
    }

    public RStackTraceFilter(@NotNull Module module) {
        if (module == null) {
            RStackTraceFilter.$$$reportNull$$$0(1);
        }
        this(module, null);
    }

    public RStackTraceFilter(@NotNull Module module, @Nullable String workingDir) {
        if (module == null) {
            RStackTraceFilter.$$$reportNull$$$0(2);
        }
        this(module.getProject(), workingDir, module);
    }

    public RStackTraceFilter(@NotNull Project project, @Nullable String workingDir) {
        if (project == null) {
            RStackTraceFilter.$$$reportNull$$$0(3);
        }
        this(project, workingDir, null);
    }

    private RStackTraceFilter(@NotNull Project project, @Nullable String workingDir, @Nullable Module module) {
        if (project == null) {
            RStackTraceFilter.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myWorkingDir = !StringUtil.isEmpty((String)workingDir) ? workingDir + "/" : null;
        this.myModuleHomeFolders = RubyPsiUtil.collectNotNull(ContainerUtil.map((Object[])RModuleUtil.getInstance().getAllModulesWithRubySupport(project), RStackTraceFilter::getModuleHomeFolder));
        this.myModule = module;
    }

    private static String getModuleHomeFolder(Module module) {
        String railsAppHomeDir = RailsFacetUtil.getRailsAppHomeDirPath(module);
        if (railsAppHomeDir != null) {
            return railsAppHomeDir;
        }
        VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        return roots.length > 0 ? roots[0].getPath() : null;
    }

    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        Matcher matcher;
        if (line == null) {
            RStackTraceFilter.$$$reportNull$$$0(5);
        }
        if (this.myProject.isDisposed()) {
            return null;
        }
        String cuttedLine = FileLinksFilterUtil.cutLineIfLong(line);
        int offset = 0;
        while ((matcher = RStackTraceFilter.matchLine(cuttedLine, offset)) != null) {
            int lineNum;
            offset = matcher.end();
            List srcFiles = ContainerUtil.filter(this.findSrcFiles(matcher.group(1)), it -> !FileLinksFilterUtil.hasExeExtension(it));
            if (srcFiles.isEmpty()) continue;
            try {
                lineNum = matcher.group(2) == null ? 1 : Integer.parseInt(matcher.group(2));
            }
            catch (NumberFormatException e) {
                return null;
            }
            int textStartOffset = entireLength - line.length();
            int highlightStartOffset = textStartOffset + matcher.start();
            int highlightEndOffset = textStartOffset + matcher.end();
            HyperlinkInfo info = this.getHyperlinkInfo(srcFiles, lineNum);
            TextAttributes attributes = ContainerUtil.exists((Iterable)srcFiles, it -> this.isInContent((File)it)) ? EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.HYPERLINK_ATTRIBUTES) : EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.INACTIVE_HYPERLINK_ATTRIBUTES);
            return new Filter.Result(highlightStartOffset, highlightEndOffset, info, attributes);
        }
        return null;
    }

    private HyperlinkInfo getHyperlinkInfo(@NotNull List<File> srcFiles, int lineNum) {
        List contentRootsPaths;
        File moduleFile;
        if (srcFiles == null) {
            RStackTraceFilter.$$$reportNull$$$0(6);
        }
        if (this.myModule != null && (moduleFile = (File)ContainerUtil.find(srcFiles, arg_0 -> RStackTraceFilter.lambda$getHyperlinkInfo$3(contentRootsPaths = ContainerUtil.map((Object[])ModuleRootManager.getInstance((Module)this.myModule).getContentRoots(), VirtualFile::toNioPath), arg_0))) != null) {
            return this.getHyperLinkInfo(List.of(moduleFile), lineNum);
        }
        return this.getHyperLinkInfo(srcFiles, lineNum);
    }

    @NotNull
    private HyperlinkInfo getHyperLinkInfo(@NotNull List<File> srcFiles, int lineNum) {
        if (srcFiles == null) {
            RStackTraceFilter.$$$reportNull$$$0(7);
        }
        return new OpenIOFilesHyperlinkInfo(this.myProject, srcFiles, lineNum - 1);
    }

    @NotNull
    private List<File> findSrcFiles(String filePath) {
        int testsFolderIndex;
        int configFolderIndex;
        int migrationsIndex;
        int vendorFolderIndex;
        int libFolderIndex;
        if (this.myWorkingDir != null && ((String)filePath).startsWith(".")) {
            filePath = this.myWorkingDir + (String)filePath;
        }
        ArrayList<String> workDirs = new ArrayList<String>(this.myModuleHomeFolders);
        workDirs.add(this.myWorkingDir);
        List<File> srcFiles = FileLinksFilterUtil.getFileByRubyLink((String)filePath, workDirs);
        if (!srcFiles.isEmpty()) {
            List<File> list = srcFiles;
            if (list == null) {
                RStackTraceFilter.$$$reportNull$$$0(8);
            }
            return list;
        }
        int appFolderIndex = ((String)(filePath = FileUtil.toSystemIndependentName((String)filePath))).indexOf(APP_FOLDER_STAMP);
        int relativePathStartIndex = appFolderIndex > 0 ? appFolderIndex : ((libFolderIndex = ((String)filePath).indexOf(LIB_FOLDER_STAMP)) > 0 ? libFolderIndex : ((vendorFolderIndex = ((String)filePath).indexOf(VENDOR_FOLDER_STAMP)) > 0 ? vendorFolderIndex : ((migrationsIndex = ((String)filePath).indexOf(DB_MIGRATE_FOLDER_STAMP)) > 0 ? migrationsIndex : ((configFolderIndex = ((String)filePath).indexOf(CONFIG_FOLDER_STAMP)) > 0 ? configFolderIndex : ((testsFolderIndex = ((String)filePath).indexOf(UNIT_TESTS_FOLDER_STAMP)) > 0 ? testsFolderIndex : ((String)filePath).indexOf(SPEC_TESTS_FOLDER_STAMP))))));
        if (relativePathStartIndex < 0) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                RStackTraceFilter.$$$reportNull$$$0(9);
            }
            return list;
        }
        List<String> moduleHomeFolders = ApplicationManager.getApplication().isUnitTestMode() ? Collections.singletonList(this.myWorkingDir) : List.copyOf(this.myModuleHomeFolders);
        String relativeFilePath = ((String)filePath).substring(relativePathStartIndex);
        List<File> list = FileLinksFilterUtil.getFileByRubyLink(relativeFilePath, moduleHomeFolders);
        if (list == null) {
            RStackTraceFilter.$$$reportNull$$$0(10);
        }
        return list;
    }

    private boolean isInContent(@NotNull File srcFile) {
        if (srcFile == null) {
            RStackTraceFilter.$$$reportNull$$$0(11);
        }
        List contentRootUrls = ContainerUtil.map((Object[])ProjectRootManager.getInstance((Project)this.myProject).getContentRoots(), VirtualFile::getUrl);
        return VfsUtilCore.isUnder((String)VfsUtilCore.fileToUrl((File)srcFile), (Collection)contentRootUrls);
    }

    @TestOnly
    @ApiStatus.Internal
    public static Pattern getPattern() {
        return LINE_PATTERN;
    }

    public static Matcher matchLine(@NotNull String line) {
        if (line == null) {
            RStackTraceFilter.$$$reportNull$$$0(12);
        }
        return RStackTraceFilter.matchLine(line, 0);
    }

    @Nullable
    public static Matcher matchLine(String cuttedLine, int offset) {
        Matcher matcher = LINE_PATTERN.matcher(cuttedLine);
        if (!matcher.find(offset)) {
            return null;
        }
        return matcher;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RStackTraceFilter filter = (RStackTraceFilter)o;
        return Objects.equals(this.myWorkingDir, filter.myWorkingDir) && Objects.equals(this.myProject, filter.myProject) && Objects.equals(this.myModuleHomeFolders, filter.myModuleHomeFolders);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.myWorkingDir);
        result = 31 * result + this.myProject.hashCode();
        result = 31 * result + this.myModuleHomeFolders.hashCode();
        return result;
    }

    private static /* synthetic */ boolean lambda$getHyperlinkInfo$3(List contentRootsPaths, File file) {
        return ContainerUtil.exists((Iterable)contentRootsPaths, path -> file.toPath().startsWith((Path)path));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcFiles";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/run/filters/RStackTraceFilter";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/run/filters/RStackTraceFilter";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findSrcFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFilter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getHyperlinkInfo";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getHyperLinkInfo";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isInContent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "matchLine";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10 -> new IllegalStateException(string);
        };
    }

    static final class DefaultFilter
    extends RStackTraceFilter {
        DefaultFilter(@NotNull Project project) {
            if (project == null) {
                DefaultFilter.$$$reportNull$$$0(0);
            }
            super(project);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/ruby/rails/run/filters/RStackTraceFilter$DefaultFilter", "<init>"));
        }
    }
}

