/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.run.configuration.server.commandline;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.ruby.RubyUtil;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.utils.RubyUIUtil;

public final class RailsServerInitializerUtil {
    static void setupDebugInitializer(AbstractRubyRunConfiguration config, String runnerId, String initializerScript, String serverName) throws ExecutionException {
        if (!"RubyDebugRunner".equals(runnerId)) {
            return;
        }
        Module module = Objects.requireNonNull(config.getModule());
        VirtualFile debug = (VirtualFile)ContainerUtil.getFirstItem(RailsPaths.getInstance(module).findFiles("config/initializers", initializerScript));
        if (debug == null) {
            VirtualFile initializers = (VirtualFile)ContainerUtil.getFirstItem(RailsPaths.getInstance(module).findFiles("config/initializers"));
            if (initializers == null) {
                throw new ExecutionException(RBundle.message((String)"dialog.message.missing.config.initializers.directory"));
            }
            RailsServerInitializerUtil.addDebugInitializer(module, initializers, initializerScript, serverName);
        }
    }

    private static void addDebugInitializer(Module module, VirtualFile initializers, String initializerScript, String serverName) throws ExecutionException {
        String message = RBundle.message((String)"ruby.debugger.rails.initializer", (Object[])new Object[]{serverName});
        int result = RubyUIUtil.showYesNoDialogFromEDT(module.getProject(), RBundle.message((String)"ruby.debugger.rails.initializer.dialog.message", (Object[])new Object[]{message}), RBundle.message((String)"gems.debugger.alert.title"), Messages.getQuestionIcon());
        if (result != 0) {
            throw new ExecutionException(message);
        }
        String loader = RubyUtil.getScriptFullPath("rb/gems/" + initializerScript);
        assert (loader != null);
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(loader);
        assert (file != null) : "Missing " + initializerScript + ". Probably installation is corrupted";
        Application application = ApplicationManager.getApplication();
        Ref exceptionRef = Ref.create();
        application.invokeAndWait(() -> application.runWriteAction(() -> {
            try {
                VfsUtilCore.copyFile((Object)module, (VirtualFile)file, (VirtualFile)initializers);
            }
            catch (IOException e) {
                exceptionRef.set((Object)e);
            }
        }));
        if (!exceptionRef.isNull()) {
            throw new ExecutionException(RBundle.message((String)"dialog.message.failed.to.create.initializer"), (Throwable)exceptionRef.get());
        }
    }
}

