/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.run.configuration.server.commandline;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.run.configuration.server.RailsServerRunConfiguration;
import org.jetbrains.plugins.ruby.rails.run.configuration.server.commandline.BaseRailsServerRunCommandLineGenerator;
import org.jetbrains.plugins.ruby.rails.run.configuration.server.commandline.RailsServerInitializerUtil;
import org.jetbrains.plugins.ruby.ruby.debugger.settings.RubyDebuggerSettings;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommandLineData;

public class PassengerServerRunCommandLineGenerator
extends BaseRailsServerRunCommandLineGenerator {
    private static final String RUBYMINE_PASSENGER_DEBUG_RB = "rubymine_passenger_debug.rb";

    public PassengerServerRunCommandLineGenerator(RailsServerRunConfiguration config) {
        super(config);
    }

    @Override
    public void addIpAddressAndPortParameters(@Nullable String ipAddress, @Nullable Integer port, @NotNull ParamsGroup params) {
        if (params == null) {
            PassengerServerRunCommandLineGenerator.$$$reportNull$$$0(0);
        }
        if (StringUtil.isNotEmpty((String)ipAddress)) {
            params.addParameter("-a");
            params.addParameter(ipAddress);
        }
        if (port != null) {
            params.addParameter("-p");
            params.addParameter(String.valueOf(port));
        }
        params.addParameter("--max-pool-size");
        params.addParameter("1");
        params.addParameter("--spawn-method");
        params.addParameter("conservative");
    }

    @Override
    @Nullable
    public String getServerScript(boolean isInDebugMode) {
        String path = this.myConfig.getGemScriptPath();
        if (path != null) {
            return path;
        }
        return super.getServerScript(isInDebugMode);
    }

    @Override
    public void addServerParameter(@NotNull String server, @NotNull ParamsGroup params, boolean isInDebugMode) {
        if (server == null) {
            PassengerServerRunCommandLineGenerator.$$$reportNull$$$0(1);
        }
        if (params == null) {
            PassengerServerRunCommandLineGenerator.$$$reportNull$$$0(2);
        }
        params.addParameter("start");
    }

    @Override
    public void addEnvironmentVariables(RailsServerRunConfiguration config, RubyCommandLineData data, String runnerId) throws ExecutionException {
        if (!"RubyDebugRunner".equals(runnerId)) {
            return;
        }
        RailsServerInitializerUtil.setupDebugInitializer(config, runnerId, RUBYMINE_PASSENGER_DEBUG_RB, "Phusion Passenger");
        RubyCommandLine commandLine = data.getCommandLine();
        Map params = commandLine.getEnvironment();
        commandLine.getParametersList().clearAll();
        params.put("RUBYMINE_DEBUG_PORT", ((Integer)data.getUserData(RubyCommandLineData.DEBUG_PORT_KEY)).toString());
        if (RubyDebuggerSettings.getInstance().getState().isVerboseOutput()) {
            params.put("RUBYMINE_DEBUG_VERBOSE", "true");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/run/configuration/server/commandline/PassengerServerRunCommandLineGenerator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addIpAddressAndPortParameters";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addServerParameter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

