/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.run.configuration.server.commandline;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.run.configuration.server.RailsServerRunConfiguration;
import org.jetbrains.plugins.ruby.rails.run.configuration.server.commandline.RailsServerRunCommandLineGenerator;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommandLineData;

public class BaseRailsServerRunCommandLineGenerator
implements RailsServerRunCommandLineGenerator {
    protected final RailsServerRunConfiguration myConfig;

    public BaseRailsServerRunCommandLineGenerator(RailsServerRunConfiguration config) {
        this.myConfig = config;
    }

    @Override
    public void addIpAddressAndPortParameters(@Nullable String ipAddress, @Nullable Integer port, @NotNull ParamsGroup params) {
        if (params == null) {
            BaseRailsServerRunCommandLineGenerator.$$$reportNull$$$0(0);
        }
        if (StringUtil.isNotEmpty((String)ipAddress)) {
            params.addParameter("-b");
            params.addParameter(ipAddress);
        }
        if (port != null) {
            params.addParameter("-p");
            params.addParameter(String.valueOf(port));
        }
    }

    @Override
    public void addEnvironmentParameter(@NotNull String railsEnvironment, @NotNull ParamsGroup params) {
        if (railsEnvironment == null) {
            BaseRailsServerRunCommandLineGenerator.$$$reportNull$$$0(1);
        }
        if (params == null) {
            BaseRailsServerRunCommandLineGenerator.$$$reportNull$$$0(2);
        }
        params.addParameter("-e");
        params.addParameter(railsEnvironment);
    }

    @Override
    public void addServerParameter(@NotNull String server, @NotNull ParamsGroup params, boolean isInDebugMode) {
        if (server == null) {
            BaseRailsServerRunCommandLineGenerator.$$$reportNull$$$0(3);
        }
        if (params == null) {
            BaseRailsServerRunCommandLineGenerator.$$$reportNull$$$0(4);
        }
        if (!"Default".equalsIgnoreCase(server)) {
            Module module = this.myConfig.getModule();
            if (module != null && RailsUtil.isRails6OrHigher(module)) {
                params.addParameter("-u");
            }
            params.addParameter("puma".equals(server) ? "Puma" : server);
        }
    }

    @Override
    @Nullable
    public String getServerScript(boolean isInDebugMode) {
        return (String)ReadAction.compute(() -> RailsServerRunConfiguration.getServerScriptPathByModule(this.myConfig.getModule(), this.myConfig.getDummyAppLocation()));
    }

    @Override
    public void addEnvironmentVariables(RailsServerRunConfiguration config, RubyCommandLineData data, String runnerId) throws ExecutionException {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "railsEnvironment";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/run/configuration/server/commandline/BaseRailsServerRunCommandLineGenerator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addIpAddressAndPortParameters";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addEnvironmentParameter";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addServerParameter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

