/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.run.configuration.server;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LogFileOptions;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.run.configuration.RailsRunConfigurationUtil;
import org.jetbrains.plugins.ruby.rails.run.configuration.server.RailsServerRunCommandLineState;
import org.jetbrains.plugins.ruby.rails.run.configuration.server.RailsServerRunConfigurationEditor;
import org.jetbrains.plugins.ruby.rails.run.configuration.server.RailsServerRunConfigurationExternalizer;
import org.jetbrains.plugins.ruby.rails.run.configuration.server.RailsServerRunConfigurationParams;
import org.jetbrains.plugins.ruby.rails.run.configuration.server.commandline.RailsServerRunCommandLineGeneratorFactory;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyAbstractCommandLineState;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;

public class RailsServerRunConfiguration
extends AbstractRubyRunConfiguration<RailsServerRunConfiguration>
implements RailsServerRunConfigurationParams {
    @NlsSafe
    public static final String DEFAULT_SERVER = "Default";
    private String myDummyAppLocation = "";
    private String myScriptArgs = "";
    @NotNull
    private String myServerType = "Default";
    @NotNull
    private String myEnvironmentType = "development";
    private String myPort = "";
    private String myIP = "";
    private String myBrowserUrl = null;
    private boolean myLaunchJavascriptDebugger = false;

    public RailsServerRunConfiguration(Project project, ConfigurationFactory factory) {
        super(project, factory);
        this.registerLog("RUBY_RAILS_SERVER");
    }

    @Override
    protected String getSerializationId() {
        return "RAILS_SERVER_CONFIG_SETTINGS_ID";
    }

    @Override
    public boolean isLaunchJavascriptDebugger() {
        return this.myLaunchJavascriptDebugger;
    }

    @Override
    public void setLaunchJavascriptDebugger(boolean launchJavascriptDebugger) {
        this.myLaunchJavascriptDebugger = launchJavascriptDebugger;
    }

    @Override
    public String getDummyAppLocation() {
        return this.myDummyAppLocation;
    }

    @Override
    public void setDummyAppLocation(String location) {
        this.myDummyAppLocation = RailsServerRunConfiguration.asSysIndependentPath(location);
    }

    public static void copyParams(RailsServerRunConfigurationParams fromParams, RailsServerRunConfigurationParams toParams) {
        toParams.setDummyAppLocation(fromParams.getDummyAppLocation());
        toParams.setScriptArgs(fromParams.getScriptArgs());
        toParams.setIPAddr(fromParams.getIPAddr());
        toParams.setPort(fromParams.getPort());
        toParams.setServerType(fromParams.getServerType());
        toParams.setRailsEnvironmentType(fromParams.getRailsEnvironmentType());
        toParams.setBrowserUrl(fromParams.getBrowserUrl());
        toParams.setLaunchJavascriptDebugger(fromParams.isLaunchJavascriptDebugger());
    }

    @Nullable
    public static String getRailsWorkDirByModule(@NotNull Module module) {
        if (module == null) {
            RailsServerRunConfiguration.$$$reportNull$$$0(0);
        }
        return RailsFacetUtil.getRailsAppHomeDirPath(module);
    }

    @Nullable
    public static String getServerScriptPathByModule(@Nullable Module module, String location) {
        String homeDir;
        String string = homeDir = module == null ? null : RailsFacetUtil.getRailsAppHomeDirPath(module);
        if (homeDir == null) {
            return null;
        }
        RailsApp app = RailsApp.fromModule(module);
        assert (app != null);
        String baseDir = homeDir;
        if (app.isEngine() && location != null) {
            if (!FileUtil.isAbsolute((String)location)) {
                location = VirtualFileUtil.buildSystemIndependentPath(homeDir, location);
            }
            baseDir = location;
        }
        return VirtualFileUtil.buildSystemIndependentPath(baseDir, "bin/rails");
    }

    @Override
    public String getScriptArgs() {
        return this.myScriptArgs;
    }

    @Override
    public void setScriptArgs(String myScriptArgs) {
        this.myScriptArgs = StringUtil.notNullize((String)myScriptArgs);
    }

    @Override
    @NotNull
    public String getPort() {
        String string = this.myPort;
        if (string == null) {
            RailsServerRunConfiguration.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public void setPort(String port) {
        this.myPort = StringUtil.notNullize((String)port);
    }

    @Override
    @NotNull
    public String getIPAddr() {
        String string = this.myIP;
        if (string == null) {
            RailsServerRunConfiguration.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getServerType() {
        String string = this.myServerType;
        if (string == null) {
            RailsServerRunConfiguration.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public void setServerType(@NotNull String type) {
        if (type == null) {
            RailsServerRunConfiguration.$$$reportNull$$$0(4);
        }
        this.myServerType = type;
    }

    @Override
    public void setIPAddr(String ip) {
        this.myIP = StringUtil.notNullize((String)ip);
    }

    @Override
    @NotNull
    public List<Module> getValidModules() {
        List<Module> list = Arrays.asList(RailsUtil.getAllModulesWithRailsSupport(this.getProject()));
        if (list == null) {
            RailsServerRunConfiguration.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    @NotNull
    protected SettingsEditor<RailsServerRunConfiguration> createConfigurationEditor() {
        return new RailsServerRunConfigurationEditor(this.getProject(), this);
    }

    @Override
    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            RailsServerRunConfiguration.$$$reportNull$$$0(6);
        }
        super.readExternal(element);
        RailsServerRunConfigurationExternalizer.getInstance().readExternal(this, element);
    }

    @Override
    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            RailsServerRunConfiguration.$$$reportNull$$$0(7);
        }
        super.writeExternal(element);
        RailsServerRunConfigurationExternalizer.getInstance().writeExternal(this, element);
    }

    @Override
    protected RubyAbstractCommandLineState createCommandLineState(@NotNull ExecutionEnvironment env) {
        if (env == null) {
            RailsServerRunConfiguration.$$$reportNull$$$0(8);
        }
        return new RailsServerRunCommandLineState(this, env);
    }

    @Nullable
    public String getRailsServerScriptPath(boolean isInDebugMode) {
        return RailsServerRunCommandLineGeneratorFactory.create(this).getServerScript(isInDebugMode);
    }

    @Override
    protected void validateConfiguration() throws RuntimeConfigurationException {
        RailsRunConfigurationUtil.inspectRailsSDK(this);
        this.inspectScript();
        this.inspectWorkingDir();
        if (this.isJrubyServer()) {
            RailsRunConfigurationUtil.inspectJrubyServerGem(this);
        } else {
            RailsRunConfigurationUtil.inspectNotJrubyServerGem(this);
        }
        this.inspectPort();
        this.inspectIPAddr();
        this.inspectBrowserUrl();
    }

    @Override
    @NotNull
    public String getWorkingDirectory() {
        Module module = this.getModule();
        String string = StringUtil.notNullize((String)(module != null ? RailsServerRunConfiguration.getRailsWorkDirByModule(module) : null));
        if (string == null) {
            RailsServerRunConfiguration.$$$reportNull$$$0(9);
        }
        return string;
    }

    protected void inspectWorkingDir() throws RuntimeConfigurationError {
        String workingDirectory = this.getWorkingDirectory();
        if (StringUtil.isEmpty((String)workingDirectory)) {
            throw new RuntimeConfigurationError(RBundle.message((String)"run.configuration.rails.server.workdir.not.found"));
        }
        RunConfigurationUtil.inspectWorkingDirectory(false, this);
    }

    protected void inspectScript() throws RuntimeConfigurationError {
        String railsScriptPathString = this.getRailsServerScriptPath(false);
        if (StringUtil.isEmpty((String)railsScriptPathString)) {
            throw new RuntimeConfigurationError(RBundle.message((String)"run.configuration.rails.server.script.not.specified"));
        }
        Path railsScriptPath = Paths.get(railsScriptPathString, new String[0]);
        if (!Files.exists(railsScriptPath, new LinkOption[0])) {
            throw new RuntimeConfigurationError(RBundle.message((String)"run.configuration.rails.server.script.not.exists", (Object[])new Object[]{railsScriptPathString}));
        }
        if (!Files.isRegularFile(railsScriptPath, new LinkOption[0])) {
            throw new RuntimeConfigurationError(RBundle.message((String)"run.configuration.rails.server.script.is.not.file", (Object[])new Object[]{railsScriptPathString}));
        }
    }

    private void inspectIPAddr() throws RuntimeConfigurationError {
        String ip = this.getIPAddr();
        if (ip.isEmpty()) {
            if (!this.isEmptyIPAddressOrPortAllowed()) {
                throw new RuntimeConfigurationError(RBundle.message((String)"run.configuration.script.ip.missing"));
            }
        } else {
            RunConfigurationUtil.validateIpAddress(ip);
        }
    }

    private void inspectPort() throws RuntimeConfigurationError {
        String port = this.getPort();
        if (port.isEmpty()) {
            if (!this.isEmptyIPAddressOrPortAllowed()) {
                throw new RuntimeConfigurationError(RBundle.message((String)"run.configuration.script.port.missing"));
            }
        } else {
            RunConfigurationUtil.validatePort(port);
        }
    }

    private void inspectBrowserUrl() throws RuntimeConfigurationError {
        String browserUrl = this.getBrowserUrl();
        if (browserUrl != null && browserUrl.isEmpty()) {
            throw new RuntimeConfigurationError(RBundle.message((String)"run.configuration.script.browser.url.missing"));
        }
    }

    @Override
    public String getRailsEnvironmentType() {
        return this.myEnvironmentType;
    }

    @Override
    public void setRailsEnvironmentType(String railsEnvironmentType) {
        this.myEnvironmentType = railsEnvironmentType;
    }

    @Override
    public String getBrowserUrl() {
        return this.myBrowserUrl;
    }

    @Override
    public void setBrowserUrl(String browserUrl) {
        this.myBrowserUrl = browserUrl;
    }

    @Override
    protected LogFileOptions getOptionsForPredefinedLogFile() {
        RailsApp app = RailsApp.fromModule(this.getModule());
        if (app != null) {
            String logsRoot = app.getLogsPath();
            String environmentType = this.getRailsEnvironmentType();
            return new LogFileOptions("Server " + environmentType + " log", Paths.get(logsRoot, environmentType + ".log").toString(), EncodingProjectManager.getInstance((Project)this.getProject()).getDefaultCharset());
        }
        return null;
    }

    static boolean isJrubyServer(String server) {
        return RailsServerRunConfiguration.isExpectedServer(server, "trinidad");
    }

    public boolean isJrubyServer() {
        return RailsServerRunConfiguration.isJrubyServer(this.myServerType);
    }

    public boolean isPassenger() {
        return this.myServerType.equalsIgnoreCase("passenger");
    }

    public boolean isUnicornServer() {
        return this.myServerType.equalsIgnoreCase("unicorn");
    }

    public boolean isThinServer() {
        return this.myServerType.equalsIgnoreCase("thin");
    }

    private static boolean isExpectedServer(@NotNull String server, @NotNull String expectedServer) {
        if (server == null) {
            RailsServerRunConfiguration.$$$reportNull$$$0(10);
        }
        if (expectedServer == null) {
            RailsServerRunConfiguration.$$$reportNull$$$0(11);
        }
        return expectedServer.equalsIgnoreCase(server);
    }

    static boolean isDefaultServer(String server) {
        return RailsServerRunConfiguration.isExpectedServer(server, DEFAULT_SERVER);
    }

    public boolean isDefault() {
        return RailsServerRunConfiguration.isDefaultServer(this.myServerType);
    }

    public boolean isWEBrick() {
        return RailsServerRunConfiguration.isExpectedServer(this.myServerType, "webrick");
    }

    public boolean isPuma() {
        return RailsServerRunConfiguration.isExpectedServer(this.myServerType, "puma");
    }

    @Nullable
    public String getGemScriptPath() {
        return RubyGemExecutionContext.getScriptPath(this.getSdk(), this.getModule(), this.getServerType());
    }

    private boolean isEmptyIPAddressOrPortAllowed() {
        return this.isDefault() || this.isPassenger() || this.isThinServer() || this.isWEBrick() || this.isPuma() || this.isUnicornServer();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 5, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/run/configuration/server/RailsServerRunConfiguration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedServer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/run/configuration/server/RailsServerRunConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPort";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIPAddr";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidModules";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRailsWorkDirByModule";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setServerType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLineState";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isExpectedServer";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 5, 9 -> new IllegalStateException(string);
        };
    }
}

