/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.run.configuration.server;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.browsers.JavaScriptDebuggerStarter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.TimerUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Timer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.rails.run.configuration.server.RailsServerRunConfiguration;
import org.jetbrains.plugins.ruby.rails.run.configuration.server.commandline.RailsServerRunCommandLineGenerator;
import org.jetbrains.plugins.ruby.rails.run.configuration.server.commandline.RailsServerRunCommandLineGeneratorFactory;
import org.jetbrains.plugins.ruby.ruby.run.PortForwarding;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyAbstractCommandLineState;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommandLineData;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;

public class RailsServerRunCommandLineState
extends RubyAbstractCommandLineState {
    @NonNls
    private static final String RAILS_SERVER_PARAMS_GROUP_ID = "ruby.rails.server";
    @NotNull
    private final RailsServerRunCommandLineGenerator myServerRunCommandLineGenerator;

    public RailsServerRunCommandLineState(RailsServerRunConfiguration config, ExecutionEnvironment env) {
        super(config, env, true);
        this.myServerRunCommandLineGenerator = RailsServerRunCommandLineGeneratorFactory.create(config);
    }

    @TestOnly
    public RailsServerRunCommandLineState(RailsServerRunConfiguration config) {
        super(config);
        this.myServerRunCommandLineGenerator = RailsServerRunCommandLineGeneratorFactory.create(config);
    }

    public RailsServerRunConfiguration getConfig() {
        return (RailsServerRunConfiguration)super.getConfig();
    }

    @Override
    @NotNull
    protected ProcessHandler createOSProcessHandler(@NotNull RubyRunner runner, @NotNull RubyCommandLine commandLine) throws ExecutionException {
        if (runner == null) {
            RailsServerRunCommandLineState.$$$reportNull$$$0(0);
        }
        if (commandLine == null) {
            RailsServerRunCommandLineState.$$$reportNull$$$0(1);
        }
        Sdk sdk = this.getConfig().getSdk();
        assert (sdk != null);
        if (this.getConfig().isPassenger() || this.getConfig().isJrubyServer()) {
            ProcessHandler processHandler = runner.createProcessHandler(commandLine, null);
            if (processHandler == null) {
                RailsServerRunCommandLineState.$$$reportNull$$$0(2);
            }
            return processHandler;
        }
        ProcessHandler processHandler = super.createOSProcessHandler(runner, commandLine);
        if (processHandler == null) {
            RailsServerRunCommandLineState.$$$reportNull$$$0(3);
        }
        return processHandler;
    }

    @Override
    protected RubyCommandLineData createRunCommandLine() throws ExecutionException {
        RailsServerRunConfiguration config = this.getConfig();
        String runnerId = this.getRunnerId();
        RubyCommandLineData data = RailsServerRunCommandLineState.createDefaultCommandLine(config, runnerId);
        this.myServerRunCommandLineGenerator.addEnvironmentVariables(config, data, runnerId);
        RubyCommandLine cmdLine = data.getCommandLine();
        Sdk sdk = config.getSdk();
        LOG.assertTrue(sdk != null);
        String executionScriptPath = RubySdkUtil.cygwinizePath(sdk, config.getRailsServerScriptPath(this.isInRubyDebugMode()));
        String scriptPath = RubySdkUtil.convertToRemote(sdk, config.getModule(), executionScriptPath);
        ParamsGroup serverParamsGroup = this.addExecutionScriptGroup(RAILS_SERVER_PARAMS_GROUP_ID, data, cmdLine, scriptPath);
        if (FileUtil.toSystemIndependentName((String)executionScriptPath).endsWith("bin/rails")) {
            serverParamsGroup.addParameter("server");
        }
        String server = config.getServerType();
        this.myServerRunCommandLineGenerator.addServerParameter(server, serverParamsGroup, this.isInRubyDebugMode());
        String hostAddress = (String)ObjectUtils.coalesce((Object)((String)cmdLine.getUserData(RubyCommandLineData.RACK_SERVER_HOST_KEY)), (Object)config.getIPAddr());
        Integer port = config.getPort().isEmpty() ? null : Integer.valueOf(config.getPort());
        this.myServerRunCommandLineGenerator.addIpAddressAndPortParameters(hostAddress, port, serverParamsGroup);
        if (port != null) {
            RunConfigurationUtil.addPortForwarding(data, PortForwarding.remoteToLocal(hostAddress, port, port));
        }
        this.myServerRunCommandLineGenerator.addEnvironmentParameter(config.getRailsEnvironmentType(), serverParamsGroup);
        RailsServerRunCommandLineState.addParams(serverParamsGroup, config.getScriptArgs());
        return data;
    }

    @Override
    public Pair<RubyCommandLineData, ProcessHandler> createCommandLineAndProcessHandler() throws ExecutionException {
        Pair<RubyCommandLineData, ProcessHandler> data = super.createCommandLineAndProcessHandler();
        ProcessHandler processHandler = (ProcessHandler)data.getSecond();
        final String url = this.getConfig().getBrowserUrl();
        if (url != null) {
            final Ref browserStarted = new Ref((Object)false);
            processHandler.addProcessListener(new ProcessListener(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (((Boolean)browserStarted.get()).booleanValue()) {
                        return;
                    }
                    String eventText = event.getText();
                    if (eventText.contains("started on") || StringUtil.containsIgnoreCase((String)eventText, (String)"pressing Ctrl-C.") || StringUtil.containsIgnoreCase((String)eventText, (String)"worker=0 spawned pid") || eventText.contains("-d to detach") || StringUtil.containsIgnoreCase((String)eventText, (String)"ctrl-c to")) {
                        browserStarted.set((Object)true);
                        Timer timer = TimerUtil.createNamedTimer((String)this.getClass().getName(), (int)5000, (ActionListener)new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent event1) {
                                RailsServerRunConfiguration config = RailsServerRunCommandLineState.this.getConfig();
                                if (RailsServerRunCommandLineState.this.isInRubyDebugMode() && config.isLaunchJavascriptDebugger()) {
                                    JavaScriptDebuggerStarter.Util.start((RunConfiguration)config, (String)url);
                                }
                                BrowserUtil.browse((String)url);
                            }
                        });
                        timer.setRepeats(false);
                        timer.start();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outputType";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/plugins/ruby/rails/run/configuration/server/RailsServerRunCommandLineState$1";
                    objectArray[2] = "onTextAvailable";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        return data;
    }

    @Override
    public List<Filter> createConsoleMessageFilters() {
        List<Filter> filters = super.createConsoleMessageFilters();
        RailsServerRunConfiguration config = this.getConfig();
        Project project = config.getProject();
        String workingDir = VfsUtil.getParentDir((String)config.getRailsServerScriptPath(this.isInRubyDebugMode()));
        Sdk sdk = config.getSdk();
        RailsServerRunCommandLineState.addConsoleFilters(filters, project, sdk, workingDir);
        return filters;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/run/configuration/server/RailsServerRunCommandLineState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/run/configuration/server/RailsServerRunCommandLineState";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createOSProcessHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createOSProcessHandler";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

