/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.run.configuration;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.console.config.IrbRunConfiguration;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.rails.ExternalRailsSettings;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.preload.spring.SpringUtil;
import org.jetbrains.plugins.ruby.rails.preload.zeus.ZeusUtil;
import org.jetbrains.plugins.ruby.rails.run.configuration.server.RailsServerRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;

public final class RailsRunConfigurationUtil {
    private static final String SCRIPT_CONSOLE = "script/console";

    private RailsRunConfigurationUtil() {
    }

    public static void inspectRailsSDK(@NotNull AbstractRubyRunConfiguration conf) throws RuntimeConfigurationError {
        if (conf == null) {
            RailsRunConfigurationUtil.$$$reportNull$$$0(0);
        }
        RunConfigurationUtil.inspectSDK(conf);
        Module module = conf.getModule();
        if (!RailsUtil.hasRailsSupportInSDKOrModule(conf.getSdk(), module)) {
            throw new RuntimeConfigurationError(RBundle.message((String)"sdk.error.no.rails.found"));
        }
    }

    public static void inspectJrubyServerGem(@NotNull RailsServerRunConfiguration conf) throws RuntimeConfigurationError {
        if (conf == null) {
            RailsRunConfigurationUtil.$$$reportNull$$$0(1);
        }
        String serverGem = conf.getServerType();
        String serverGemTitle = ExternalRailsSettings.getServerGemTitle(serverGem);
        Sdk sdk = conf.getSdk();
        if (!JRubySdkUtil.isJRubySDK(sdk)) {
            throw new RuntimeConfigurationError(RBundle.message((String)"sdk.error.jruby.jdk.type.incorrect", (Object[])new Object[]{serverGemTitle}));
        }
        Module module = conf.getModule();
        if (!GemUtil.isGemExecutableRubyScriptExists(module, sdk, serverGem, serverGem)) {
            throw new RuntimeConfigurationError(RBundle.message((String)"sdk.error.no.server.gem.found", (Object[])new Object[]{serverGemTitle}));
        }
    }

    public static void inspectNotJrubyServerGem(@NotNull RailsServerRunConfiguration conf) throws RuntimeConfigurationError {
        Sdk sdk;
        Module module;
        GemInfo gemInfo;
        if (conf == null) {
            RailsRunConfigurationUtil.$$$reportNull$$$0(2);
        }
        String serverGem = conf.getServerType();
        if (!(conf.isDefault() || conf.getServerType().equalsIgnoreCase("webrick") || (gemInfo = (module = conf.getModule()) != null ? RubyProjectGemSearchService.Companion.findGem(module, StringUtil.toLowerCase((String)serverGem)) : ((sdk = conf.getSdk()) != null ? RubyGemSearchUtil.findGem(module, sdk, StringUtil.toLowerCase((String)serverGem)) : null)) != null && gemInfo.isValid())) {
            throw new RuntimeConfigurationError(RBundle.message((String)"sdk.error.no.server.gem.found.rails3", (Object[])new Object[]{serverGem}));
        }
    }

    @Nullable
    public static VirtualFile getConsoleExecutable(@NotNull Module module, boolean useZeusServer) {
        VirtualFile scriptFile;
        String scriptPath;
        if (module == null) {
            RailsRunConfigurationUtil.$$$reportNull$$$0(3);
        }
        if (useZeusServer) {
            scriptPath = ZeusUtil.getZeusExecutable(module, RModuleUtil.getInstance().findRubySdkForModule(module));
            VirtualFile virtualFile = scriptFile = scriptPath != null ? LocalFileSystem.getInstance().refreshAndFindFileByPath(scriptPath) : null;
            if (scriptFile != null) {
                return scriptFile;
            }
        }
        if (useZeusServer && SpringUtil.isExplicitSpringEnabled() && SpringUtil.isSpringAvailable(module)) {
            scriptPath = SpringUtil.getSpringExecutable(module, RModuleUtil.getInstance().findRubySdkForModule(module));
            VirtualFile virtualFile = scriptFile = scriptPath != null ? LocalFileSystem.getInstance().refreshAndFindFileByPath(scriptPath) : null;
            if (scriptFile != null) {
                return scriptFile;
            }
        }
        String console4Script = (RailsRunConfigurationUtil.isEngine(module) ? "test/dummy/" : "") + "bin/rails";
        for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            VirtualFile file = root.findFileByRelativePath(SCRIPT_CONSOLE);
            if (file != null && file.isValid()) {
                return file;
            }
            VirtualFile file40 = root.findFileByRelativePath(console4Script);
            if (file40 == null || !file40.isValid()) continue;
            return file40;
        }
        return null;
    }

    @Nullable
    public static String getConsoleExecutablePath(@NotNull Module module, boolean useZeusServer) {
        if (module == null) {
            RailsRunConfigurationUtil.$$$reportNull$$$0(4);
        }
        return (String)ObjectUtils.doIfNotNull((Object)RailsRunConfigurationUtil.getConsoleExecutable(module, useZeusServer), VirtualFile::getPath);
    }

    private static boolean isEngine(@NotNull Module module) {
        RailsApp app;
        if (module == null) {
            RailsRunConfigurationUtil.$$$reportNull$$$0(5);
        }
        return (app = RailsApp.fromModule(module)) != null && app.isEngine();
    }

    public static void setWorkingDirectory(@NotNull Module module, @NotNull IrbRunConfiguration runConfiguration) {
        if (module == null) {
            RailsRunConfigurationUtil.$$$reportNull$$$0(6);
        }
        if (runConfiguration == null) {
            RailsRunConfigurationUtil.$$$reportNull$$$0(7);
        }
        Object workDir = RailsFacetUtil.getRailsAppHomeDirPath(module);
        if (RailsRunConfigurationUtil.isEngine(module)) {
            workDir = (String)workDir + "/test/dummy";
        }
        runConfiguration.setWorkingDirectory((String)workDir);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conf";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/run/configuration/RailsRunConfigurationUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "inspectRailsSDK";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "inspectJrubyServerGem";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "inspectNotJrubyServerGem";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getConsoleExecutable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getConsoleExecutablePath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isEngine";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setWorkingDirectory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

