/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.run;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Key;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyRunConfigurationExtension;
import org.jetbrains.plugins.ruby.ruby.run.configuration.rubyScript.RubyRunConfiguration;

public final class RailsRunConfigurationExtension
extends RubyRunConfigurationExtension {
    public static final Key<Boolean> KEY = Key.create((String)"SCRATCH_USE_RAILS_RUNNER");

    public boolean isApplicableFor(@NotNull AbstractRubyRunConfiguration configuration) {
        if (configuration == null) {
            RailsRunConfigurationExtension.$$$reportNull$$$0(0);
        }
        return true;
    }

    public boolean isEnabledFor(@NotNull AbstractRubyRunConfiguration applicableConfiguration, @Nullable RunnerSettings runnerSettings) {
        if (applicableConfiguration == null) {
            RailsRunConfigurationExtension.$$$reportNull$$$0(1);
        }
        return RailsRunConfigurationExtension.canEnableRailsRunner(applicableConfiguration);
    }

    protected void extendTemplateConfiguration(@NotNull AbstractRubyRunConfiguration<?> configuration) {
        if (configuration == null) {
            RailsRunConfigurationExtension.$$$reportNull$$$0(2);
        }
        configuration.putCopyableUserData(KEY, false);
    }

    protected void writeExternal(@NotNull AbstractRubyRunConfiguration<?> runConfiguration, @NotNull Element element) {
        Boolean data;
        if (runConfiguration == null) {
            RailsRunConfigurationExtension.$$$reportNull$$$0(3);
        }
        if (element == null) {
            RailsRunConfigurationExtension.$$$reportNull$$$0(4);
        }
        if ((data = (Boolean)runConfiguration.getCopyableUserData(KEY)) != null) {
            element.setAttribute(KEY.toString(), data.toString());
            if (data.booleanValue()) {
                runConfiguration.setWorkingDirectory(RailsRunConfigurationExtension.getRailsAppPath(runConfiguration.getModule()));
            }
        }
    }

    protected void readExternal(@NotNull AbstractRubyRunConfiguration<?> runConfiguration, @NotNull Element element) {
        Attribute attribute;
        if (runConfiguration == null) {
            RailsRunConfigurationExtension.$$$reportNull$$$0(5);
        }
        if (element == null) {
            RailsRunConfigurationExtension.$$$reportNull$$$0(6);
        }
        if ((attribute = element.getAttribute(KEY.toString())) != null) {
            runConfiguration.putCopyableUserData(KEY, Boolean.valueOf(attribute.getValue()));
        }
    }

    protected void patchCommandLine(@NotNull AbstractRubyRunConfiguration configuration, @Nullable RunnerSettings runnerSettings, @NotNull GeneralCommandLine cmdLine, @NotNull String runnerId) {
        Boolean useRailsRunner;
        if (configuration == null) {
            RailsRunConfigurationExtension.$$$reportNull$$$0(7);
        }
        if (cmdLine == null) {
            RailsRunConfigurationExtension.$$$reportNull$$$0(8);
        }
        if (runnerId == null) {
            RailsRunConfigurationExtension.$$$reportNull$$$0(9);
        }
        if (Boolean.TRUE.equals(useRailsRunner = (Boolean)configuration.getCopyableUserData(KEY))) {
            String path = RailsRunConfigurationExtension.getRailsAppPath(configuration.getModule());
            cmdLine.getParametersList().prepend(path + "/bin/rails");
            cmdLine.getParametersList().addAt(1, "runner");
        }
    }

    @Contract(value="null -> null")
    @Nullable
    private static String getRailsAppPath(@Nullable Module module) {
        return module != null ? RailsFacetUtil.getRailsAppHomeDirPath(module) : null;
    }

    public static boolean canEnableRailsRunner(@NotNull AbstractRubyRunConfiguration configuration) {
        if (configuration == null) {
            RailsRunConfigurationExtension.$$$reportNull$$$0(10);
        }
        return configuration instanceof RubyRunConfiguration && RailsUtil.getAllModulesWithRailsSupport(configuration.getProject()).length > 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicableConfiguration";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerId";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/run/RailsRunConfigurationExtension";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableFor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledFor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "extendTemplateConfiguration";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternal";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "readExternal";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "patchCommandLine";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "canEnableRailsRunner";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

