/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.run;

import com.intellij.execution.Location;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.model.RailsMigration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyRunConfigurationExtensionsManager;
import org.jetbrains.plugins.ruby.tasks.rake.runConfigurations.RakeRunConfiguration;
import org.jetbrains.plugins.ruby.tasks.rake.runConfigurations.RakeRunConfigurationType;

public final class MigrationRunConfigurationProducer
extends LazyRunConfigurationProducer<RakeRunConfiguration>
implements Cloneable {
    @NonNls
    public static final String RAKE_MIGRATE_TASK_NAME = "db:migrate";

    protected boolean setupConfigurationFromContext(@NotNull RakeRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref sourceElement) {
        Location location;
        if (configuration == null) {
            MigrationRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (context == null) {
            MigrationRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (sourceElement == null) {
            MigrationRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if ((location = context.getLocation()) == null) {
            return false;
        }
        RailsMigration migration = MigrationRunConfigurationProducer.getMigrationFromLocation(location);
        if (migration == null) {
            return false;
        }
        RunnerAndConfigurationSettings settings = RakeRunConfigurationType.getInstance().createConfiguration(migration.getModule(), RAKE_MIGRATE_TASK_NAME);
        configuration.setTaskName(settings.getConfiguration().getName());
        configuration.setName(settings.getConfiguration().getName());
        RubyRunConfigurationExtensionsManager.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration, location);
        return true;
    }

    @Nullable
    private static RailsMigration getMigrationFromLocation(@NotNull Location location) {
        PsiFile containingFile;
        if (location == null) {
            MigrationRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if ((containingFile = location.getPsiElement().getContainingFile()) == null) {
            return null;
        }
        return RailsMigration.fromFile(containingFile);
    }

    public boolean isConfigurationFromContext(@NotNull RakeRunConfiguration configuration, @NotNull ConfigurationContext context) {
        Location location;
        if (configuration == null) {
            MigrationRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (context == null) {
            MigrationRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        if ((location = context.getLocation()) == null || MigrationRunConfigurationProducer.getMigrationFromLocation(location) == null) {
            return false;
        }
        return RAKE_MIGRATE_TASK_NAME.equals(configuration.getTaskName());
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = RakeRunConfigurationType.getInstance().getConfigurationFactories()[0];
        if (configurationFactory == null) {
            MigrationRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        return configurationFactory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/run/MigrationRunConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/run/MigrationRunConfigurationProducer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMigrationFromLocation";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

