/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.rspec.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.model.RailsFileItem;
import org.jetbrains.plugins.ruby.rails.model.RailsView;
import org.jetbrains.plugins.ruby.rails.rspec.RailsRSpecUtil;

public class RailsRSpecViewTest
extends RailsFileItem {
    protected RailsRSpecViewTest(@NotNull VirtualFile viewFile, Module module) {
        if (viewFile == null) {
            RailsRSpecViewTest.$$$reportNull$$$0(0);
        }
        super(viewFile, module);
    }

    @Nullable
    public RailsView getView() {
        RailsApp app = this.getApp();
        VirtualFile specViewsRoot = app.getSpecTestsViewsRoot();
        List<VirtualFile> viewsRoots = app.getPaths().findFiles("app/views");
        if (specViewsRoot == null || viewsRoots.isEmpty()) {
            return null;
        }
        VirtualFile file = this.getFile();
        VirtualFile viewFile = RailsRSpecUtil.getMirroredFile(List.of(specViewsRoot), viewsRoots, file, StringUtil.trimEnd((String)file.getName(), (String)"_spec.rb"));
        if (viewFile == null) {
            return null;
        }
        return RailsView.fromFile(viewFile, app.getModule());
    }

    @Nullable
    public static RailsRSpecViewTest fromFile(@NotNull PsiFile file) {
        RailsApp app;
        if (file == null) {
            RailsRSpecViewTest.$$$reportNull$$$0(1);
        }
        if ((app = RailsApp.fromPsiElement((PsiElement)file)) == null) {
            return null;
        }
        VirtualFile specViewsRoot = app.getSpecTestsViewsRoot();
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)file);
        if (specViewsRoot == null || virtualFile == null || !VfsUtilCore.isAncestor((VirtualFile)specViewsRoot, (VirtualFile)virtualFile, (boolean)false)) {
            return null;
        }
        return new RailsRSpecViewTest(virtualFile, app.getModule());
    }

    @Nullable
    public static RailsRSpecViewTest fromView(@NotNull RailsView view) {
        if (view == null) {
            RailsRSpecViewTest.$$$reportNull$$$0(2);
        }
        RailsApp app = view.getApp();
        List<VirtualFile> viewsRoots = app.getPaths().findFiles("app/views");
        VirtualFile specViewsRoot = app.getSpecTestsViewsRoot();
        if (viewsRoots.isEmpty() || specViewsRoot == null) {
            return null;
        }
        VirtualFile file = view.getFile();
        VirtualFile testFile = RailsRSpecUtil.getMirroredFile(viewsRoots, List.of(specViewsRoot), file, file.getName() + "_spec.rb");
        if (testFile == null) {
            return null;
        }
        return new RailsRSpecViewTest(testFile, view.getModule());
    }

    public static String getFileNameBy(@NotNull String viewFileName) {
        if (viewFileName == null) {
            RailsRSpecViewTest.$$$reportNull$$$0(3);
        }
        return viewFileName + "_spec.rb";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewFileName";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/rspec/model/RailsRSpecViewTest";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "fromFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fromView";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileNameBy";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

