/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.rspec;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RailsRSpecUtil {
    public static final String SPEC_FILE_SUFFIX = "_spec.rb";
    @NonNls
    public static final String RSPEC_1x_INIT_GENERATOR_NAME = "rspec";
    @NonNls
    public static final String RSPEC_2_INIT_GENERATOR_NAME = "rspec:install";
    @NonNls
    public static final List<String> RSPEC_1x_GENERATORS = List.of("rspec_model", "rspec_controller", "rspec_scaffold", "integration_spec", "rspec");

    private RailsRSpecUtil() {
    }

    @Nullable
    public static VirtualFile getSpecTest(VirtualFile testsRoot, @NotNull List<VirtualFile> roots, VirtualFile itemParentFolder, @Nullable String itemName) {
        if (roots == null) {
            RailsRSpecUtil.$$$reportNull$$$0(0);
        }
        for (VirtualFile root : roots) {
            VirtualFile dir;
            if (itemParentFolder == null || testsRoot == null) continue;
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)itemParentFolder, (VirtualFile)root, (char)'/');
            if (relativePath == null) {
                return null;
            }
            VirtualFile virtualFile = dir = relativePath.isEmpty() ? testsRoot : testsRoot.findFileByRelativePath(relativePath);
            if (itemName == null) {
                return dir;
            }
            if (dir == null) continue;
            String fileName = itemName + SPEC_FILE_SUFFIX;
            return dir.findChild(fileName);
        }
        return null;
    }

    @Nullable
    public static VirtualFile getMirroredFile(@NotNull List<VirtualFile> oldRoots, @NotNull List<VirtualFile> newRoots, @NotNull VirtualFile file, @NotNull String name) {
        VirtualFile oldRoot;
        VirtualFile parent;
        if (oldRoots == null) {
            RailsRSpecUtil.$$$reportNull$$$0(1);
        }
        if (newRoots == null) {
            RailsRSpecUtil.$$$reportNull$$$0(2);
        }
        if (file == null) {
            RailsRSpecUtil.$$$reportNull$$$0(3);
        }
        if (name == null) {
            RailsRSpecUtil.$$$reportNull$$$0(4);
        }
        if ((parent = file.getParent()) == null) {
            return null;
        }
        String relativePath = null;
        Iterator<VirtualFile> iterator = oldRoots.iterator();
        while (iterator.hasNext() && (relativePath = VfsUtilCore.getRelativePath((VirtualFile)parent, (VirtualFile)(oldRoot = iterator.next()), (char)'/')) == null) {
        }
        for (VirtualFile newRoot : newRoots) {
            VirtualFile child = newRoot.findFileByRelativePath("%s/%s".formatted(relativePath, name));
            if (child == null) continue;
            return child;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRoots";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRoots";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/rspec/RailsRSpecUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getSpecTest";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getMirroredFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

