/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.routes;

import com.intellij.microservices.url.UrlPath;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.routes.RailsRoute;
import org.jetbrains.plugins.ruby.rails.routes.RoutesCallable;
import org.jetbrains.plugins.ruby.rails.routes.RoutesInfo;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.RubyModificationTrackers;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.interpret.PsiCallable;
import org.jetbrains.plugins.ruby.ruby.interpret.RCallArguments;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyPsiInterpreter;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;

public final class RoutesParser {
    private final Project myProject;
    private final Module myModule;
    private final AtomicLong myTestStamp;

    public RoutesParser(@NotNull Module module) {
        if (module == null) {
            RoutesParser.$$$reportNull$$$0(0);
        }
        this.myTestStamp = new AtomicLong();
        this.myProject = module.getProject();
        this.myModule = module;
    }

    @TestOnly
    public void cleanupForNextText() {
        this.myTestStamp.incrementAndGet();
    }

    @NotNull
    public List<UrlPath> getUrlPathsFor(@NotNull FQN target) {
        if (target == null) {
            RoutesParser.$$$reportNull$$$0(1);
        }
        List<UrlPath> list = this.getRoutesInfo().getRoutes().values().stream().flatMap(Collection::stream).filter(it -> it.getTarget().equals((Object)target)).flatMap(it -> Stream.ofNullable(it.getPath())).toList();
        if (list == null) {
            RoutesParser.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public List<FQN> getActionFqns(@NotNull PsiElement element) {
        if (element == null) {
            RoutesParser.$$$reportNull$$$0(3);
        }
        List<FQN> list = this.getRoutesInfo().getActionFqns(element);
        if (list == null) {
            RoutesParser.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public FQN getControllerFqn(@NotNull PsiElement element) {
        if (element == null) {
            RoutesParser.$$$reportNull$$$0(5);
        }
        FQN fQN = this.getRoutesInfo().getControllerFqn(element);
        if (fQN == null) {
            RoutesParser.$$$reportNull$$$0(6);
        }
        return fQN;
    }

    @NotNull
    public List<PsiElement> getElementsForActionFqn(@NotNull FQN fqn) {
        if (fqn == null) {
            RoutesParser.$$$reportNull$$$0(7);
        }
        List<PsiElement> list = this.getRoutesInfo().getElementsForActionFqn(fqn);
        if (list == null) {
            RoutesParser.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public List<PsiElement> getElementsForControllerFqn(@NotNull FQN fqn) {
        if (fqn == null) {
            RoutesParser.$$$reportNull$$$0(9);
        }
        List<PsiElement> list = this.getRoutesInfo().getElementsForControllerFqn(fqn);
        if (list == null) {
            RoutesParser.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    public FQN getNamespaceFqn(@NotNull PsiElement element) {
        if (element == null) {
            RoutesParser.$$$reportNull$$$0(11);
        }
        FQN fQN = this.getRoutesInfo().getNamespaceFqn(element);
        if (fQN == null) {
            RoutesParser.$$$reportNull$$$0(12);
        }
        return fQN;
    }

    @NotNull
    public Map<PsiElement, List<RailsRoute>> getRoutes() {
        Map<PsiElement, List<RailsRoute>> map = this.getRoutesInfo().getRoutes();
        if (map == null) {
            RoutesParser.$$$reportNull$$$0(13);
        }
        return map;
    }

    @TestOnly
    public void reparse() {
        this.cleanupForNextText();
        this.getRoutesInfo();
    }

    @NotNull
    private RoutesInfo getRoutesInfo() {
        if (DumbService.isDumb((Project)this.myProject)) {
            RoutesInfo routesInfo = (RoutesInfo)new MyRoutesInfoProvider(this.myProject, this.myModule, this.myTestStamp).compute().getValue();
            if (routesInfo == null) {
                RoutesParser.$$$reportNull$$$0(14);
            }
            return routesInfo;
        }
        RoutesInfo routesInfo = (RoutesInfo)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)this.myModule, (CachedValueProvider)new MyRoutesInfoProvider(this.myProject, this.myModule, this.myTestStamp));
        if (routesInfo == null) {
            RoutesParser.$$$reportNull$$$0(15);
        }
        return routesInfo;
    }

    @NotNull
    public static RoutesParser getInstance(@NotNull Module module) {
        if (module == null) {
            RoutesParser.$$$reportNull$$$0(16);
        }
        RoutesParser routesParser = (RoutesParser)module.getService(RoutesParser.class);
        if (routesParser == null) {
            RoutesParser.$$$reportNull$$$0(17);
        }
        return routesParser;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6, 8, 10, 12, 13, 14, 15, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/routes/RoutesParser";
                break;
            }
            case 3: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/routes/RoutesParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlPathsFor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionFqns";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getControllerFqn";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsForActionFqn";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsForControllerFqn";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceFqn";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoutes";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoutesInfo";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getUrlPathsFor";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getActionFqns";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getControllerFqn";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getElementsForActionFqn";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getElementsForControllerFqn";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceFqn";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 6, 8, 10, 12, 13, 14, 15, 17 -> new IllegalStateException(string);
        };
    }

    private static final class MyRoutesInfoProvider
    implements CachedValueProvider<RoutesInfo> {
        private final Project myProject;
        private final Module myModule;
        private final AtomicLong myTestStamp;

        private MyRoutesInfoProvider(@NotNull Project project, @NotNull Module module, @NotNull AtomicLong testStamp) {
            if (project == null) {
                MyRoutesInfoProvider.$$$reportNull$$$0(0);
            }
            if (module == null) {
                MyRoutesInfoProvider.$$$reportNull$$$0(1);
            }
            if (testStamp == null) {
                MyRoutesInfoProvider.$$$reportNull$$$0(2);
            }
            this.myProject = project;
            this.myModule = module;
            this.myTestStamp = testStamp;
        }

        @NotNull
        public CachedValueProvider.Result<RoutesInfo> compute() {
            RailsApp.RoutesFiles<RFile> files = this.getRoutesFiles();
            RoutesInfo info = this.parseRoutesFiles(files);
            HashSet<Object> dependencies = new HashSet<Object>();
            dependencies.addAll(files.getMainRoutesFiles());
            dependencies.addAll(files.getAdditionalRoutesFiles());
            dependencies.addAll(RubyModificationTrackers.getRailsSettingsModificationTrackers(this.myProject, this.myModule));
            dependencies.add(() -> this.myTestStamp.get());
            CachedValueProvider.Result result = CachedValueProvider.Result.create((Object)info, dependencies);
            if (result == null) {
                MyRoutesInfoProvider.$$$reportNull$$$0(3);
            }
            return result;
        }

        @NotNull
        public RailsApp.RoutesFiles<RFile> getRoutesFiles() {
            RailsApp app = RailsApp.fromModule(this.myModule);
            if (app == null) {
                RailsApp.RoutesFiles<RFile> routesFiles = RailsApp.RoutesFiles.empty();
                if (routesFiles == null) {
                    MyRoutesInfoProvider.$$$reportNull$$$0(4);
                }
                return routesFiles;
            }
            PsiManager manager = PsiManager.getInstance((Project)this.myProject);
            RailsApp.RoutesFiles<VirtualFile> virtualFiles = app.getRoutesFiles();
            List mainRoutesFiles = ContainerUtil.mapNotNull(virtualFiles.getMainRoutesFiles(), file -> (RFile)ObjectUtils.tryCast((Object)manager.findFile(file), RFile.class));
            List additionalRoutesFiles = ContainerUtil.mapNotNull(virtualFiles.getAdditionalRoutesFiles(), file -> (RFile)ObjectUtils.tryCast((Object)manager.findFile(file), RFile.class));
            RailsApp.RoutesFiles<RFile> routesFiles = RailsApp.RoutesFiles.create(mainRoutesFiles, additionalRoutesFiles);
            if (routesFiles == null) {
                MyRoutesInfoProvider.$$$reportNull$$$0(5);
            }
            return routesFiles;
        }

        @NotNull
        private RoutesInfo parseRoutesFiles(@NotNull RailsApp.RoutesFiles<RFile> files) {
            if (files == null) {
                MyRoutesInfoProvider.$$$reportNull$$$0(6);
            }
            if (files.isEmpty()) {
                RoutesInfo routesInfo = RoutesInfo.EMPTY;
                if (routesInfo == null) {
                    MyRoutesInfoProvider.$$$reportNull$$$0(7);
                }
                return routesInfo;
            }
            RubyPsiInterpreter interpreter = new RubyPsiInterpreter(true);
            final RoutesCallable routes = new RoutesCallable(this.myModule);
            PsiCallable callable = new PsiCallable(){

                @Override
                public void processCall(@NotNull RCallArguments arguments) {
                    if (arguments == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (arguments.getCommand().equals("draw")) {
                        arguments.interpretBlockWithGivenSelf(routes, routes);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/plugins/ruby/rails/routes/RoutesParser$MyRoutesInfoProvider$1", "processCall"));
                }
            };
            for (RFile file : files.getMainRoutesFiles()) {
                interpreter.interpret((PsiElement)file, callable);
            }
            for (RFile file : files.getAdditionalRoutesFiles()) {
                interpreter.child().interpret((PsiElement)file, routes);
            }
            RoutesInfo routesInfo = routes.getRoutesInfo();
            if (routesInfo == null) {
                MyRoutesInfoProvider.$$$reportNull$$$0(8);
            }
            return routesInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5, 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "testStamp";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/routes/RoutesParser$MyRoutesInfoProvider";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/routes/RoutesParser$MyRoutesInfoProvider";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "compute";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRoutesFiles";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parseRoutesFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "parseRoutesFiles";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5, 7, 8 -> new IllegalStateException(string);
            };
        }
    }
}

