/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.routes;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rails.routes.RailsRoute;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;

final class RoutesInfo {
    static final RoutesInfo EMPTY = new RoutesInfo();
    private final List<Pair<SmartPsiElementPointer<?>, RailsRoute>> myRoutes = Collections.synchronizedList(new ArrayList());
    private final List<Pair<SmartPsiElementPointer<?>, FQN>> myNamespaceFqns = Collections.synchronizedList(new ArrayList());
    private final List<Pair<SmartPsiElementPointer<?>, FQN>> myControllerFqns = Collections.synchronizedList(new ArrayList());
    private final List<Pair<SmartPsiElementPointer<?>, FQN>> myActionFqns = Collections.synchronizedList(new ArrayList());

    RoutesInfo() {
    }

    public void addActionFqn(@NotNull PsiElement element, @NotNull FQN fqn) {
        if (element == null) {
            RoutesInfo.$$$reportNull$$$0(0);
        }
        if (fqn == null) {
            RoutesInfo.$$$reportNull$$$0(1);
        }
        if (fqn != FQN.INVALID) {
            this.myActionFqns.add(new Pair((Object)SmartPointerManager.createPointer((PsiElement)element), (Object)fqn));
        }
    }

    public void addControllerFqn(@NotNull PsiElement element, @NotNull FQN fqn) {
        if (element == null) {
            RoutesInfo.$$$reportNull$$$0(2);
        }
        if (fqn == null) {
            RoutesInfo.$$$reportNull$$$0(3);
        }
        if (fqn != FQN.INVALID) {
            this.myControllerFqns.add(new Pair((Object)SmartPointerManager.createPointer((PsiElement)element), (Object)fqn));
        }
    }

    public void addNamespaceFqn(@NotNull PsiElement element, @NotNull FQN fqn) {
        if (element == null) {
            RoutesInfo.$$$reportNull$$$0(4);
        }
        if (fqn == null) {
            RoutesInfo.$$$reportNull$$$0(5);
        }
        if (fqn != FQN.INVALID) {
            this.myNamespaceFqns.add(new Pair((Object)SmartPointerManager.createPointer((PsiElement)element), (Object)fqn));
        }
    }

    public void addRoute(@NotNull PsiElement declaringElement, @NotNull RailsRoute route) {
        if (declaringElement == null) {
            RoutesInfo.$$$reportNull$$$0(6);
        }
        if (route == null) {
            RoutesInfo.$$$reportNull$$$0(7);
        }
        this.myRoutes.add(new Pair((Object)SmartPointerManager.createPointer((PsiElement)declaringElement), (Object)route));
    }

    @NotNull
    public List<FQN> getActionFqns(@NotNull PsiElement element) {
        if (element == null) {
            RoutesInfo.$$$reportNull$$$0(8);
        }
        List<FQN> list = RoutesInfo.getValues(this.myActionFqns, element);
        if (list == null) {
            RoutesInfo.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public FQN getControllerFqn(@NotNull PsiElement element) {
        if (element == null) {
            RoutesInfo.$$$reportNull$$$0(10);
        }
        FQN fQN = (FQN)ContainerUtil.getLastItem(RoutesInfo.getValues(this.myControllerFqns, element), (Object)FQN.INVALID);
        if (fQN == null) {
            RoutesInfo.$$$reportNull$$$0(11);
        }
        return fQN;
    }

    @NotNull
    public List<PsiElement> getElementsForActionFqn(@NotNull FQN fqn) {
        if (fqn == null) {
            RoutesInfo.$$$reportNull$$$0(12);
        }
        ArrayList elements = new ArrayList();
        for (Pair<SmartPsiElementPointer<?>, RailsRoute> pair : this.myRoutes) {
            if (!((RailsRoute)pair.second).getTarget().equals((Object)fqn)) continue;
            ContainerUtil.addIfNotNull(elements, (Object)((SmartPsiElementPointer)pair.first).dereference());
        }
        List<PsiElement> list = Collections.unmodifiableList(elements);
        if (list == null) {
            RoutesInfo.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    public List<PsiElement> getElementsForControllerFqn(@NotNull FQN fqn) {
        if (fqn == null) {
            RoutesInfo.$$$reportNull$$$0(14);
        }
        ArrayList elements = new ArrayList();
        for (Pair<SmartPsiElementPointer<?>, RailsRoute> pair : this.myRoutes) {
            if (!((RailsRoute)pair.second).getTarget().getCallerFQN().equals((Object)fqn)) continue;
            ContainerUtil.addIfNotNull(elements, (Object)((SmartPsiElementPointer)pair.first).dereference());
        }
        List<PsiElement> list = Collections.unmodifiableList(elements);
        if (list == null) {
            RoutesInfo.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    public FQN getNamespaceFqn(@NotNull PsiElement namespace) {
        if (namespace == null) {
            RoutesInfo.$$$reportNull$$$0(16);
        }
        FQN fQN = (FQN)ContainerUtil.getLastItem(RoutesInfo.getValues(this.myNamespaceFqns, namespace), (Object)FQN.INVALID);
        if (fQN == null) {
            RoutesInfo.$$$reportNull$$$0(17);
        }
        return fQN;
    }

    @NotNull
    public Set<String> getPrefixes() {
        Set<String> set = this.myRoutes.stream().flatMap(it -> Stream.ofNullable(((RailsRoute)it.getSecond()).getPrefix())).filter(it -> !it.isBlank()).collect(Collectors.toUnmodifiableSet());
        if (set == null) {
            RoutesInfo.$$$reportNull$$$0(18);
        }
        return set;
    }

    @NotNull
    public Map<PsiElement, List<RailsRoute>> getRoutes() {
        HashMap<PsiElement, List> routes = new HashMap<PsiElement, List>();
        for (Pair<SmartPsiElementPointer<?>, RailsRoute> pair : this.myRoutes) {
            PsiElement element = ((SmartPsiElementPointer)pair.first).dereference();
            if (element == null) continue;
            routes.computeIfAbsent(element, __ -> new ArrayList()).add((RailsRoute)pair.second);
        }
        Map<PsiElement, List<RailsRoute>> map = Collections.unmodifiableMap(routes);
        if (map == null) {
            RoutesInfo.$$$reportNull$$$0(19);
        }
        return map;
    }

    private static <T> List<T> getValues(@NotNull List<Pair<SmartPsiElementPointer<?>, T>> data, @NotNull PsiElement element) {
        VirtualFile virtualFile;
        if (data == null) {
            RoutesInfo.$$$reportNull$$$0(20);
        }
        if (element == null) {
            RoutesInfo.$$$reportNull$$$0(21);
        }
        if ((virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element)) == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> values = new ArrayList<Object>();
        for (Pair<SmartPsiElementPointer<?>, T> pair : data) {
            SmartPsiElementPointer pointer = (SmartPsiElementPointer)pair.first;
            if (!virtualFile.equals(pointer.getVirtualFile()) || !element.equals((Object)pointer.dereference())) continue;
            values.add(pair.second);
        }
        return Collections.unmodifiableList(values);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 11, 13, 15, 17, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaringElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "route";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/routes/RoutesInfo";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/routes/RoutesInfo";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionFqns";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getControllerFqn";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsForActionFqn";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsForControllerFqn";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceFqn";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefixes";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoutes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addActionFqn";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addControllerFqn";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addNamespaceFqn";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addRoute";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getActionFqns";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getControllerFqn";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getElementsForActionFqn";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getElementsForControllerFqn";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceFqn";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 11, 13, 15, 17, 18, 19 -> new IllegalStateException(string);
        };
    }
}

