/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.routes;

import com.intellij.DynamicBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.nameConventions.ControllersConventions;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.interpret.RCallArguments;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

final class RailsRouteUtil {
    private static final Set<String> METHOD_NAMES = Set.of("CONNECT", "DELETE", "GET", "HEAD", "OPTIONS", "PATCH", "POST", "PUT", "TRACE");

    private RailsRouteUtil() {
    }

    @NotNull
    static FQN getControllerFqn(@NotNull String controller, @Nullable Module module) {
        if (controller == null) {
            RailsRouteUtil.$$$reportNull$$$0(0);
        }
        FQN fQN = FQN.of((String)ControllersConventions.getControllerClassName(controller, module));
        if (fQN == null) {
            RailsRouteUtil.$$$reportNull$$$0(1);
        }
        return fQN;
    }

    @NotNull
    static FQN getControllerFqn(@NotNull String namespace, @NotNull String controller, @Nullable Module module) {
        if (namespace == null) {
            RailsRouteUtil.$$$reportNull$$$0(2);
        }
        if (controller == null) {
            RailsRouteUtil.$$$reportNull$$$0(3);
        }
        FQN fQN = FQN.Builder.concat((FQN)RailsRouteUtil.getNamespaceFqn(namespace, module), (String)ControllersConventions.getControllerClassName(controller, module));
        if (fQN == null) {
            RailsRouteUtil.$$$reportNull$$$0(4);
        }
        return fQN;
    }

    @NotNull
    static FQN getNamespaceFqn(@NotNull String namespace, @Nullable Module module) {
        if (namespace == null) {
            RailsRouteUtil.$$$reportNull$$$0(5);
        }
        FQN fQN = FQN.of((String)NamingConventions.toCamelCase((String)namespace, (Module)module));
        if (fQN == null) {
            RailsRouteUtil.$$$reportNull$$$0(6);
        }
        return fQN;
    }

    @NotNull
    static String getNormalizedPrefixForMatcher(@NotNull String path) {
        if (path == null) {
            RailsRouteUtil.$$$reportNull$$$0(7);
        }
        if (StringUtil.findFirst((CharSequence)path, c -> !Character.isLetterOrDigit(c) && c != '/' && c != '_') != -1) {
            return "";
        }
        while (path.contains("//")) {
            path = path.replace("//", "/");
        }
        String string = StringUtil.trim((String)path, c -> c != '/').replaceAll("/", "_");
        if (string == null) {
            RailsRouteUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    static Set<String> getVerbsForMatcher(@NotNull RCallArguments arguments) {
        if (arguments == null) {
            RailsRouteUtil.$$$reportNull$$$0(9);
        }
        Set<Object> set = switch (arguments.getCommand()) {
            case "get", "root" -> Set.of("GET");
            case "delete" -> Set.of("DELETE");
            case "match" -> {
                List<String> via = arguments.getOptionValues("via");
                if (via == null) {
                    yield Collections.emptySet();
                }
                if (via.contains("all")) {
                    yield METHOD_NAMES;
                }
                yield Set.copyOf(ContainerUtil.filter(METHOD_NAMES, it -> via.contains(it.toLowerCase(DynamicBundle.getLocale()))));
            }
            case "patch" -> Set.of("PATCH");
            case "post" -> Set.of("POST");
            case "put" -> Set.of("PUT");
            default -> Collections.emptySet();
        };
        if (set == null) {
            RailsRouteUtil.$$$reportNull$$$0(10);
        }
        return set;
    }

    @NotNull
    static Set<String> getVerbsForResourceAction(@NotNull String action) {
        if (action == null) {
            RailsRouteUtil.$$$reportNull$$$0(11);
        }
        Set<Object> set = switch (action) {
            case "create" -> Set.of("POST");
            case "destroy" -> Set.of("DELETE");
            case "edit", "index", "new", "show" -> Set.of("GET");
            case "update" -> Set.of("PATCH", "PUT");
            default -> Collections.emptySet();
        };
        if (set == null) {
            RailsRouteUtil.$$$reportNull$$$0(12);
        }
        return set;
    }

    @NotNull
    static String joinNamespace(String ... components) {
        if (components == null) {
            RailsRouteUtil.$$$reportNull$$$0(13);
        }
        String string = Stream.of(components).filter(StringUtil::isNotEmpty).collect(Collectors.joining("/"));
        if (string == null) {
            RailsRouteUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    static String joinPrefix(String ... components) {
        if (components == null) {
            RailsRouteUtil.$$$reportNull$$$0(15);
        }
        String string = Stream.of(components).filter(StringUtil::isNotEmpty).collect(Collectors.joining("_"));
        if (string == null) {
            RailsRouteUtil.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 6, 8, 10, 12, 14, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/routes/RailsRouteUtil";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/routes/RailsRouteUtil";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getControllerFqn";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceFqn";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedPrefixForMatcher";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getVerbsForMatcher";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getVerbsForResourceAction";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "joinNamespace";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "joinPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getControllerFqn";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceFqn";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedPrefixForMatcher";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getVerbsForMatcher";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getVerbsForResourceAction";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "joinNamespace";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "joinPrefix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 6, 8, 10, 12, 14, 16 -> new IllegalStateException(string);
        };
    }
}

