/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.routes;

import com.intellij.microservices.url.UrlPath;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.devise.DeviseCallTypeProvider;
import org.jetbrains.plugins.ruby.rails.devise.DeviseForCallType;
import org.jetbrains.plugins.ruby.rails.devise.DeviseModule;
import org.jetbrains.plugins.ruby.rails.devise.DeviseNameIndex;
import org.jetbrains.plugins.ruby.rails.routes.RailsRouteScope;
import org.jetbrains.plugins.ruby.rails.routes.RailsRouteUtil;
import org.jetbrains.plugins.ruby.rails.routes.RoutesCallable;
import org.jetbrains.plugins.ruby.rails.routes.RoutesInfo;
import org.jetbrains.plugins.ruby.rails.routes.RubyRoutesProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.values.StringValue;
import org.jetbrains.plugins.ruby.ruby.codeInsight.values.StringValueUtil;
import org.jetbrains.plugins.ruby.ruby.interpret.RCallArguments;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyInterpretUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;

public final class DeviseRoutesProvider
implements RubyRoutesProvider {
    @Override
    public boolean canGenerateRoutesForCommand(@NotNull String command) {
        if (command == null) {
            DeviseRoutesProvider.$$$reportNull$$$0(0);
        }
        return command.equals(DeviseCallTypeProvider.DEVISE_FOR.getCommandName());
    }

    @Override
    public void generateRoutes(@NotNull RoutesCallable routesCallable, @NotNull RCallArguments arguments) {
        PsiElement rCall;
        Module module;
        if (routesCallable == null) {
            DeviseRoutesProvider.$$$reportNull$$$0(1);
        }
        if (arguments == null) {
            DeviseRoutesProvider.$$$reportNull$$$0(2);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)(rCall = arguments.getRCallElement()))) == null) {
            return;
        }
        if (!(rCall instanceof RCall)) {
            return;
        }
        RCall call = (RCall)rCall;
        DeviseForCallType.DeviseData data = (DeviseForCallType.DeviseData)call.getData(new RubyCallType[]{DeviseCallTypeProvider.DEVISE_FOR});
        if (data.getClassifiedModelName(module) == null) {
            return;
        }
        DeviseForRoutesGenerator deviseForRoutesGenerator = new DeviseForRoutesGenerator(arguments, data, routesCallable, module);
        deviseForRoutesGenerator.generateRoutes();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routesCallable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/routes/DeviseRoutesProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canGenerateRoutesForCommand";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "generateRoutes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class DeviseForRoutesGenerator {
        @NotNull
        private final RCallArguments myCallArguments;
        @NotNull
        private final RoutesCallable myRoutesCallable;
        @NotNull
        private final RCall myDeviseForCall;
        @NotNull
        private final DeviseForCallType.DeviseData myDeviseData;
        @NotNull
        private final Module myModule;

        private DeviseForRoutesGenerator(@NotNull RCallArguments arguments, @NotNull DeviseForCallType.DeviseData deviseData, @NotNull RoutesCallable routesCallable, @NotNull Module module) {
            if (arguments == null) {
                DeviseForRoutesGenerator.$$$reportNull$$$0(0);
            }
            if (deviseData == null) {
                DeviseForRoutesGenerator.$$$reportNull$$$0(1);
            }
            if (routesCallable == null) {
                DeviseForRoutesGenerator.$$$reportNull$$$0(2);
            }
            if (module == null) {
                DeviseForRoutesGenerator.$$$reportNull$$$0(3);
            }
            this.myCallArguments = arguments;
            this.myDeviseData = deviseData;
            this.myDeviseForCall = (RCall)arguments.getRCallElement();
            this.myRoutesCallable = new RoutesCallable(routesCallable.getRoutesInfo(), routesCallable.getRouteScope().builder("devise_scope").withPrefix(deviseData.getSingularModelName(module)).withPath((String)ObjectUtils.coalesce((Object)this.getSpecifiedPath(), (Object)deviseData.getPluralModelName())).build());
            this.myModule = module;
        }

        private void generateRoutes() {
            Set<DeviseModule> deviseModelGroups = this.resolveDeclaredDeviseModelGroups();
            if (deviseModelGroups.contains((Object)DeviseModule.DATABASE_AUTHENTICATABLE) && !this.isSkipOrExcluded("sessions")) {
                this.generateAuthenticatable();
            }
            if (deviseModelGroups.contains((Object)DeviseModule.RECOVERABLE) && !this.isSkipOrExcluded("passwords")) {
                this.generateRoutesForRecoverableGroup();
            }
            if (deviseModelGroups.contains((Object)DeviseModule.CONFIRMABLE) && !this.isSkipOrExcluded("confirmations")) {
                this.generateRoutesForConfirmableGroup();
            }
            if (deviseModelGroups.contains((Object)DeviseModule.LOCKABLE) && !this.isSkipOrExcluded("unlocks")) {
                this.generateRoutesForLockableGroup();
            }
            if (deviseModelGroups.contains((Object)DeviseModule.REGISTERABLE) && !this.isSkipOrExcluded("registrations")) {
                this.generateRoutesForRegisterableGroup();
            }
            this.myRoutesCallable.getRoutesInfo().addNamespaceFqn(this.myCallArguments.getCallElement(), this.myRoutesCallable.getRouteScope().getModuleFqn());
        }

        @NotNull
        private Set<DeviseModule> resolveDeclaredDeviseModelGroups() {
            Project project = this.myModule.getProject();
            GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)project);
            String classifiedModelName = this.myDeviseData.getClassifiedModelName(this.myModule);
            if (classifiedModelName == null) {
                Set<DeviseModule> set = Collections.emptySet();
                if (set == null) {
                    DeviseForRoutesGenerator.$$$reportNull$$$0(4);
                }
                return set;
            }
            Collection deviseCallCollection = DeviseNameIndex.getInstance().getElements(project, (SearchScope)searchScope, classifiedModelName);
            if (deviseCallCollection.isEmpty()) {
                Set<DeviseModule> set = Collections.emptySet();
                if (set == null) {
                    DeviseForRoutesGenerator.$$$reportNull$$$0(5);
                }
                return set;
            }
            RCall deviseCall = (RCall)deviseCallCollection.iterator().next();
            EnumSet<DeviseModule> groupSet = EnumSet.noneOf(DeviseModule.class);
            for (String groupName : (List)deviseCall.getData(new RubyCallType[]{DeviseCallTypeProvider.DEVISE})) {
                groupSet.add(DeviseModule.fromName(groupName.toUpperCase(Locale.ROOT)));
            }
            EnumSet<DeviseModule> enumSet = groupSet;
            if (enumSet == null) {
                DeviseForRoutesGenerator.$$$reportNull$$$0(6);
            }
            return enumSet;
        }

        @NotNull
        private RailsRouteScope getRouteScope() {
            RailsRouteScope railsRouteScope = this.myRoutesCallable.getRouteScope();
            if (railsRouteScope == null) {
                DeviseForRoutesGenerator.$$$reportNull$$$0(7);
            }
            return railsRouteScope;
        }

        @NotNull
        private RoutesInfo getRoutesInfo() {
            RoutesInfo routesInfo = this.myRoutesCallable.getRoutesInfo();
            if (routesInfo == null) {
                DeviseForRoutesGenerator.$$$reportNull$$$0(8);
            }
            return routesInfo;
        }

        private void generateAuthenticatable() {
            RailsRouteScope.Builder builder2 = this.getRouteScope().builder("resource").withParam((Pair<String, String>)new Pair((Object)"session", (Object)"id")).withOnly(Collections.emptyList()).withPath("").withPrefix("session").withController("sessions");
            RoutesCallable routesCallable = new RoutesCallable(this.getRoutesInfo(), builder2.build());
            this.createRoutesForMatcher(routesCallable, "get", Map.ofEntries(Map.entry("action", "new"), Map.entry("as", "new"), Map.entry("path", "sign_in")), Set.of("GET"), false, true);
            this.createRoutesForMatcher(routesCallable, "post", Map.ofEntries(Map.entry("action", "create"), Map.entry("as", ""), Map.entry("path", "sign_in")), Set.of("POST"), false, true);
            this.createRoutesForMatcher(routesCallable, "match", Map.ofEntries(Map.entry("action", "destroy"), Map.entry("as", "destroy"), Map.entry("path", "sign_out")), (Set)ObjectUtils.coalesce(this.getSignOutVerbSet(), Set.of("DELETE")), false, true);
        }

        private void generateRoutesForRecoverableGroup() {
            RoutesCallable routesCallable = new RoutesCallable(this.getRoutesInfo(), this.getRouteScope().builder("resource").withOnly(List.of("new", "create", "edit", "update")).withPrefix("password").withPath(this.getPathName("password")).withController("passwords").build());
            this.createRoutesForResource(routesCallable);
        }

        private void generateRoutesForConfirmableGroup() {
            RoutesCallable routesCallable = new RoutesCallable(this.getRoutesInfo(), this.getRouteScope().builder("resource").withOnly(List.of("new", "create", "show")).withPrefix("confirmation").withPath(this.getPathName("confirmation")).withController("confirmations").build());
            this.createRoutesForResource(routesCallable);
        }

        private void generateRoutesForLockableGroup() {
            RoutesCallable routesCallable = new RoutesCallable(this.getRoutesInfo(), this.getRouteScope().builder("resource").withOnly(List.of("new", "create", "show")).withPrefix("unlock").withPath(this.getPathName("unlock")).withController("unlocks").build());
            this.createRoutesForResource(routesCallable);
        }

        private void generateRoutesForRegisterableGroup() {
            RoutesCallable routesCallable = new RoutesCallable(this.getRoutesInfo(), this.getRouteScope().builder("resource").withOnly(List.of("new", "create", "edit", "update", "destroy")).withPath(this.getPathName("registration")).withPrefix("registration").withPathNames(Map.ofEntries(Map.entry("new", StringValueUtil.createConstantStringValue((String)this.getPathName("sign_up"))), Map.entry("edit", StringValueUtil.createConstantStringValue((String)this.getPathName("edit"))), Map.entry("cancel", StringValueUtil.createConstantStringValue((String)this.getPathName("cancel"))))).withController("registrations").build());
            this.createRoutesForResource(routesCallable);
            this.createRoutesForMatcher(routesCallable, "get", Map.ofEntries(Map.entry("action", "cancel"), Map.entry("as", "cancel"), Map.entry("path", "cancel")), Set.of("GET"), false, true);
        }

        private void createRoutesForResource(@NotNull RoutesCallable routesCallable) {
            if (routesCallable == null) {
                DeviseForRoutesGenerator.$$$reportNull$$$0(9);
            }
            RailsRouteScope scope = routesCallable.getRouteScope();
            PsiElement psiElement = this.myCallArguments.getCallElement();
            FQN controllerFqn = this.getControllerFqn(scope, scope.getController());
            for (String action : scope.getActionsForResource()) {
                routesCallable.getRoutesInfo().addActionFqn(psiElement, FQN.Builder.concat((FQN)controllerFqn, (String)action));
                String prefix = scope.getPrefixForResourceAction(action);
                Set<String> verbs = RailsRouteUtil.getVerbsForResourceAction(action);
                UrlPath path = scope.getPathForResourceAction(action);
                FQN target = FQN.Builder.concat((FQN)controllerFqn, (String)action);
                if (prefix == null) continue;
                routesCallable.addRoutes(psiElement, prefix, verbs, path, target);
            }
        }

        private void createRoutesForMatcher(@NotNull RoutesCallable routesCallable, @NotNull String matcher, @NotNull Map<String, String> arguments, @NotNull Set<String> verbs, boolean collection, boolean member) {
            if (routesCallable == null) {
                DeviseForRoutesGenerator.$$$reportNull$$$0(10);
            }
            if (matcher == null) {
                DeviseForRoutesGenerator.$$$reportNull$$$0(11);
            }
            if (arguments == null) {
                DeviseForRoutesGenerator.$$$reportNull$$$0(12);
            }
            if (verbs == null) {
                DeviseForRoutesGenerator.$$$reportNull$$$0(13);
            }
            RailsRouteScope routeScope = routesCallable.getRouteScope();
            RoutesInfo routesInfo = routesCallable.getRoutesInfo();
            String as = arguments.getOrDefault("as", "");
            String format = this.myCallArguments.getOptionValue("format");
            FQN controllerFqn = this.getControllerFqn(routeScope, routeScope.getController());
            routesInfo.addControllerFqn(this.myCallArguments.getRCallElement(), controllerFqn);
            String action = arguments.get("action");
            FQN target = action != null ? FQN.Builder.concat((FQN)controllerFqn, (String)action) : FQN.INVALID;
            routesInfo.addActionFqn(this.myCallArguments.getRCallElement(), target);
            String prefix = routeScope.getPrefixForMatcher(StringUtil.notNullize((String)as), collection, member, false);
            routesCallable.addRoutes(this.myCallArguments.getCallElement(), prefix, verbs, routeScope.getPathForMatcher(StringUtil.notNullize((String)this.getPathName(StringUtil.notNullize((String)arguments.get("path")))), false, true, false, format), target);
        }

        @NotNull
        private FQN getControllerFqn(@NotNull RailsRouteScope scope, @NotNull String controller) {
            FQN controllerFqn;
            if (scope == null) {
                DeviseForRoutesGenerator.$$$reportNull$$$0(14);
            }
            if (controller == null) {
                DeviseForRoutesGenerator.$$$reportNull$$$0(15);
            }
            if ((controllerFqn = this.getPossibleControllerFqn(controller, scope.getModule())) != null) {
                FQN fQN = controllerFqn;
                if (fQN == null) {
                    DeviseForRoutesGenerator.$$$reportNull$$$0(16);
                }
                return fQN;
            }
            String deviseDeclaredModule = this.getModuleName();
            if (deviseDeclaredModule != null) {
                FQN fQN = RailsRouteUtil.getControllerFqn(deviseDeclaredModule, controller, scope.getModule());
                if (fQN == null) {
                    DeviseForRoutesGenerator.$$$reportNull$$$0(17);
                }
                return fQN;
            }
            String scopeModule = scope.getModuleName();
            if (!scopeModule.isEmpty()) {
                FQN fQN = RailsRouteUtil.getControllerFqn(scopeModule, controller, scope.getModule());
                if (fQN == null) {
                    DeviseForRoutesGenerator.$$$reportNull$$$0(18);
                }
                return fQN;
            }
            FQN fQN = RailsRouteUtil.getControllerFqn("devise", controller, scope.getModule());
            if (fQN == null) {
                DeviseForRoutesGenerator.$$$reportNull$$$0(19);
            }
            return fQN;
        }

        private boolean isSkipOrExcluded(@NotNull String controller) {
            List<String> onlyList;
            if (controller == null) {
                DeviseForRoutesGenerator.$$$reportNull$$$0(20);
            }
            if ((onlyList = RubyInterpretUtil.evaluateOptionValues(this.myDeviseForCall.getArguments(), "only")) != null) {
                return !onlyList.contains(controller);
            }
            List<String> skipList = RubyInterpretUtil.evaluateOptionValues(this.myDeviseForCall.getArguments(), "skip");
            return skipList != null && (skipList.contains("all") || skipList.contains(controller));
        }

        @Nullable
        private String getPathName(@NotNull String path) {
            RPsiElement pathNames;
            if (path == null) {
                DeviseForRoutesGenerator.$$$reportNull$$$0(21);
            }
            if ((pathNames = RubyInterpretUtil.getOptionValueElement(this.myDeviseForCall.getArguments(), "path_names")) == null) {
                return path;
            }
            Map<String, StringValue> pathNamesMap = RubyInterpretUtil.evaluateHashElement((PsiElement)pathNames);
            if (pathNamesMap == null) {
                return path;
            }
            return pathNamesMap.getOrDefault(path, StringValueUtil.createConstantStringValue((String)path)).getOnlyString();
        }

        @Nullable
        private String getSpecifiedPath() {
            return RubyInterpretUtil.evaluateOptionValue((RPossibleCall)this.myDeviseForCall, "path");
        }

        @Nullable
        private String getModuleName() {
            return RubyInterpretUtil.evaluateOptionValue((RPossibleCall)this.myDeviseForCall, "module");
        }

        @Nullable
        private FQN getPossibleControllerFqn(@NotNull String resource, @NotNull Module module) {
            RPsiElement controllers;
            if (resource == null) {
                DeviseForRoutesGenerator.$$$reportNull$$$0(22);
            }
            if (module == null) {
                DeviseForRoutesGenerator.$$$reportNull$$$0(23);
            }
            if ((controllers = RubyInterpretUtil.getOptionValueElement(this.myDeviseForCall.getArguments(), "controllers")) == null) {
                return null;
            }
            Map<String, StringValue> controllersMap = RubyInterpretUtil.evaluateHashElement((PsiElement)controllers);
            if (controllersMap == null || !controllersMap.containsKey(resource)) {
                return null;
            }
            String controllerPath = controllersMap.get(resource).getOnlyString();
            if (controllerPath == null) {
                return null;
            }
            int index = controllerPath.lastIndexOf(47);
            String name = controllerPath.substring(index + 1);
            String namespace = index >= 0 ? controllerPath.substring(0, index) : null;
            return namespace != null ? RailsRouteUtil.getControllerFqn(namespace, name, module) : RailsRouteUtil.getControllerFqn(name, module);
        }

        @Nullable
        private Set<String> getSignOutVerbSet() {
            List<String> verbs = RubyInterpretUtil.evaluateOptionValues(this.myDeviseForCall.getArguments(), "sign_out_via");
            if (verbs == null) {
                return null;
            }
            return new HashSet<String>(ContainerUtil.map(verbs, verb -> verb.toUpperCase(Locale.ROOT)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 6, 7, 8, 16, 17, 18, 19 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arguments";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deviseData";
                    break;
                }
                case 2: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "routesCallable";
                    break;
                }
                case 3: 
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/routes/DeviseRoutesProvider$DeviseForRoutesGenerator";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matcher";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "verbs";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 15: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "controller";
                    break;
                }
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/routes/DeviseRoutesProvider$DeviseForRoutesGenerator";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolveDeclaredDeviseModelGroups";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRouteScope";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRoutesInfo";
                    break;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getControllerFqn";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "createRoutesForResource";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "createRoutesForMatcher";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "getControllerFqn";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "isSkipOrExcluded";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "getPathName";
                    break;
                }
                case 22: 
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "getPossibleControllerFqn";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 6, 7, 8, 16, 17, 18, 19 -> new IllegalStateException(string);
            };
        }
    }
}

