/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.refactoring.rename;

import com.intellij.concurrency.JobScheduler;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.InflectorService;
import org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorOptions;
import org.jetbrains.plugins.ruby.rails.actions.generators.actions.special.GenerateMigrationAction;
import org.jetbrains.plugins.ruby.rails.model.ActiveRecordModel;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.model.RailsController;
import org.jetbrains.plugins.ruby.rails.model.RailsModel;
import org.jetbrains.plugins.ruby.rails.refactoring.rename.RailsRenameUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;
import org.jetbrains.plugins.ruby.ruby.lang.rename.RenameProcessor;
import org.jetbrains.plugins.ruby.settings.RProjectUtil;
import org.jetbrains.plugins.ruby.tasks.rake.RakeUtil;
import org.jetbrains.plugins.ruby.utils.NamingConventions;
import org.jetbrains.plugins.ruby.utils.RubyPluginUtil;

public final class RenameByRailsModelClassProcessor
extends RenameProcessor {
    public static final Key<Boolean> IS_RENAMED_MODEL = Key.create((String)"IS_RENAMED_MODEL");
    public static final Key<String> OLD_NAME = Key.create((String)"OLD_NAME");
    private static final String ID = "Rename Rails model";

    @Override
    public boolean canProcessElement(PsiElement element) {
        if (element instanceof RClass && RailsApp.fromPsiElement(element) != null) {
            RailsModel model = RailsModel.fromClass((RClass)element);
            return model != null;
        }
        return false;
    }

    @Override
    public void prepareRenaming(PsiElement element, String newName, Map<PsiElement, String> allRenames) {
        RailsModel model;
        if (element instanceof RClass && (model = RailsModel.fromClass((RClass)element)) != null) {
            element.putCopyableUserData(IS_RENAMED_MODEL, (Object)true);
            element.putCopyableUserData(OLD_NAME, (Object)model.getClassName());
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            InflectorService inflector = InflectorService.getInstance(module);
            if (inflector != null && inflector.isInflectorAvailable()) {
                String pluralizedName = inflector.pluralize(newName);
                RailsController controller = model.getController();
                if (controller != null && !controller.isApplicationController()) {
                    RailsRenameUtil.renameControllerStuff(controller, pluralizedName, allRenames);
                }
                RailsRenameUtil.renameModelStuff(model, newName, allRenames);
            }
        }
    }

    @Override
    @Nullable
    public Runnable getPostRenameCallback(final PsiElement element, final String newName, RefactoringElementListener elementListener) {
        Module module;
        PsiFile file;
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)element.getProject());
        Document document = documentManager.getDocument(file = element.getContainingFile());
        if (document != null) {
            documentManager.doPostponedOperationsAndUnblockDocument(document);
        }
        if (element instanceof RClass && ActiveRecordModel.isActiveRecordClass((RClass)element) && element.getCopyableUserData(IS_RENAMED_MODEL) != null && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) != null) {
            final Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
            if (sdk == null) {
                ProjectRootManager.getInstance((Project)module.getProject());
            }
            return new Runnable(){

                @Override
                public void run() {
                    if (sdk == null) {
                        return;
                    }
                    RailsApp railsApp = RailsApp.fromModule(module);
                    if (railsApp == null) {
                        return;
                    }
                    String oldName = (String)element.getCopyableUserData(OLD_NAME);
                    String migrationName = 1.getMigrationName(oldName, newName);
                    MessageBusConnection connection = module.getProject().getMessageBus().connect(RubyPluginUtil.getUnloadAwareDisposable(module));
                    MigrationListener listener = new MigrationListener(module, connection, migrationName, oldName, newName);
                    connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)listener);
                    GenerateMigrationAction action = new GenerateMigrationAction("migration");
                    GeneratorOptions options = RProjectUtil.getGeneratorsOptions(module.getProject());
                    String env = StringUtil.isEmpty((String)options.ENVIRONMENT) ? "development" : options.ENVIRONMENT;
                    action.invokeAction(migrationName, env, module);
                    FileDocumentManager.getInstance().saveAllDocuments();
                }

                private static String getMigrationName(String oldName, String newName2) {
                    return "rename" + oldName + "To" + newName2;
                }
            };
        }
        return null;
    }

    @TestOnly
    public static void runPostRenameCallback(@NotNull Module module, @NotNull VirtualFile file, @NotNull String oldName, @NotNull String newName) {
        if (module == null) {
            RenameByRailsModelClassProcessor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            RenameByRailsModelClassProcessor.$$$reportNull$$$0(1);
        }
        if (oldName == null) {
            RenameByRailsModelClassProcessor.$$$reportNull$$$0(2);
        }
        if (newName == null) {
            RenameByRailsModelClassProcessor.$$$reportNull$$$0(3);
        }
        MigrationListener.updateFileContent(module, file, oldName, newName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "oldName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "newName";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/rails/refactoring/rename/RenameByRailsModelClassProcessor";
        objectArray[2] = "runPostRenameCallback";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MigrationListener
    implements BulkFileListener {
        private final Ref<Module> moduleRef;
        private final String myMigrationName;
        @Nullable
        private final String myOldName;
        @Nullable
        private final String myNewName;
        @NotNull
        private final MessageBusConnection myConnection;

        private MigrationListener(@NotNull Module module, @NotNull MessageBusConnection messageBusConnection, @NotNull String migrationName, @Nullable String oldName, @Nullable String newName) {
            if (module == null) {
                MigrationListener.$$$reportNull$$$0(0);
            }
            if (messageBusConnection == null) {
                MigrationListener.$$$reportNull$$$0(1);
            }
            if (migrationName == null) {
                MigrationListener.$$$reportNull$$$0(2);
            }
            this.moduleRef = new Ref();
            this.moduleRef.set((Object)module);
            this.myMigrationName = migrationName;
            this.myOldName = oldName;
            this.myNewName = newName;
            this.myConnection = messageBusConnection;
            JobScheduler.getScheduler().schedule(() -> this.myConnection.dispose(), 30L, TimeUnit.SECONDS);
        }

        public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
            if (events == null) {
                MigrationListener.$$$reportNull$$$0(3);
            }
            for (VFileEvent vFileEvent : events) {
                if (!(vFileEvent instanceof VFileCreateEvent)) continue;
                Module module = (Module)this.moduleRef.get();
                VirtualFile file = vFileEvent.getFile();
                if (module != null && file != null && file.getNameWithoutExtension().endsWith(NamingConventions.toUnderscoreCase((String)this.myMigrationName, (Module)module))) {
                    MigrationListener.updateFileContent(module, file, this.myOldName, this.myNewName);
                    Notifications.Bus.notify((Notification)new MigrationNotification(module));
                }
                this.moduleRef.set(null);
                Disposer.dispose((Disposable)this.myConnection);
            }
        }

        private static void updateFileContent(@NotNull Module module, @NotNull VirtualFile virtualFile, @Nullable String oldName, @Nullable String newName) {
            PsiFile file;
            if (module == null) {
                MigrationListener.$$$reportNull$$$0(4);
            }
            if (virtualFile == null) {
                MigrationListener.$$$reportNull$$$0(5);
            }
            if ((file = PsiManager.getInstance((Project)module.getProject()).findFile(virtualFile)) instanceof RContainer) {
                RClass rClass = RContainerUtil.getFirstClassInFile(file);
                if (rClass == null) {
                    return;
                }
                List children = ContainerUtil.filterIsInstance((Collection)rClass.getStructureElements(), RMethod.class);
                if (children.size() == 1) {
                    MigrationListener.insertTableRename(module, file, (RMethod)children.get(0), oldName, newName);
                } else if (children.size() == 2) {
                    MigrationListener.insertTableRename(module, file, (RMethod)children.get(0), oldName, newName);
                    MigrationListener.insertTableRename(module, file, (RMethod)children.get(1), oldName, newName);
                }
                CodeStyleManager.getInstance((Project)module.getProject()).reformat((PsiElement)rClass);
            }
        }

        private static void insertTableRename(@NotNull Module module, @NotNull PsiFile file, @NotNull RMethod method, @Nullable String oldName, @Nullable String newName) {
            if (module == null) {
                MigrationListener.$$$reportNull$$$0(6);
            }
            if (file == null) {
                MigrationListener.$$$reportNull$$$0(7);
            }
            if (method == null) {
                MigrationListener.$$$reportNull$$$0(8);
            }
            String methodText = method.getText();
            InflectorService inflector = InflectorService.getInstance(module);
            String symbolicOldName = inflector.tableize(oldName);
            String symbolicNewName = inflector.tableize(newName);
            String renameTableText = MigrationListener.generateRenameTableText(methodText, symbolicOldName, symbolicNewName);
            RPsiElement newRenameTableMethod = RubyElementFactoryCore.createElementFromText((PsiElement)file, (String)renameTableText);
            WriteCommandAction.writeCommandAction((Project)module.getProject()).run(() -> method.replace((PsiElement)newRenameTableMethod));
        }

        private static String generateRenameTableText(@NotNull String text, @Nullable String oldName, @Nullable String newName) {
            if (text == null) {
                MigrationListener.$$$reportNull$$$0(9);
            }
            String upOrDown = "(.*)(\\n\\s+end)$";
            Pattern pattern = Pattern.compile("(.*)(\\n\\s+end)$");
            Matcher matcher = pattern.matcher(text);
            StringBuilder builder2 = new StringBuilder();
            if (matcher.matches()) {
                builder2.append(matcher.group(1)).append("\n").append("rename_table ").append(":").append(oldName).append(", :").append(newName).append(matcher.group(2));
            }
            return builder2.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "messageBusConnection";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "migrationName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "events";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "virtualFile";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/rails/refactoring/rename/RenameByRailsModelClassProcessor$MigrationListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "after";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateFileContent";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "insertTableRename";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "generateRenameTableText";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MigrationNotification
    extends Notification {
        MigrationNotification(final Module module) {
            super(RenameByRailsModelClassProcessor.ID, RBundle.message((String)"rails.run.migration.title"), "", NotificationType.WARNING);
            this.addAction((AnAction)new DumbAwareAction(RBundle.message((String)"rails.run.migration.action.message")){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    RakeUtil.runRakeTask("db:migrate", module, null);
                    this.expire();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/ruby/rails/refactoring/rename/RenameByRailsModelClassProcessor$MigrationNotification$1", "actionPerformed"));
                }
            });
        }
    }
}

