/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.refactoring.rename;

import com.intellij.psi.PsiElement;
import java.util.Map;
import org.jetbrains.plugins.ruby.rails.model.RailsController;
import org.jetbrains.plugins.ruby.rails.nameConventions.ControllersConventions;
import org.jetbrains.plugins.ruby.rails.refactoring.rename.RailsRenameUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.rename.RenameProcessor;

public final class RenameByRailsControllerClassProcessor
extends RenameProcessor {
    @Override
    public boolean canProcessElement(PsiElement element) {
        if (element instanceof RClass) {
            RailsController railsController = RailsController.fromClass((RClass)element);
            return railsController != null && !railsController.isApplicationController();
        }
        return false;
    }

    @Override
    public void prepareRenaming(PsiElement element, String newControllerClassName, Map<PsiElement, String> allRenames) {
        RailsController controller = RailsController.fromClass((RClass)element);
        assert (controller != null) : "Controller cannot be null here";
        assert (!controller.isApplicationController()) : "Controller cannot be application controller here";
        String name = ControllersConventions.getControllerNameByClassName(newControllerClassName, controller.getModule());
        if (name != null) {
            RailsRenameUtil.renameControllerStuff(controller, name, allRenames);
        }
    }
}

