/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.refactoring.rename;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rails.model.RailsController;
import org.jetbrains.plugins.ruby.rails.refactoring.rename.RailsControllerOccurenceProcessor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public final class RailsControllerSearch
implements QueryExecutor<PsiReference, ReferencesSearch.SearchParameters> {
    public boolean execute(@NotNull ReferencesSearch.SearchParameters params, @NotNull Processor<? super PsiReference> psiReferenceProcessor) {
        PsiElement element;
        if (params == null) {
            RailsControllerSearch.$$$reportNull$$$0(0);
        }
        if (psiReferenceProcessor == null) {
            RailsControllerSearch.$$$reportNull$$$0(1);
        }
        if (!((element = params.getElementToSearch()) instanceof RClass)) {
            return true;
        }
        RClass clazz = (RClass)element;
        Pair controllerAndName = (Pair)ReadAction.compute(() -> {
            RailsController controller = RailsController.fromClass(clazz);
            if (controller == null || controller.isApplicationController()) {
                return null;
            }
            String name = NamingConventions.toUnderscoreCase((String)controller.getName(), (Module)controller.getModule());
            if (name.isEmpty()) {
                return null;
            }
            return Pair.create((Object)controller, (Object)controller.getName());
        });
        if (controllerAndName == null) {
            return true;
        }
        SearchScope searchScope = (SearchScope)ReadAction.compute(() -> RubyPsiUtil.restrictScopeToRubyFiles(params.getEffectiveSearchScope()));
        RailsControllerOccurenceProcessor processor = new RailsControllerOccurenceProcessor((RailsController)controllerAndName.getFirst(), (String)controllerAndName.getSecond(), psiReferenceProcessor);
        return PsiSearchHelper.getInstance((Project)element.getProject()).processElementsWithWord((TextOccurenceProcessor)processor, searchScope, (String)controllerAndName.getSecond(), (short)4, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "params";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "psiReferenceProcessor";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/rails/refactoring/rename/RailsControllerSearch";
        objectArray[2] = "execute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

