/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.refactoring;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileSystemItemUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.refactoring.lang.ExtractIncludeDialog;
import com.intellij.refactoring.lang.ExtractIncludeFileBase;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.erb.ErbFileType;
import org.jetbrains.plugins.ruby.erb.ErbLanguage;
import org.jetbrains.plugins.ruby.erb.psi.ErbCodeInjectionTag;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.refactoring.ExtractPartialDialog;

public final class ExtractPartialHandler
extends ExtractIncludeFileBase<PsiElement> {
    protected ExtractIncludeDialog createDialog(PsiDirectory containingDirectory, String extractExtension) {
        return new ExtractPartialDialog(containingDirectory, extractExtension);
    }

    protected String getExtractExtension(FileType extractFileType, PsiElement first) {
        int pos;
        VirtualFile vFile = first.getContainingFile().getVirtualFile();
        assert (vFile != null);
        String extension = vFile.getExtension();
        if ((ErbFileType.ERB.getDefaultExtension().equals(extension) || "builder".equals(extension)) && (pos = vFile.getNameWithoutExtension().lastIndexOf(46)) >= 0) {
            return vFile.getName().substring(pos + 1);
        }
        return extension;
    }

    @NotNull
    protected String doExtract(PsiDirectory targetDirectory, String targetFileName, PsiElement first, PsiElement last, Language includingLanguage) throws IncorrectOperationException {
        PsiElement parent = first.getParent();
        Project project = parent.getProject();
        PsiFile including = first.getContainingFile();
        String newFileText = including.getText().substring(first.getTextRange().getStartOffset(), last.getTextRange().getEndOffset());
        PsiFile extracted = targetDirectory.createFile(targetFileName);
        assert (!(extracted instanceof PsiBinaryFile));
        Document doc = PsiDocumentManager.getInstance((Project)project).getDocument(extracted);
        assert (doc != null);
        doc.replaceString(0, doc.getTextLength(), (CharSequence)newFileText);
        PsiDocumentManager.getInstance((Project)project).commitDocument(doc);
        CodeStyleManager.getInstance((Project)extracted.getProject()).adjustLineIndent(extracted, extracted.getTextRange());
        String relativePath = PsiFileSystemItemUtil.findRelativePath((PsiFileSystemItem)including, (PsiFileSystemItem)extracted);
        if (relativePath == null) {
            throw new IncorrectOperationException("Cannot extract!");
        }
        String string = relativePath;
        if (string == null) {
            ExtractPartialHandler.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected void doReplaceRange(String includePath, PsiElement first, PsiElement last) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            String partialName = includePath.substring(1);
            int dot = partialName.indexOf(46);
            if (dot >= 0) {
                partialName = partialName.substring(0, dot);
            }
            RailsApp app = RailsApp.fromPsiElement((PsiElement)first.getContainingFile());
            PsiDocumentManager docManager = PsiDocumentManager.getInstance((Project)first.getProject());
            Document document = docManager.getDocument(first.getContainingFile());
            assert (document != null && app != null);
            document.replaceString(first.getTextRange().getStartOffset(), last.getTextRange().getEndOffset(), (CharSequence)("<%= render '" + partialName + "' %>"));
            docManager.commitDocument(document);
        });
    }

    protected boolean verifyChildRange(PsiElement first, PsiElement last) {
        return true;
    }

    @NotNull
    protected Language getLanguageForExtract(PsiElement firstExtracted) {
        ErbLanguage erbLanguage = ErbLanguage.INSTANCE;
        if (erbLanguage == null) {
            ExtractPartialHandler.$$$reportNull$$$0(1);
        }
        return erbLanguage;
    }

    protected Pair<PsiElement, PsiElement> findPairToExtract(int start, int end) {
        PsiElement elementAt;
        PsiElement elementAt2;
        if (RailsApp.fromPsiElement((PsiElement)this.myIncludingFile) == null) {
            return null;
        }
        PsiFile file = this.myIncludingFile;
        int startOffset = start;
        int endOffset = end;
        PsiElement elementAtStart = file.findElementAt(startOffset);
        PsiElement elementAtEnd = file.findElementAt(endOffset - 1);
        if (elementAtStart instanceof PsiWhiteSpace) {
            startOffset = elementAtStart.getTextRange().getEndOffset();
            elementAtStart = file.findElementAt(startOffset);
        }
        if (elementAtEnd instanceof PsiWhiteSpace) {
            endOffset = elementAtEnd.getTextRange().getStartOffset();
            elementAtEnd = file.findElementAt(endOffset - 1);
        }
        if (elementAtStart == null || elementAtEnd == null) {
            return null;
        }
        PsiElement first = PsiTreeUtil.getParentOfType((PsiElement)elementAtStart, XmlTagChild.class);
        if (first == null) {
            first = PsiTreeUtil.getParentOfType((PsiElement)elementAtStart, ErbCodeInjectionTag.class);
        }
        if (first == null) {
            return null;
        }
        if (!(first.getTextRange().getStartOffset() == startOffset || (elementAt2 = file.findElementAt(first.getTextRange().getStartOffset())) instanceof PsiWhiteSpace && elementAt2.getTextRange().getEndOffset() == startOffset)) {
            return null;
        }
        PsiElement last = first;
        while (last != null && last.getTextRange().getEndOffset() < endOffset) {
            PsiElement next = PsiTreeUtil.getNextSiblingOfType((PsiElement)last, XmlTagChild.class);
            if (next == null) {
                next = PsiTreeUtil.getNextSiblingOfType((PsiElement)last, ErbCodeInjectionTag.class);
            }
            last = next;
        }
        if (last == null) {
            return null;
        }
        if (!(last.getTextRange().getEndOffset() == elementAtEnd.getTextRange().getEndOffset() || (elementAt = file.findElementAt(last.getTextRange().getEndOffset() - 1)) instanceof PsiWhiteSpace && elementAt.getTextRange().getStartOffset() == endOffset)) {
            return null;
        }
        return Pair.create((Object)first, (Object)last);
    }

    public String getActionTitle() {
        return RBundle.message((String)"rails.refactoring.extract.partial.action.title");
    }

    protected String getRefactoringName() {
        return RBundle.message((String)"dialog.title.extract.partial");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/ruby/rails/refactoring/ExtractPartialHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "doExtract";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageForExtract";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

