/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.preload.zeus;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.registry.Registry;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;

public final class ZeusUtil {
    @NonNls
    public static final String START = "start";
    @NonNls
    public static final String ZEUS = "zeus";

    public static boolean hasZeusSupport(@Nullable Module module) {
        if (!ZeusUtil.isZeusSupportEnabled()) {
            return false;
        }
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        return sdk != null && !RubySdkAdditionalData.notNullFrom(sdk).getSdkSystemAccessor().isWindows() && RubyGemSearchUtil.findGem(module, sdk, ZEUS) != null;
    }

    public static boolean isZeusAttached(@Nullable Module module) {
        return module != null && RubyProjectGemSearchService.Companion.findGem(module, ZEUS) != null;
    }

    @Nullable
    public static String getZeusExecutable(@Nullable Module module, @Nullable Sdk sdk) {
        return RubyGemExecutionContext.getScriptPath(sdk, module, ZEUS);
    }

    public static boolean isZeusSupportEnabled() {
        return Registry.is((String)"zeus.preload.server.support");
    }
}

