/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.preload.zeus;

import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rails.preload.zeus.ZeusRunConfiguration;
import org.jetbrains.plugins.ruby.settings.SettingsExternalizer;

public final class ZeusRunConfigurationExternalizer
extends SettingsExternalizer {
    public static final String ID = "ZEUS_RUN_CONFIG_SETTING";
    private static final String COMMAND_NAME = "ZEUS_COMMAND_NAME";
    private static final String COMMAND_ARGS = "ZEUS_COMMAND_ARGS";

    private ZeusRunConfigurationExternalizer() {
    }

    public void writeExternal(ZeusRunConfiguration configuration, Element element) {
        this.writeOption(COMMAND_NAME, configuration.getCommandName(), element);
        this.writeOption(COMMAND_ARGS, configuration.getArguments(), element);
    }

    public static ZeusRunConfigurationExternalizer getInstance() {
        return SingletonHolder.myInstance;
    }

    @Override
    @NotNull
    public String getID() {
        return ID;
    }

    public void readExternal(ZeusRunConfiguration configuration, Element element) {
        Map<String, String> optionsByName = this.buildOptionsByElement(element);
        configuration.setCommandName(optionsByName.get(COMMAND_NAME));
        configuration.setArguments(optionsByName.get(COMMAND_ARGS));
    }

    private static final class SingletonHolder {
        public static final ZeusRunConfigurationExternalizer myInstance = new ZeusRunConfigurationExternalizer();

        private SingletonHolder() {
        }
    }
}

