/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.preload.zeus;

import com.intellij.DynamicBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import icons.RubyIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.preload.zeus.ZeusCommandManager;
import org.jetbrains.plugins.ruby.rails.preload.zeus.ZeusRunConfiguration;
import org.jetbrains.plugins.ruby.rails.preload.zeus.ZeusRunConfigurationParams;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommonRunParamsEditor;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUIUtil;

public class ZeusRunConfigurationEditor
extends SettingsEditor<ZeusRunConfiguration>
implements ZeusRunConfigurationParams,
PanelWithAnchor {
    private final Project myProject;
    private final RubyCommonRunParamsEditor myCommonEditor;
    private JComponent myContentPane;
    private LabeledComponent myCommandComponent;
    private LabeledComponent myArgumentsComponent;
    private JPanel myCommonOptionsPanel;
    private JComponent myAnchor;
    private TextFieldWithAutoCompletion myCommandTextField;
    private RawCommandLineEditor myArgumentsEditor;

    public ZeusRunConfigurationEditor(Project project, ZeusRunConfiguration configuration) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myCommonEditor = new RubyCommonRunParamsEditor(configuration);
        this.myCommonOptionsPanel.add((Component)this.myCommonEditor.getMainPanel(), "Center");
        this.myCommonEditor.setWorkDirVisible(false);
        this.setAnchor(this.myCommonEditor.getAnchor());
    }

    protected void resetEditorFrom(@NotNull ZeusRunConfiguration configuration) {
        if (configuration == null) {
            ZeusRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        ZeusRunConfiguration.copyParams(configuration, this);
        this.myCommonEditor.resetEditorFrom(configuration);
    }

    protected void applyEditorTo(@NotNull ZeusRunConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            ZeusRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        ZeusRunConfiguration.copyParams(this, configuration);
        this.myCommonEditor.applyEditorTo(configuration);
    }

    @NotNull
    protected JComponent createEditor() {
        JComponent jComponent = this.myContentPane;
        if (jComponent == null) {
            ZeusRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.myAnchor = anchor;
        this.myCommandComponent.setAnchor(anchor);
        this.myArgumentsComponent.setAnchor(anchor);
        this.myCommonEditor.setAnchor(anchor);
    }

    private void createUIComponents() {
        Ref textFieldWithAutoCompletionRef = new Ref();
        this.createCommandComponent(this.myProject, (Ref<TextFieldWithAutoCompletion>)textFieldWithAutoCompletionRef);
        this.myCommandTextField = (TextFieldWithAutoCompletion)textFieldWithAutoCompletionRef.get();
        this.createArgumentsComponent();
    }

    private void createArgumentsComponent() {
        Ref argsEditorWrapper = new Ref();
        this.myArgumentsComponent = RunConfigurationUIUtil.createRawEditorComponent((Ref<? super RawCommandLineEditor>)argsEditorWrapper, RBundle.message((String)"zeus.server.run.configuration.arguments"));
        this.myArgumentsEditor = (RawCommandLineEditor)argsEditorWrapper.get();
    }

    private void createCommandComponent(@NotNull Project project, @NotNull Ref<TextFieldWithAutoCompletion> textFieldRef) {
        if (project == null) {
            ZeusRunConfigurationEditor.$$$reportNull$$$0(3);
        }
        if (textFieldRef == null) {
            ZeusRunConfigurationEditor.$$$reportNull$$$0(4);
        }
        this.myCommandComponent = new LabeledComponent();
        TextFieldWithAutoCompletionListProvider<ZeusCommandManager.ZeusCommand> commandCompletionProvider = new TextFieldWithAutoCompletionListProvider<ZeusCommandManager.ZeusCommand>(this, null){

            protected Icon getIcon(@NotNull ZeusCommandManager.ZeusCommand item) {
                if (item == null) {
                    1.$$$reportNull$$$0(0);
                }
                return RubyIcons.Zeus.Zeus;
            }

            @NotNull
            protected String getLookupString(@NotNull ZeusCommandManager.ZeusCommand item) {
                if (item == null) {
                    1.$$$reportNull$$$0(1);
                }
                String string = item.getName();
                if (string == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string;
            }

            protected String getTypeText(@NotNull ZeusCommandManager.ZeusCommand item) {
                if (item == null) {
                    1.$$$reportNull$$$0(3);
                }
                return null;
            }

            public int compare(ZeusCommandManager.ZeusCommand item1, ZeusCommandManager.ZeusCommand item2) {
                return StringUtil.compare((String)item1.getName(), (String)item2.getName(), (boolean)false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "item";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/ruby/rails/preload/zeus/ZeusRunConfigurationEditor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/preload/zeus/ZeusRunConfigurationEditor$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLookupString";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getIcon";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getLookupString";
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getTypeText";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
        commandCompletionProvider.setItems(ZeusCommandManager.getInstance().getCommands());
        TextFieldWithAutoCompletion textField = new TextFieldWithAutoCompletion(project, (TextFieldWithAutoCompletionListProvider)commandCompletionProvider, true, null);
        textFieldRef.set((Object)textField);
        this.myCommandComponent.setComponent((JComponent)textField);
        this.myCommandComponent.setText(RBundle.message((String)"zeus.server.run.configuration.command"));
    }

    @Override
    public String getCommandName() {
        return this.myCommandTextField.getText().trim();
    }

    @Override
    public String getArguments() {
        return this.myArgumentsEditor.getText().trim();
    }

    @Override
    public void setCommandName(@Nullable String name) {
        this.myCommandTextField.setText(StringUtil.notNullize((String)name));
    }

    @Override
    public void setArguments(@Nullable String arguments) {
        this.myArgumentsEditor.setText(arguments);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/preload/zeus/ZeusRunConfigurationEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textFieldRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/preload/zeus/ZeusRunConfigurationEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createCommandComponent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        JPanel jPanel2 = new JPanel();
        this.myContentPane = jPanel2;
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        LabeledComponent labeledComponent = this.myCommandComponent;
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText(DynamicBundle.getBundle((String)"messages/RBundle", ZeusRunConfigurationEditor.class).getString("zeus.server.run.configuration.editor.command.text"));
        jPanel2.add((Component)labeledComponent, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        LabeledComponent labeledComponent2 = this.myArgumentsComponent;
        labeledComponent2.setLabelLocation("West");
        labeledComponent2.setText(DynamicBundle.getBundle((String)"messages/RBundle", ZeusRunConfigurationEditor.class).getString("zeus.server.run.configuration.editor.arguments.text"));
        jPanel2.add((Component)labeledComponent2, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myCommonOptionsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }
}

