/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.preload.spring;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Map;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.preload.spring.SpringDebugConfigDialog;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.testing.SupportedTestFramework;

@State(name="SpringUtil", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class SpringUtil
implements PersistentStateComponent<Element> {
    private static boolean ourEnforceSpringInTests = false;
    @NonNls
    public static final String SPRING_BINARY_NAME = "spring";
    @NonNls
    public static final String SPRING_NOTIFICATION_GROUP_ID = "Spring";
    @NonNls
    private static final String SPRING_DEBUG_NOTIFICATION_GROUP_ID = "Spring Debug";
    @NonNls
    private static final String CONFIG_FILE_NAME = ".spring.rb";
    @NonNls
    private static final String SPRING_DEBUG_PATCH_DENIED = "spring.debug.patch.denied";
    @NonNls
    private static final String PROJECT_CONFIG_FILE_NAME = "spring.rb";
    @NonNls
    private static final String OLD_CONFIG_FILE_DEBUG_PATCH = "Spring.after_fork do\n  if ENV['DEBUGGER_STORED_RUBYLIB']\n    starter = ENV['BUNDLER_ORIG_RUBYOPT'][2..-1]\n    load(starter + '.rb')\n  end\nend";
    @NonNls
    private static final String CONFIG_FILE_DEBUG_PATCH = "Spring.after_fork do\n  if ENV['DEBUGGER_STORED_RUBYLIB']\n    ENV['DEBUGGER_STORED_RUBYLIB'].split(File::PATH_SEPARATOR).each do |path|\n      next unless path =~ /ruby-debug-ide/\n      load path + '/ruby-debug-ide/multiprocess/starter.rb'\n    end\n  end\nend";
    @NonNls
    public static final String SPRING_PRE_LOADER_OPTION_FIELD = "SPRING_PRE_LOADER_OPTION";
    @NonNls
    public static final String RAKE_SPRING_PRE_LOADER_OPTION_FIELD = "RAKE_SPRING_PRE_LOADER_OPTION";
    @NonNls
    public static final String RAILS_SPRING_PRE_LOADER_OPTION_FIELD = "RAILS_SPRING_PRE_LOADER_OPTION";
    public boolean SPRING_PRE_LOADER_OPTION = true;
    public boolean RAKE_SPRING_PRE_LOADER_OPTION = true;
    public boolean RAILS_SPRING_PRE_LOADER_OPTION = true;
    public static final String SPRING_TMP_PATH_VARIABLE = "SPRING_TMP_PATH";
    public static final String SPRING_SERVER_COMMAND_ENV = "SPRING_SERVER_COMMAND";
    public static final String SPRING_SERVER_COMMAND = "spring server";
    @ApiStatus.Internal
    public static final int MAX_SPRING_TMP_PATH_LENGTH = 71;
    @ApiStatus.Internal
    public static final String SPRING_TMP_DIR_PREFIX = "rm";
    private static final Logger LOG = Logger.getInstance(SpringUtil.class);
    @NonNls
    private static final String SPRING_GEM_NAME = "spring";
    @NonNls
    private static final String DISABLE_SPRING_VAR = "DISABLE_SPRING";
    private static final int SYSTEM_CONFIG_OPTION = 0;
    private static final int PROJECT_CONFIG_OPTION = 1;
    private static final int DENY_CONFIG_OPTION = 2;

    public Element getState() {
        Element element = new Element("state");
        element.setAttribute(SPRING_PRE_LOADER_OPTION_FIELD, Boolean.toString(this.SPRING_PRE_LOADER_OPTION));
        element.setAttribute(RAKE_SPRING_PRE_LOADER_OPTION_FIELD, Boolean.toString(this.RAKE_SPRING_PRE_LOADER_OPTION));
        element.setAttribute(RAILS_SPRING_PRE_LOADER_OPTION_FIELD, Boolean.toString(this.RAILS_SPRING_PRE_LOADER_OPTION));
        return element;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            SpringUtil.$$$reportNull$$$0(0);
        }
        this.SPRING_PRE_LOADER_OPTION = Boolean.parseBoolean(state.getAttributeValue(SPRING_PRE_LOADER_OPTION_FIELD));
        this.RAKE_SPRING_PRE_LOADER_OPTION = Boolean.parseBoolean(state.getAttributeValue(RAKE_SPRING_PRE_LOADER_OPTION_FIELD));
        this.RAILS_SPRING_PRE_LOADER_OPTION = Boolean.parseBoolean(state.getAttributeValue(RAILS_SPRING_PRE_LOADER_OPTION_FIELD));
    }

    public static SpringUtil getInstance(Project project) {
        return (SpringUtil)project.getService(SpringUtil.class);
    }

    public static boolean isSpringAvailable(@Nullable Module module) {
        if (module == null || !SpringUtil.getInstance((Project)module.getProject()).SPRING_PRE_LOADER_OPTION) {
            return false;
        }
        return SpringUtil.isSpringGemAvailable(module);
    }

    private static boolean isSpringGemAvailable(@Nullable Module module) {
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        return module != null && SpringUtil.isSpringAvailable(sdk) && RubyProjectGemSearchService.Companion.findGem(module, "spring") != null;
    }

    private static boolean isSpringAvailable(@Nullable Sdk sdk) {
        return sdk != null && RubySdkUtil.isMRISdk(sdk) && !RubySdkSystemAccessor.notNullFrom(sdk).isWindows() && (ourEnforceSpringInTests || !ApplicationManager.getApplication().isHeadlessEnvironment());
    }

    public static void disableSpring(@NotNull Map<String, String> env) {
        if (env == null) {
            SpringUtil.$$$reportNull$$$0(1);
        }
        env.put(DISABLE_SPRING_VAR, "true");
    }

    public static void customizeSpring(@Nullable Module module, @NotNull Map<String, String> env) {
        if (env == null) {
            SpringUtil.$$$reportNull$$$0(2);
        }
        if (module != null && !module.getProject().isDisposed() && !SpringUtil.isSpringAvailable(module)) {
            SpringUtil.disableSpring(env);
            return;
        }
        String path = SpringUtil.getCustomSpringTempPath(module);
        if (path != null) {
            LOG.debug("Moving Spring to " + path);
            env.putIfAbsent(SPRING_TMP_PATH_VARIABLE, path);
        }
        LOG.debug("Setup 'spring server' mode");
        env.putIfAbsent(SPRING_SERVER_COMMAND_ENV, SPRING_SERVER_COMMAND);
    }

    public static boolean isSpringDebugPatchDenied() {
        return PropertiesComponent.getInstance().getBoolean(SPRING_DEBUG_PATCH_DENIED);
    }

    public static void setSpringDebugPatchDenied(boolean enabled) {
        PropertiesComponent.getInstance().setValue(SPRING_DEBUG_PATCH_DENIED, enabled);
    }

    @Nullable
    public static String getSpringExecutable(@Nullable Module module, @Nullable Sdk sdk) {
        if (module != null && !SpringUtil.getInstance((Project)module.getProject()).SPRING_PRE_LOADER_OPTION) {
            return null;
        }
        return RubyGemExecutionContext.getScriptPath(sdk, module, "spring", "spring");
    }

    public static boolean isTestFrameworkEnabled(@Nullable Module module, @NotNull SupportedTestFramework framework) {
        if (framework == null) {
            SpringUtil.$$$reportNull$$$0(3);
        }
        if (module == null) {
            return false;
        }
        if (!SpringUtil.isSpringAvailable(module)) {
            return false;
        }
        return RubyProjectGemSearchService.Companion.findGem(module, SpringUtil.getTestCommandSupportGemName(framework)) != null;
    }

    @NotNull
    private static String getTestCommandSupportGemName(@NotNull SupportedTestFramework framework) {
        if (framework == null) {
            SpringUtil.$$$reportNull$$$0(4);
        }
        String string = switch (framework) {
            case SupportedTestFramework.TEST_UNIT, SupportedTestFramework.SHOULDA -> "spring-commands-testunit";
            case SupportedTestFramework.RSPEC -> "spring-commands-rspec";
            case SupportedTestFramework.CUCUMBER -> "spring-commands-cucumber";
            default -> throw new IllegalArgumentException("Unexpected test framework " + String.valueOf((Object)framework));
        };
        if (string == null) {
            SpringUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static void stopSpring(@NotNull Module module, boolean isModal) {
        if (module == null) {
            SpringUtil.$$$reportNull$$$0(6);
        }
        SpringUtil.runSpringCommand(module, isModal, RBundle.message((String)"rails.spring.stop.title"), "stop");
    }

    private static void runSpringCommand(@NotNull Module module, boolean isModal, @NotNull @Nls String progressTitle, String ... arguments) {
        Sdk sdk;
        if (module == null) {
            SpringUtil.$$$reportNull$$$0(7);
        }
        if (progressTitle == null) {
            SpringUtil.$$$reportNull$$$0(8);
        }
        if ((sdk = RModuleUtil.getInstance().findRubySdkForModule(module)) == null) {
            LOG.debug("No ruby sdk for module:", new Object[]{module});
            return;
        }
        if (!SpringUtil.isSpringAvailable(module)) {
            LOG.debug("Spring is not available for module: ", new Object[]{module});
            return;
        }
        VirtualFile railsAppHomeDir = RailsFacetUtil.getRailsAppHomeDir(module);
        if (railsAppHomeDir == null) {
            LOG.debug("No rails home for: ", new Object[]{module});
            return;
        }
        final Runnable springRunnable = () -> {
            try {
                ProcessOutput processOutput = ((RubyGemExecutionContext)((RubyGemExecutionContext)((RubyGemExecutionContext)RubyGemExecutionContext.create(sdk, "spring").withModule(module)).withGemScriptName("spring").withWorkingDir(railsAppHomeDir)).withArguments(arguments)).executeScript();
                if (processOutput == null || processOutput.getExitCode() != 0) {
                    LOG.warn("Non-zero exit code from spring: " + String.valueOf(processOutput));
                }
            }
            catch (ExecutionException e) {
                LOG.warn("Error running spring: " + e.getMessage());
            }
        };
        if (isModal) {
            new Task.Modal(module.getProject(), progressTitle, false){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    springRunnable.run();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/rails/preload/spring/SpringUtil$1", "run"));
                }
            }.queue();
        } else {
            new Task.Backgroundable(module.getProject(), progressTitle, false){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    springRunnable.run();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/rails/preload/spring/SpringUtil$2", "run"));
                }
            }.queue();
        }
    }

    private static void doUpdateConfig(@NotNull VirtualFile configFileParentDir, @NotNull String configFilePath, boolean addNewPatch) throws IOException {
        if (configFileParentDir == null) {
            SpringUtil.$$$reportNull$$$0(9);
        }
        if (configFilePath == null) {
            SpringUtil.$$$reportNull$$$0(10);
        }
        if (!configFileParentDir.isWritable()) {
            Notifications.Bus.notify((Notification)new Notification(SPRING_DEBUG_NOTIFICATION_GROUP_ID, RBundle.message((String)"spring.debug.config.modification.write.access.title"), RBundle.message((String)"spring.debug.config.modification.write.access"), NotificationType.ERROR));
            LOG.warn(configFileParentDir.getCanonicalPath() + " directory is not writable");
            return;
        }
        VirtualFile configFile = (VirtualFile)WriteAction.compute(() -> configFileParentDir.findOrCreateChildData(null, configFilePath));
        String oldText = VfsUtilCore.loadText((VirtualFile)configFile);
        oldText = StringUtil.replace((String)oldText, (String)OLD_CONFIG_FILE_DEBUG_PATCH, (String)"");
        StringBuilder builder2 = new StringBuilder();
        builder2.append(oldText);
        if (addNewPatch) {
            if (!oldText.isEmpty() && !oldText.endsWith("\n")) {
                builder2.append("\n");
            }
            builder2.append(CONFIG_FILE_DEBUG_PATCH);
        }
        WriteAction.run(() -> VfsUtil.saveText((VirtualFile)configFile, (String)builder2.toString()));
        Notifications.Bus.notify((Notification)new Notification(SPRING_DEBUG_NOTIFICATION_GROUP_ID, RBundle.message((String)"spring.debug.config.modification.title"), RBundle.message((String)"spring.debug.config.modification", (Object[])new Object[]{configFile.getPath()}), NotificationType.INFORMATION));
    }

    private static boolean checkFilePatchedForDebug(@NotNull VirtualFile file, @NotNull String patchText) throws IOException {
        if (file == null) {
            SpringUtil.$$$reportNull$$$0(11);
        }
        if (patchText == null) {
            SpringUtil.$$$reportNull$$$0(12);
        }
        return StringUtil.contains((CharSequence)VfsUtilCore.loadText((VirtualFile)file), (CharSequence)patchText);
    }

    public static void patchBinstubs(@NotNull Module module) {
        if (module == null) {
            SpringUtil.$$$reportNull$$$0(13);
        }
        SpringUtil.runSpringCommand(module, true, RBundle.message((String)"rails.spring.patching.title"), "binstub", "--all");
    }

    private static boolean checkSpringConfigInDir(@NotNull VirtualFile configFileParentDir, @NotNull String configFileName, @NotNull String patchText) {
        VirtualFile configFile;
        if (configFileParentDir == null) {
            SpringUtil.$$$reportNull$$$0(14);
        }
        if (configFileName == null) {
            SpringUtil.$$$reportNull$$$0(15);
        }
        if (patchText == null) {
            SpringUtil.$$$reportNull$$$0(16);
        }
        if ((configFile = configFileParentDir.findChild(configFileName)) == null) {
            return false;
        }
        try {
            return SpringUtil.checkFilePatchedForDebug(configFile, patchText);
        }
        catch (IOException e) {
            LOG.warn("unable to load spring config file context", (Throwable)e);
            return false;
        }
    }

    private static boolean isSystemSpringConfigDebugPatched(@NotNull String patchText) {
        VirtualFile usrHomeDir;
        if (patchText == null) {
            SpringUtil.$$$reportNull$$$0(17);
        }
        if ((usrHomeDir = VfsUtil.getUserHomeDir()) == null) {
            return false;
        }
        return SpringUtil.checkSpringConfigInDir(usrHomeDir, CONFIG_FILE_NAME, patchText);
    }

    private static boolean isProjectSpringConfigDebugPatched(@NotNull Module module, @NotNull String patchText) {
        if (module == null) {
            SpringUtil.$$$reportNull$$$0(18);
        }
        if (patchText == null) {
            SpringUtil.$$$reportNull$$$0(19);
        }
        for (VirtualFile projectConfigDir : RailsPaths.getInstance(module).findFiles("config")) {
            if (!SpringUtil.checkSpringConfigInDir(projectConfigDir, PROJECT_CONFIG_FILE_NAME, patchText)) continue;
            return true;
        }
        return false;
    }

    private static void patchSystemConfigForDebug(boolean addNewPatch) throws IOException {
        VirtualFile usrHomeDir = VfsUtil.getUserHomeDir();
        if (usrHomeDir != null) {
            SpringUtil.doUpdateConfig(usrHomeDir, CONFIG_FILE_NAME, addNewPatch);
        } else {
            LOG.warn("unable to find user home directory");
        }
    }

    private static void patchProjectConfigForDebug(@NotNull Module module, boolean addNewPatch) throws IOException {
        RailsApp app;
        if (module == null) {
            SpringUtil.$$$reportNull$$$0(20);
        }
        if ((app = RailsApp.fromModule(module)) != null) {
            VirtualFile projectConfigDir = (VirtualFile)ContainerUtil.getFirstItem(app.getPaths().findFiles("config"));
            if (projectConfigDir != null) {
                SpringUtil.doUpdateConfig(projectConfigDir, PROJECT_CONFIG_FILE_NAME, addNewPatch);
            } else {
                LOG.warn("unable to find config directory for project: " + app.getProjectName());
            }
        } else {
            LOG.warn("unable to find rails application for module: " + module.getName());
        }
    }

    @RequiresEdt
    public static void configureSpringForDebug(@NotNull Map<String, String> env, @Nullable Module module) {
        if (env == null) {
            SpringUtil.$$$reportNull$$$0(21);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (module == null || module.isDisposed() || !SpringUtil.isSpringGemAvailable(module)) {
            return;
        }
        Project project = module.getProject();
        if (SpringUtil.isSpringDebugPatchDenied()) {
            SpringUtil.disableSpring(env);
            return;
        }
        boolean isOldPatchInProjectConfig = SpringUtil.isProjectSpringConfigDebugPatched(module, OLD_CONFIG_FILE_DEBUG_PATCH);
        boolean isOldPatchInSystemConfig = SpringUtil.isSystemSpringConfigDebugPatched(OLD_CONFIG_FILE_DEBUG_PATCH);
        if (isOldPatchInProjectConfig || isOldPatchInSystemConfig) {
            int res = Messages.showYesNoDialog((Project)module.getProject(), (String)RBundle.message((String)"spring.debug.config.deprecated.patch"), (String)RBundle.message((String)"spring.debug.config.deprecated.patch.title"), (Icon)Messages.getQuestionIcon());
            if (res == 0) {
                try {
                    if (isOldPatchInProjectConfig) {
                        SpringUtil.patchProjectConfigForDebug(module, true);
                        SpringUtil.patchSystemConfigForDebug(false);
                    }
                    if (isOldPatchInSystemConfig) {
                        SpringUtil.patchSystemConfigForDebug(true);
                        SpringUtil.patchProjectConfigForDebug(module, false);
                    }
                }
                catch (IOException e) {
                    LOG.warn("unable to update deprecated patch in spring config file", (Throwable)e);
                }
            }
            return;
        }
        if (SpringUtil.isSystemSpringConfigDebugPatched(CONFIG_FILE_DEBUG_PATCH) || SpringUtil.isProjectSpringConfigDebugPatched(module, CONFIG_FILE_DEBUG_PATCH)) {
            return;
        }
        SpringDebugConfigDialog dialog = new SpringDebugConfigDialog(project, RBundle.message((String)"spring.debug.config.modification.request"), RBundle.message((String)"spring.debug.config.modification.request.title"), new String[]{RBundle.message((String)"spring.debug.config.modification.system"), RBundle.message((String)"spring.debug.config.modification.project"), RBundle.message((String)"spring.debug.config.modification.disable")}, 0, 0, Messages.getQuestionIcon());
        dialog.show();
        int dialogValue = dialog.getExitCode();
        try {
            if (dialogValue == 0) {
                SpringUtil.patchSystemConfigForDebug(true);
            }
            if (dialogValue == 1) {
                SpringUtil.patchProjectConfigForDebug(module, true);
            }
        }
        catch (IOException e) {
            LOG.warn("unable to append to spring config file", (Throwable)e);
        }
        if (dialogValue == 2) {
            SpringUtil.setSpringDebugPatchDenied(true);
            SpringUtil.disableSpring(env);
        }
    }

    @TestOnly
    public static void runWithSpringEnabled(@NotNull Runnable runnable) {
        if (runnable == null) {
            SpringUtil.$$$reportNull$$$0(22);
        }
        boolean oldValue = ourEnforceSpringInTests;
        ourEnforceSpringInTests = true;
        try {
            runnable.run();
        }
        finally {
            ourEnforceSpringInTests = oldValue;
        }
    }

    @VisibleForTesting
    @ApiStatus.Internal
    @Nullable
    public static String getCustomSpringTempPath(@Nullable Module module) {
        String tempDir = FileUtil.getTempDirectory();
        if (tempDir.length() >= 71) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.warn("Failed to use custom SPRING_TMP_PATH, temp dir's path is too long (>=71)': " + tempDir);
            }
            return null;
        }
        StringBuilder sb = new StringBuilder(SPRING_TMP_DIR_PREFIX);
        if (module != null) {
            Project project = module.getProject();
            sb.append(String.format("%08x", project.getLocationHash().hashCode())).append(FileUtil.sanitizeFileName((String)project.getName()));
        }
        return StringUtil.first((String)FileUtil.join((String[])new String[]{tempDir, sb.toString()}), (int)71, (boolean)false);
    }

    public static boolean isExplicitSpringEnabled() {
        return Registry.is((String)"ruby.enable.spring.explicit.command");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 2: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "framework";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/preload/spring/SpringUtil";
                break;
            }
            case 6: 
            case 7: 
            case 13: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressTitle";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFileParentDir";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFilePath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchText";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFileName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/preload/spring/SpringUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestCommandSupportGemName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "disableSpring";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "customizeSpring";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isTestFrameworkEnabled";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTestCommandSupportGemName";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "stopSpring";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "runSpringCommand";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateConfig";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkFilePatchedForDebug";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "patchBinstubs";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkSpringConfigInDir";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isSystemSpringConfigDebugPatched";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isProjectSpringConfigDebugPatched";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "patchProjectConfigForDebug";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "configureSpringForDebug";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "runWithSpringEnabled";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

