/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.preload.spork.run;

import com.intellij.openapi.diagnostic.Logger;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rails.preload.spork.run.SporkServerRunConfiguration;
import org.jetbrains.plugins.ruby.settings.SettingsExternalizer;
import org.jetbrains.plugins.ruby.testing.SupportedTestFramework;

public class SporkServerRunConfigurationExternalizer
extends SettingsExternalizer {
    private static final Logger LOG = Logger.getInstance(SporkServerRunConfigurationExternalizer.class);
    private static final SporkServerRunConfigurationExternalizer myInstance = new SporkServerRunConfigurationExternalizer();
    @NonNls
    private static final String SCRIPT_PATH = "SCRIPT_PATH";
    @NonNls
    private static final String SCRIPT_ARGS = "SCRIPT_ARGS";
    @NonNls
    private static final String TEST_FRAMEWORK_ARGS = "TEST_FRAMEWORK_ARGS";
    @NonNls
    public static final String SPORK_RUN_CONFIG_SETTINGS_ARGS = "SPORK_RUN_CONFIG";

    public void writeExternal(SporkServerRunConfiguration config, Element elem) {
        this.writeOption(SCRIPT_PATH, config.getScriptPath(), elem);
        this.writeOption(SCRIPT_ARGS, config.getScriptArgs(), elem);
        this.writeOption(TEST_FRAMEWORK_ARGS, config.getTestFramework().toString(), elem);
        this.writeOption(SPORK_RUN_CONFIG_SETTINGS_ARGS, config.getTestFramework().toString(), elem);
    }

    public void readExternal(SporkServerRunConfiguration config, Element elem) {
        Map<String, String> optionsByName = this.buildOptionsByElement(elem);
        config.setScriptPath(optionsByName.get(SCRIPT_PATH));
        config.setScriptArgs(optionsByName.get(SCRIPT_ARGS));
        String testFrameWorkStr = optionsByName.get(TEST_FRAMEWORK_ARGS);
        if (testFrameWorkStr == null) {
            testFrameWorkStr = optionsByName.get(SPORK_RUN_CONFIG_SETTINGS_ARGS);
        }
        SupportedTestFramework testFramework = null;
        if (testFrameWorkStr != null) {
            try {
                testFramework = SupportedTestFramework.valueOf(testFrameWorkStr);
            }
            catch (IllegalArgumentException e) {
                LOG.error((Throwable)e);
            }
        }
        config.setTestFramework(testFramework != null ? testFramework : SupportedTestFramework.RSPEC);
    }

    public static SporkServerRunConfigurationExternalizer getInstance() {
        return myInstance;
    }

    @Override
    @NotNull
    public String getID() {
        return SPORK_RUN_CONFIG_SETTINGS_ARGS;
    }
}

