/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.preload.spork.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.RegistryUi;
import com.intellij.openapi.util.text.StringUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.preload.PreLoadUtil;
import org.jetbrains.plugins.ruby.rails.preload.spork.run.SporkServerRunCommandLineState;
import org.jetbrains.plugins.ruby.rails.preload.spork.run.SporkServerRunConfigurationEditor;
import org.jetbrains.plugins.ruby.rails.preload.spork.run.SporkServerRunConfigurationExternalizer;
import org.jetbrains.plugins.ruby.rails.preload.spork.run.SporkServerRunConfigurationParams;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfigurationWithScriptPath;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyAbstractCommandLineState;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;
import org.jetbrains.plugins.ruby.testing.SupportedTestFramework;

public class SporkServerRunConfiguration
extends AbstractRubyRunConfigurationWithScriptPath<SporkServerRunConfiguration>
implements SporkServerRunConfigurationParams {
    private SupportedTestFramework myTestFramework = SupportedTestFramework.RSPEC;

    public SporkServerRunConfiguration(Project project, ConfigurationFactory factory) {
        super(project, factory);
    }

    @Override
    protected String getSerializationId() {
        return "SPORK_RUN_CONFIG";
    }

    @Override
    public SupportedTestFramework getTestFramework() {
        return this.myTestFramework;
    }

    @Override
    public void setTestFramework(@NotNull SupportedTestFramework testFramework) {
        if (testFramework == null) {
            SporkServerRunConfiguration.$$$reportNull$$$0(0);
        }
        this.myTestFramework = testFramework;
    }

    @Override
    @NotNull
    protected SettingsEditor<SporkServerRunConfiguration> createConfigurationEditor() {
        return new SporkServerRunConfigurationEditor(this.getProject(), this);
    }

    @Override
    protected RubyAbstractCommandLineState createCommandLineState(@NotNull ExecutionEnvironment env) throws ExecutionException {
        if (env == null) {
            SporkServerRunConfiguration.$$$reportNull$$$0(1);
        }
        return new SporkServerRunCommandLineState(this, env);
    }

    @Override
    protected void validateConfiguration() throws RuntimeConfigurationException {
        RunConfigurationUtil.inspectSDK(this);
        this.inspectScript();
        RunConfigurationUtil.inspectWorkingDirectory(false, this);
        if (!PreLoadUtil.isSporkSupportEnabled()) {
            throw new RuntimeConfigurationWarning(RBundle.message((String)"spork.server.run.configuration.retirement.warning"), () -> new RegistryUi().show());
        }
    }

    protected void inspectScript() throws RuntimeConfigurationError {
        String scriptPathString = this.getScriptPath();
        if (StringUtil.isEmpty((String)scriptPathString)) {
            throw new RuntimeConfigurationError(RBundle.message((String)"spork.server.run.configuration.script.not.specified"));
        }
        Path scriptPath = Paths.get(scriptPathString, new String[0]);
        if (!Files.exists(scriptPath, new LinkOption[0])) {
            throw new RuntimeConfigurationError(RBundle.message((String)"spork.server.run.configuration.script.not.exists"));
        }
        if (!Files.isRegularFile(scriptPath, new LinkOption[0])) {
            throw new RuntimeConfigurationError(RBundle.message((String)"spork.server.run.configuration.script.is.not.file"));
        }
    }

    @Override
    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            SporkServerRunConfiguration.$$$reportNull$$$0(2);
        }
        super.readExternal(element);
        SporkServerRunConfigurationExternalizer.getInstance().readExternal(this, element);
    }

    @Override
    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            SporkServerRunConfiguration.$$$reportNull$$$0(3);
        }
        super.writeExternal(element);
        SporkServerRunConfigurationExternalizer.getInstance().writeExternal(this, element);
    }

    public static void copyParams(SporkServerRunConfigurationParams fromParams, SporkServerRunConfigurationParams toParams) {
        AbstractRubyRunConfigurationWithScriptPath.copyParams(fromParams, toParams);
        toParams.setTestFramework(fromParams.getTestFramework());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFramework";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/preload/spork/run/SporkServerRunConfiguration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setTestFramework";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createCommandLineState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "readExternal";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternal";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

