/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.preload.spork;

import com.intellij.DynamicBundle;
import com.intellij.openapi.module.Module;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.plugins.ruby.cucumberApi.RubyCucumberUtil;
import org.jetbrains.plugins.ruby.ruby.module.RubyModuleSettings;
import org.jetbrains.plugins.ruby.testing.SupportedTestFramework;
import org.jetbrains.plugins.ruby.testing.rspec.RSpecUtil;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.TestUnitUtil;

public class SporkServerLaunchSettings {
    private JRadioButton myCucumberRB;
    private JRadioButton myRSpecRB;
    private JRadioButton myTestUnitRB;
    private JPanel myContentPane;
    private JCheckBox myPerformBootstrapCB;

    public SporkServerLaunchSettings(Module module) {
        SupportedTestFramework lastUsedTestFramework;
        this.$$$setupUI$$$();
        RubyModuleSettings settings = RubyModuleSettings.getInstance(module);
        SupportedTestFramework supportedTestFramework = lastUsedTestFramework = settings != null ? settings.getSporkLastUsedTestFramework() : null;
        if (lastUsedTestFramework != null) {
            JRadioButton rbToSelect = switch (lastUsedTestFramework) {
                case SupportedTestFramework.TEST_UNIT, SupportedTestFramework.SHOULDA -> this.myTestUnitRB;
                case SupportedTestFramework.RSPEC -> this.myRSpecRB;
                case SupportedTestFramework.CUCUMBER -> this.myCucumberRB;
                default -> throw new IllegalArgumentException("Test framework not supported here: " + lastUsedTestFramework.getPresentableName());
            };
            if (rbToSelect != null) {
                rbToSelect.setSelected(true);
            }
        } else if (RubyCucumberUtil.isCucumberSupportEnabled(module)) {
            this.myCucumberRB.setSelected(true);
        } else if (RSpecUtil.isRSpecSupportEnabled(module)) {
            this.myRSpecRB.setSelected(true);
        } else if (TestUnitUtil.isTestUnitSupportEnabled(module)) {
            this.myTestUnitRB.setSelected(true);
        } else {
            this.myCucumberRB.setSelected(true);
        }
    }

    public JComponent getPrefferedFocusedComponent() {
        return this.myCucumberRB;
    }

    public SupportedTestFramework getSelectedFramework() {
        if (this.myCucumberRB.isSelected()) {
            return SupportedTestFramework.CUCUMBER;
        }
        if (this.myRSpecRB.isSelected()) {
            return SupportedTestFramework.RSPEC;
        }
        return SupportedTestFramework.TEST_UNIT;
    }

    public boolean performBootstrap() {
        return this.myPerformBootstrapCB.isSelected();
    }

    public JComponent getContentPane() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/RBundle", SporkServerLaunchSettings.class).getString("spork.run.settings.info"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 10, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCucumberRB = jRadioButton3 = new JRadioButton();
        jRadioButton3.setSelected(false);
        this.$$$loadButtonText$$$(jRadioButton3, DynamicBundle.getBundle((String)"messages/RBundle", SporkServerLaunchSettings.class).getString("spork.run.settings.cucumber"));
        jPanel2.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 1, 2, 1, 0, 1, 6, 1, null, null, null));
        this.myRSpecRB = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/RBundle", SporkServerLaunchSettings.class).getString("spork.run.settings.rspec"));
        jPanel2.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTestUnitRB = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/RBundle", SporkServerLaunchSettings.class).getString("spork.run.settings.testunit"));
        jPanel2.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPerformBootstrapCB = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/RBundle", SporkServerLaunchSettings.class).getString("spork.run.settings.bootstrap"));
        jPanel.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

