/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.preload.spork;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import icons.RubyIcons;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.bundler.BundleExecSettings;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.preload.PreLoadUtil;
import org.jetbrains.plugins.ruby.rails.preload.spork.SporkServerLaunchSettings;
import org.jetbrains.plugins.ruby.rails.preload.spork.run.SporkServerRunConfiguration;
import org.jetbrains.plugins.ruby.rails.preload.spork.run.SporkServerRunConfigurationFactory;
import org.jetbrains.plugins.ruby.rails.preload.spork.run.SporkServerRunConfigurationType;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.actions.RubyScriptAction;
import org.jetbrains.plugins.ruby.ruby.module.RubyModuleSettings;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.plugins.ruby.testing.SupportedTestFramework;

public class RunSporkServerScriptAction
extends RubyScriptAction {
    private static final String ITEST = "-Itest";

    public RunSporkServerScriptAction() {
        this.getTemplatePresentation().setIcon(RubyIcons.Spork.SporkServerRunConfiguration);
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            RunSporkServerScriptAction.$$$reportNull$$$0(0);
        }
        Module module = RModuleUtil.getInstance().getModule(event.getDataContext());
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        event.getPresentation().setEnabledAndVisible(PreLoadUtil.isSporkGemInstalled(sdk));
    }

    @Override
    protected boolean checkPrerequisites(AnActionEvent event) {
        if (!super.checkPrerequisites(event)) {
            return false;
        }
        Module module = RModuleUtil.getInstance().getModule(event.getDataContext());
        assert (module != null);
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        assert (sdk != null);
        if (RubyRemoteInterpreterManager.isRemoteSdk(sdk)) {
            String msg = RBundle.message((String)"spork.run.error.remote.sdk", (Object[])new Object[]{sdk.getName()});
            Messages.showErrorDialog((Project)module.getProject(), (String)msg, (String)RunSporkServerScriptAction.getErrorTitle());
            return false;
        }
        if (!PreLoadUtil.isSporkGemInstalled(sdk)) {
            String msg = RBundle.message((String)"spork.run.error.gem.not.installed", (Object[])new Object[]{sdk.getName()});
            Messages.showErrorDialog((Project)module.getProject(), (String)msg, (String)RunSporkServerScriptAction.getErrorTitle());
            return false;
        }
        File scriptFile = RunSporkServerScriptAction.getSporkServerScript(module);
        if (scriptFile == null) {
            String msg = RBundle.message((String)"spork.run.error.bin.script.not.found", (Object[])new Object[]{sdk.getName()});
            Messages.showErrorDialog((Project)module.getProject(), (String)msg, (String)RunSporkServerScriptAction.getErrorTitle());
            return false;
        }
        return true;
    }

    @Override
    protected void doActionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            RunSporkServerScriptAction.$$$reportNull$$$0(1);
        }
        Module module = RModuleUtil.getInstance().getModule(event.getDataContext());
        assert (module != null);
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        assert (sdk != null);
        File scriptFile = RunSporkServerScriptAction.getSporkServerScript(module);
        assert (scriptFile != null);
        FileDocumentManager.getInstance().saveAllDocuments();
        SporkLaunchOptionsDialog dialog = new SporkLaunchOptionsDialog(module);
        dialog.pack();
        if (dialog.showAndGet()) {
            SupportedTestFramework selectedFramework = dialog.getSelectedFramework();
            RubyModuleSettings settings = RubyModuleSettings.getInstance(module);
            settings.setSporkLastUsedTestFramework(selectedFramework);
            RunSporkServerScriptAction.runSporkScript(module, scriptFile.getPath(), selectedFramework, dialog.shouldPerformBootstrap());
        }
    }

    private static void runSporkScript(@NotNull Module module, String scriptPath, SupportedTestFramework testFramework, boolean shouldPerformBootstrap) {
        String rubyArg;
        if (module == null) {
            RunSporkServerScriptAction.$$$reportNull$$$0(2);
        }
        ArrayList<String> sporkAdditionalArgsList = new ArrayList<String>();
        String string = rubyArg = testFramework == SupportedTestFramework.TEST_UNIT && (RailsApp.fromModule(module) != null || RunSporkServerScriptAction.contentRootsContainTestsDir(module)) ? ITEST : null;
        if (shouldPerformBootstrap) {
            sporkAdditionalArgsList.add("--bootstrap");
        }
        String[] sporkArgs = ArrayUtilRt.toStringArray(sporkAdditionalArgsList);
        RunManager runManager = RunManager.getInstance((Project)module.getProject());
        RunnerAndConfigurationSettings confSettings = RunSporkServerScriptAction.findExistingSporkRunConfFor(module, testFramework);
        if (confSettings != null) {
            SporkServerRunConfiguration runConfiguration = (SporkServerRunConfiguration)confSettings.getConfiguration();
            String scriptArgs = RunConfigurationUtil.argsToString(sporkArgs);
            if (confSettings.isTemporary()) {
                RunSporkServerScriptAction.updateSettings(runConfiguration, module, scriptPath, scriptArgs);
            } else {
                boolean settingsNeedToBeUpdated = RunSporkServerScriptAction.isUpdateSettingsRequired(runConfiguration, scriptPath, scriptArgs);
                if (settingsNeedToBeUpdated) {
                    String msg = RBundle.message((String)"spork.run.settings.needed.to.be.updated", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName(), runConfiguration.getName()});
                    String title = RBundle.message((String)"spork.run.settings.title");
                    if (Messages.showYesNoDialog((Project)module.getProject(), (String)msg, (String)title, (Icon)Messages.getWarningIcon()) != 0) {
                        return;
                    }
                    RunSporkServerScriptAction.updateSettings(runConfiguration, module, scriptPath, scriptArgs);
                }
            }
            String workingDirectory = runConfiguration.getWorkingDirectory();
            String dirToRefresh = StringUtil.isEmpty((String)workingDirectory) ? null : workingDirectory;
            ApplicationManager.getApplication().runReadAction(() -> RunConfigurationUtil.executeConfiguration(runManager, confSettings, RunSporkServerScriptAction.refreshCallBack(dirToRefresh)));
            return;
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            SporkServerRunConfigurationFactory factory = SporkServerRunConfigurationType.getInstance().getFactory();
            RunnerAndConfigurationSettings settings = factory.createConfigurationSettings(module, RunSporkServerScriptAction.getDefaultSporkServerConfName(testFramework, module), scriptPath, sporkArgs, testFramework);
            SporkServerRunConfiguration runConfiguration = (SporkServerRunConfiguration)settings.getConfiguration();
            RunSporkServerScriptAction.determineAndSetWorkDirectory(module, runConfiguration);
            runConfiguration.addRubyArgs(rubyArg);
            runManager.setTemporaryConfiguration(settings);
            JRubySdkUtil.enableObjectSpaceIfNotOverriddenByUser(runConfiguration);
            String dirToRefresh = RunSporkServerScriptAction.getDirToRefresh(module, runConfiguration);
            RunConfigurationUtil.executeConfiguration(runManager, settings, RunSporkServerScriptAction.refreshCallBack(dirToRefresh));
        });
    }

    private static boolean isUpdateSettingsRequired(@NotNull SporkServerRunConfiguration runConfiguration, @NotNull String scriptPath, @NotNull String scriptArgs) {
        if (runConfiguration == null) {
            RunSporkServerScriptAction.$$$reportNull$$$0(3);
        }
        if (scriptPath == null) {
            RunSporkServerScriptAction.$$$reportNull$$$0(4);
        }
        if (scriptArgs == null) {
            RunSporkServerScriptAction.$$$reportNull$$$0(5);
        }
        if (!scriptPath.equals(runConfiguration.getScriptPath())) {
            return true;
        }
        return !scriptArgs.equals(runConfiguration.getScriptArgs());
    }

    private static void updateSettings(@NotNull SporkServerRunConfiguration runConfiguration, @NotNull Module module, @NotNull String scriptPath, @NotNull String scriptArgs) {
        if (runConfiguration == null) {
            RunSporkServerScriptAction.$$$reportNull$$$0(6);
        }
        if (module == null) {
            RunSporkServerScriptAction.$$$reportNull$$$0(7);
        }
        if (scriptPath == null) {
            RunSporkServerScriptAction.$$$reportNull$$$0(8);
        }
        if (scriptArgs == null) {
            RunSporkServerScriptAction.$$$reportNull$$$0(9);
        }
        runConfiguration.setScriptPath(scriptPath);
        runConfiguration.setScriptArgs(scriptArgs);
        if (BundlerUtil.isBundlerRuntimeEmulationEnabled(module)) {
            BundleExecSettings settings = BundleExecSettings.getFrom(runConfiguration);
            settings.myUsingBundleMode = BundleExecSettings.UsingBundleMode.AUTO;
            BundleExecSettings.putTo(runConfiguration, settings);
        }
    }

    @Nullable
    private static String getDirToRefresh(@NotNull Module module, @NotNull SporkServerRunConfiguration runConfiguration) {
        String workingDirectory;
        if (module == null) {
            RunSporkServerScriptAction.$$$reportNull$$$0(10);
        }
        if (runConfiguration == null) {
            RunSporkServerScriptAction.$$$reportNull$$$0(11);
        }
        if (!StringUtil.isEmpty((String)(workingDirectory = runConfiguration.getWorkingDirectory()))) {
            return workingDirectory;
        }
        VirtualFile suggestedWorkDirectory = RunSporkServerScriptAction.getSuggestedWorkDirectory(module);
        return suggestedWorkDirectory != null ? suggestedWorkDirectory.getPath() : null;
    }

    @Nullable
    private static ProgramRunner.Callback refreshCallBack(@Nullable String workingDirPath) {
        if (workingDirPath == null) {
            return null;
        }
        return new ProgramRunner.Callback(){

            public void processStarted(RunContentDescriptor descriptor) {
                ProcessHandler processHandler = descriptor.getProcessHandler();
                if (processHandler == null) {
                    return;
                }
                processHandler.addProcessListener(new ProcessListener(this){

                    public void processTerminated(@NotNull ProcessEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        LocalFileSystem.getInstance().refresh(true);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ruby/rails/preload/spork/RunSporkServerScriptAction$1$1", "processTerminated"));
                    }
                });
            }
        };
    }

    private static boolean contentRootsContainTestsDir(@NotNull Module module) {
        VirtualFile[] contentRoots;
        if (module == null) {
            RunSporkServerScriptAction.$$$reportNull$$$0(12);
        }
        for (VirtualFile contentRoot : contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            if (contentRoot.findChild("test") == null) continue;
            return true;
        }
        return false;
    }

    private static void determineAndSetWorkDirectory(Module module, SporkServerRunConfiguration runConfiguration) {
        VirtualFile moduleRoot;
        if (StringUtil.isEmptyOrSpaces((String)runConfiguration.getWorkingDirectory()) && (moduleRoot = RunSporkServerScriptAction.getSuggestedWorkDirectory(module)) != null) {
            runConfiguration.setWorkingDirectory(FileUtil.toSystemDependentName((String)moduleRoot.getPath()));
        }
    }

    @Nullable
    private static VirtualFile getSuggestedWorkDirectory(@Nullable Module module) {
        if (module != null) {
            RailsApp railsApp = RailsApp.fromModule(module);
            if (railsApp != null) {
                return railsApp.getRailsApplicationRoot();
            }
            return RModuleUtil.getInstance().getFirstContentRoot(module);
        }
        return null;
    }

    @Nullable
    public static RunnerAndConfigurationSettings findExistingSporkRunConfFor(@NotNull Module module, @NotNull SupportedTestFramework testFramework) {
        if (module == null) {
            RunSporkServerScriptAction.$$$reportNull$$$0(13);
        }
        if (testFramework == null) {
            RunSporkServerScriptAction.$$$reportNull$$$0(14);
        }
        for (RunnerAndConfigurationSettings confSettings : RunManager.getInstance((Project)module.getProject()).getConfigurationSettingsList((ConfigurationType)SporkServerRunConfigurationType.getInstance())) {
            SporkServerRunConfiguration configuration = (SporkServerRunConfiguration)confSettings.getConfiguration();
            if (configuration.getTestFramework() != testFramework) continue;
            String configurationName = configuration.getName();
            if (!RunSporkServerScriptAction.getDefaultSporkServerConfName(testFramework, module).equals(configurationName) || !module.equals((Object)configuration.getModule())) continue;
            return confSettings;
        }
        return null;
    }

    public static String getDefaultSporkServerConfName(@NotNull SupportedTestFramework testFramework, @NotNull Module module) {
        if (testFramework == null) {
            RunSporkServerScriptAction.$$$reportNull$$$0(15);
        }
        if (module == null) {
            RunSporkServerScriptAction.$$$reportNull$$$0(16);
        }
        return RBundle.message((String)"spork.run.drb_server.run.conf.name", (Object[])new Object[]{testFramework.getPresentableName(), module.getName()});
    }

    @Nullable
    private static File getSporkServerScript(@NotNull Module module) {
        String sporkExecutable;
        if (module == null) {
            RunSporkServerScriptAction.$$$reportNull$$$0(17);
        }
        if ((sporkExecutable = PreLoadUtil.getSporkExecutablePath(module)) == null) {
            return null;
        }
        File file = new File(sporkExecutable);
        try {
            return file.exists() && file.isFile() ? file : null;
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptPath";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptArgs";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFramework";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/preload/spork/RunSporkServerScriptAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "doActionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "runSporkScript";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isUpdateSettingsRequired";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "updateSettings";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getDirToRefresh";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "contentRootsContainTestsDir";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "findExistingSporkRunConfFor";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "getDefaultSporkServerConfName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "getSporkServerScript";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SporkLaunchOptionsDialog
    extends DialogWrapper {
        private SporkServerLaunchSettings myForm;
        private final Module myModule;

        protected SporkLaunchOptionsDialog(Module module) {
            super(module.getProject(), true);
            this.myModule = module;
            this.setTitle(RBundle.message((String)"spork.run.settings.title"));
            this.init();
        }

        @NotNull
        public SupportedTestFramework getSelectedFramework() {
            assert (this.myForm != null);
            SupportedTestFramework supportedTestFramework = this.myForm.getSelectedFramework();
            if (supportedTestFramework == null) {
                SporkLaunchOptionsDialog.$$$reportNull$$$0(0);
            }
            return supportedTestFramework;
        }

        public boolean shouldPerformBootstrap() {
            assert (this.myForm != null);
            return this.myForm.performBootstrap();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            this.myForm = new SporkServerLaunchSettings(this.myModule);
            return this.myForm.getContentPane();
        }

        protected Action @NotNull [] createActions() {
            this.setOKButtonText(RBundle.message((String)"spork.run.settings.button.ok.caption"));
            Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
            if (actionArray == null) {
                SporkLaunchOptionsDialog.$$$reportNull$$$0(1);
            }
            return actionArray;
        }

        public JComponent getPreferredFocusedComponent() {
            assert (this.myForm != null);
            return this.myForm.getPrefferedFocusedComponent();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jetbrains/plugins/ruby/rails/preload/spork/RunSporkServerScriptAction$SporkLaunchOptionsDialog";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelectedFramework";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createActions";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

