/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.nameConventions;

import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.InflectorService;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public final class HelpersConventions {
    @NonNls
    public static final String HELPER = "Helper";

    public static boolean isHelperFile(@NotNull PsiFile file, @Nullable Module module) {
        RFile rFile;
        if (file == null) {
            HelpersConventions.$$$reportNull$$$0(0);
        }
        return (rFile = (RFile)file.getViewProvider().getPsi((Language)RubyLanguage.INSTANCE)) != null && HelpersConventions.isHelperFile(file, module, RContainerUtil.getTopLevelModules((RContainer)rFile));
    }

    public static boolean isHelperFile(@NotNull PsiFile rFile, @Nullable Module module, @NotNull List<? extends RModule> modules) {
        if (rFile == null) {
            HelpersConventions.$$$reportNull$$$0(1);
        }
        if (modules == null) {
            HelpersConventions.$$$reportNull$$$0(2);
        }
        if (module == null) {
            return false;
        }
        VirtualFile virtualFile = RubyPsiUtil.getVirtualFileFromElement((PsiElement)rFile);
        if (virtualFile == null) {
            return false;
        }
        String fileUrl = virtualFile.getUrl();
        String fileName = FileUtilRt.getNameWithoutExtension((String)rFile.getName());
        if (!fileName.endsWith("_helper")) {
            return false;
        }
        if (!VfsUtilCore.isUnder((String)fileUrl, RailsPaths.getInstance(module).getUrls("app/helpers"))) {
            return false;
        }
        for (RModule rModule : modules) {
            if (!HelpersConventions.isHelperModule(module, rModule)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String getHelperNameByModuleName(@Nullable String moduleName, @Nullable Module module) {
        if (moduleName == null) {
            return "";
        }
        String name = NamingConventions.toUnderscoreCase((String)moduleName, (Module)module);
        if (!name.endsWith("_helper")) {
            return "";
        }
        String string = name.substring(0, name.length() - "_helper".length());
        if (string == null) {
            HelpersConventions.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public static String getHelperNameByFileName(@NotNull String fileName) {
        String nameWOExt;
        if (fileName == null) {
            HelpersConventions.$$$reportNull$$$0(4);
        }
        if (!(nameWOExt = FileUtilRt.getNameWithoutExtension((String)fileName)).endsWith("_helper")) {
            return null;
        }
        return nameWOExt.substring(0, nameWOExt.length() - "_helper".length());
    }

    public static boolean isHelperModule(@NotNull Module module, @Nullable RModule container) {
        if (module == null) {
            HelpersConventions.$$$reportNull$$$0(5);
        }
        if (container == null) {
            return false;
        }
        FQN fqn = container.getFQNWithNesting();
        if (fqn == FQN.INVALID || !fqn.getShortName().endsWith(HELPER)) {
            return false;
        }
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)container.getContainingFile().getOriginalFile());
        return file != null && VfsUtilCore.isUnderFiles((VirtualFile)file, RailsPaths.getInstance(module).findFiles("app/helpers"));
    }

    @NotNull
    public static String getHelperFileNameByHelperModuleName(@Nullable String helperModuleName, @Nullable Module module) {
        String name = HelpersConventions.getHelperNameByModuleName(helperModuleName, module);
        String string = HelpersConventions.getHelperFileNameByHelperName(name);
        if (string == null) {
            HelpersConventions.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static String getHelperFileNameByHelperName(String helperName) {
        if (helperName == null) {
            return "";
        }
        return HelpersConventions.getHelperFileNameWithoutExtensionByHelperName(helperName) + "." + RubyFileType.RUBY.getDefaultExtension();
    }

    public static String getHelperFileNameWithoutExtensionByHelperName(String helperName) {
        return helperName + "_helper";
    }

    @NotNull
    public static String getHelperModuleNameByHelperName(@Nullable String name, @NotNull Module module) {
        if (module == null) {
            HelpersConventions.$$$reportNull$$$0(7);
        }
        String string = InflectorService.getInstance(module).camelize(name) + HELPER;
        if (string == null) {
            HelpersConventions.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    public static String getRelativePathOfHelperFolder(@Nullable String fileUrl, @NotNull Module module) {
        if (module == null) {
            HelpersConventions.$$$reportNull$$$0(9);
        }
        return fileUrl != null ? RailsPaths.getInstance(module).getRelativePath("app/helpers", fileUrl) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/nameConventions/HelpersConventions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/nameConventions/HelpersConventions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelperNameByModuleName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelperFileNameByHelperModuleName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelperModuleNameByHelperName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isHelperFile";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getHelperNameByFileName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isHelperModule";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getHelperModuleNameByHelperName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePathOfHelperFolder";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6, 8 -> new IllegalStateException(string);
        };
    }
}

