/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.model.psi.declaration;

import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolDeclaration;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.Processor;
import java.util.SequencedSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.model.navigation.NavigationTarget;
import org.jetbrains.plugins.ruby.model.navigation.PsiFileSystemItemNavigationTarget;
import org.jetbrains.plugins.ruby.model.psi.declaration.NavigatablePsiSymbolDeclaration;
import org.jetbrains.plugins.ruby.model.psi.declaration.PsiSymbolDeclarationsSearch;
import org.jetbrains.plugins.ruby.rails.facet.versions.BaseRailsFacet;
import org.jetbrains.plugins.ruby.rails.model.impl.extensions.RailsImplicitDirectorySymbolService;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubyClassSymbol;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubyModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.model.psi.declaration.RubySearchablePsiSymbolDeclaration;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u000e\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/ruby/rails/model/psi/declaration/RailsImplicitModuleSymbolDeclarationQueryExecutor;", "Lcom/intellij/openapi/application/QueryExecutorBase;", "Lcom/intellij/model/psi/PsiSymbolDeclaration;", "Lorg/jetbrains/plugins/ruby/model/psi/declaration/PsiSymbolDeclarationsSearch$SearchParameters;", "<init>", "()V", "processQuery", "", "parameters", "processor", "Lcom/intellij/util/Processor;", "MyPsiSymbolDeclaration", "intellij.ruby.backend"})
final class RailsImplicitModuleSymbolDeclarationQueryExecutor
extends QueryExecutorBase<PsiSymbolDeclaration, PsiSymbolDeclarationsSearch.SearchParameters> {
    public RailsImplicitModuleSymbolDeclarationQueryExecutor() {
        super(true);
    }

    public void processQuery(@NotNull PsiSymbolDeclarationsSearch.SearchParameters parameters, @NotNull Processor<? super PsiSymbolDeclaration> processor) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        if (!parameters.isQueryValid()) {
            return;
        }
        Project project = parameters.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        SearchScope searchScope = parameters.searchScope();
        Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"searchScope(...)");
        SearchScope searchScope2 = searchScope;
        Symbol symbol = parameters.symbol();
        RubyModuleSymbol rubyModuleSymbol = symbol instanceof RubyModuleSymbol ? (RubyModuleSymbol)symbol : null;
        if (rubyModuleSymbol == null) {
            return;
        }
        RubyModuleSymbol symbol2 = rubyModuleSymbol;
        if (symbol2.isAnonymous()) {
            return;
        }
        FQN fQN = symbol2.getFqn();
        Intrinsics.checkNotNullExpressionValue((Object)fQN, (String)"getFqn(...)");
        FQN fqn = fQN;
        SequencedSet<FQN> sequencedSet = RailsImplicitDirectorySymbolService.getInstance(project2).getSymbolFqns(searchScope2);
        Intrinsics.checkNotNullExpressionValue(sequencedSet, (String)"getSymbolFqns(...)");
        SequencedSet<FQN> fqns = sequencedSet;
        if (!fqns.contains(fqn) || RubyClassSymbol.find(project2, searchScope2, fqn).isPresent()) {
            return;
        }
        Module[] moduleArray = RModuleUtil.getInstance().getAllModulesWithRubySupport(project2);
        Intrinsics.checkNotNullExpressionValue((Object)moduleArray, (String)"getAllModulesWithRubySupport(...)");
        for (Module module : moduleArray) {
            String relativePath;
            BaseRailsFacet facet = BaseRailsFacet.getInstance(module);
            if (facet == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)NamingConventions.toUnderscoreCase((String)fqn.getFullPath(), (Module)module), (String)"toUnderscoreCase(...)");
            if (StringsKt.isBlank((CharSequence)relativePath)) continue;
            for (VirtualFile root : facet.getImplicitModuleDirectoryRoots()) {
                PsiDirectory psiDirectory;
                VirtualFile directory;
                if (!root.isDirectory() || (directory = root.findFileByRelativePath(relativePath)) == null || !directory.isDirectory() || !searchScope2.contains(directory) || (psiDirectory = PsiManager.getInstance((Project)project2).findDirectory(directory)) == null) continue;
                processor.process((Object)new MyPsiSymbolDeclaration(psiDirectory, fqn));
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/ruby/rails/model/psi/declaration/RailsImplicitModuleSymbolDeclarationQueryExecutor$MyPsiSymbolDeclaration;", "Lorg/jetbrains/plugins/ruby/model/psi/declaration/NavigatablePsiSymbolDeclaration;", "Lorg/jetbrains/plugins/ruby/ruby/model/psi/declaration/RubySearchablePsiSymbolDeclaration;", "directory", "Lcom/intellij/psi/PsiDirectory;", "fqn", "Lorg/jetbrains/plugins/ruby/ruby/codeInsight/symbols/fqn/FQN;", "<init>", "(Lcom/intellij/psi/PsiDirectory;Lorg/jetbrains/plugins/ruby/ruby/codeInsight/symbols/fqn/FQN;)V", "getDeclaringElement", "Lcom/intellij/psi/PsiElement;", "getNavigationTarget", "Lorg/jetbrains/plugins/ruby/model/navigation/NavigationTarget;", "getRangeInDeclaringElement", "Lcom/intellij/openapi/util/TextRange;", "getSymbol", "Lorg/jetbrains/plugins/ruby/ruby/model/impl/RubyModuleSymbol;", "intellij.ruby.backend"})
    private static final class MyPsiSymbolDeclaration
    implements NavigatablePsiSymbolDeclaration,
    RubySearchablePsiSymbolDeclaration {
        @NotNull
        private final PsiDirectory directory;
        @NotNull
        private final FQN fqn;

        public MyPsiSymbolDeclaration(@NotNull PsiDirectory directory, @NotNull FQN fqn) {
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            Intrinsics.checkNotNullParameter((Object)fqn, (String)"fqn");
            this.directory = directory;
            this.fqn = fqn;
        }

        @NotNull
        public PsiElement getDeclaringElement() {
            return (PsiElement)this.directory;
        }

        @Override
        @NotNull
        public NavigationTarget getNavigationTarget() {
            return new PsiFileSystemItemNavigationTarget((PsiFileSystemItem)this.directory);
        }

        @NotNull
        public TextRange getRangeInDeclaringElement() {
            TextRange textRange = TextRange.EMPTY_RANGE;
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"EMPTY_RANGE");
            return textRange;
        }

        @Override
        @NotNull
        public RubyModuleSymbol getSymbol() {
            return new RubyModuleSymbol(this.fqn);
        }
    }
}

