/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.model.impl.extensions;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SequencedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.model.cache.IdempotentCache;
import org.jetbrains.plugins.ruby.rails.RailsFacetModificationTracker;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPathsModificationTracker;
import org.jetbrains.plugins.ruby.rails.facet.versions.BaseRailsFacet;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;

@Service(value={Service.Level.PROJECT})
public final class RailsImplicitDirectorySymbolService
implements Disposable {
    private final Project myProject;
    private final Cache<@NotNull SearchScope, @NotNull SequencedSet<FQN>> myCache;
    private final AtomicLong myStamp;

    public RailsImplicitDirectorySymbolService(@NotNull Project project) {
        if (project == null) {
            RailsImplicitDirectorySymbolService.$$$reportNull$$$0(0);
        }
        this.myStamp = new AtomicLong();
        this.myProject = project;
        this.myCache = new IdempotentCache<SearchScope, SequencedSet<FQN>>(project, Caffeine.newBuilder().maximumSize(100L).build());
        LowMemoryWatcher.register(() -> this.myCache.invalidateAll(), (Disposable)this);
    }

    public void dispose() {
        this.myCache.invalidateAll();
    }

    @NotNull
    public SequencedSet<FQN> getSymbolFqns(@NotNull SearchScope searchScope) {
        long stamp;
        if (searchScope == null) {
            RailsImplicitDirectorySymbolService.$$$reportNull$$$0(1);
        }
        if (this.myStamp.getAndSet(stamp = VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS.getModificationCount() + RailsFacetModificationTracker.getInstance(this.myProject).getModificationCount() + RailsPathsModificationTracker.getInstance(this.myProject).getModificationCount()) != stamp) {
            this.myCache.invalidateAll();
        }
        SequencedSet sequencedSet = (SequencedSet)this.myCache.get((Object)searchScope, __ -> {
            LinkedHashSet<FQN> fqns = new LinkedHashSet<FQN>();
            CachedValuesManager manager = CachedValuesManager.getManager((Project)this.myProject);
            for (Pair pair : (SequencedSet)manager.getCachedValue((UserDataHolder)this.myProject, (CachedValueProvider)new MyCachedValueProvider(this.myProject))) {
                VirtualFile directory = (VirtualFile)pair.getFirst();
                if (!directory.isValid() || !searchScope.contains(directory)) continue;
                fqns.add((FQN)pair.getSecond());
            }
            return Collections.unmodifiableSequencedSet(fqns);
        });
        if (sequencedSet == null) {
            RailsImplicitDirectorySymbolService.$$$reportNull$$$0(2);
        }
        return sequencedSet;
    }

    @NotNull
    public static RailsImplicitDirectorySymbolService getInstance(@NotNull Project project) {
        if (project == null) {
            RailsImplicitDirectorySymbolService.$$$reportNull$$$0(3);
        }
        RailsImplicitDirectorySymbolService railsImplicitDirectorySymbolService = (RailsImplicitDirectorySymbolService)project.getService(RailsImplicitDirectorySymbolService.class);
        if (railsImplicitDirectorySymbolService == null) {
            RailsImplicitDirectorySymbolService.$$$reportNull$$$0(4);
        }
        return railsImplicitDirectorySymbolService;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/model/impl/extensions/RailsImplicitDirectorySymbolService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/model/impl/extensions/RailsImplicitDirectorySymbolService";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymbolFqns";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSymbolFqns";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }

    private static final class MyCachedValueProvider
    implements CachedValueProvider<SequencedSet<Pair<VirtualFile, FQN>>> {
        private final Project myProject;

        private MyCachedValueProvider(@NotNull Project project) {
            if (project == null) {
                MyCachedValueProvider.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        @NotNull
        public CachedValueProvider.Result<SequencedSet<Pair<VirtualFile, FQN>>> compute() {
            TreeSet<Pair> directories = new TreeSet<Pair>(Comparator.comparing(it -> ((FQN)it.getSecond()).getFullPath()));
            ProjectFileIndex index = ProjectFileIndex.getInstance((Project)this.myProject);
            for (Module module : RModuleUtil.getInstance().getAllModulesWithRubySupport(this.myProject)) {
                BaseRailsFacet facet = BaseRailsFacet.getInstance(module);
                if (facet == null) continue;
                for (VirtualFile root : facet.getImplicitModuleDirectoryRoots()) {
                    index.iterateContentUnderDirectory(root, fileOrDir -> {
                        if (!fileOrDir.isDirectory()) {
                            return true;
                        }
                        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)fileOrDir, (VirtualFile)root);
                        if (relativePath == null || relativePath.isBlank()) {
                            return true;
                        }
                        FQN fqn = BaseRailsFacet.getModuleFQNFromDirectories(StringUtil.split((String)relativePath, (String)"/"), module);
                        if (fqn == FQN.INVALID) {
                            return true;
                        }
                        directories.add(new Pair((Object)fileOrDir, (Object)fqn));
                        return true;
                    });
                }
            }
            List<RailsPathsModificationTracker> dependencies = List.of(VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS, RailsFacetModificationTracker.getInstance(this.myProject), RailsPathsModificationTracker.getInstance(this.myProject));
            CachedValueProvider.Result result = CachedValueProvider.Result.create(directories, dependencies);
            if (result == null) {
                MyCachedValueProvider.$$$reportNull$$$0(1);
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/model/impl/extensions/RailsImplicitDirectorySymbolService$MyCachedValueProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/model/impl/extensions/RailsImplicitDirectorySymbolService$MyCachedValueProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "compute";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

