/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.model.RailsClassItem;
import org.jetbrains.plugins.ruby.rails.model.RailsHelper;
import org.jetbrains.plugins.ruby.rails.model.RailsLayout;
import org.jetbrains.plugins.ruby.rails.model.RailsView;
import org.jetbrains.plugins.ruby.rails.nameConventions.ViewsConventions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;

public abstract class RailsViewOwner
extends RailsClassItem {
    protected RailsViewOwner(@NotNull Module module, @NotNull RClass aClass) {
        if (module == null) {
            RailsViewOwner.$$$reportNull$$$0(0);
        }
        if (aClass == null) {
            RailsViewOwner.$$$reportNull$$$0(1);
        }
        super(module, aClass);
    }

    public abstract boolean isAbstract();

    @NotNull
    public abstract String getName();

    @NotNull
    public abstract String getQualifiedName();

    @NotNull
    public List<? extends RailsView> getAllViews() {
        Module module = this.getModule();
        List list = this.getViewsFolders().stream().flatMap(it -> Arrays.stream(it.getChildren())).mapMulti((it, consumer) -> {
            RailsView view = RailsView.fromFile(it, module);
            if (view != null && !view.isPartial()) {
                consumer.accept(view);
            }
        }).toList();
        if (list == null) {
            RailsViewOwner.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    public RailsHelper getHelper() {
        return RailsHelper.fromQualifiedName(this.myModule, this.getQualifiedName());
    }

    @NotNull
    public List<VirtualFile> getViewsFolders() {
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        List list = ContainerUtil.filter((Collection)ContainerUtil.mapNotNull(this.getViewsFolderUrls(), arg_0 -> ((VirtualFileManager)virtualFileManager).findFileByUrl(arg_0)), VirtualFile::isDirectory);
        if (list == null) {
            RailsViewOwner.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public abstract List<String> getViewsFolderUrls();

    @NotNull
    public List<? extends RailsLayout> getAllLayouts() {
        List list = ContainerUtil.flatMap(this.getLayoutsFolders(), this::findLayoutsInFolder);
        if (list == null) {
            RailsViewOwner.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<VirtualFile> getLayoutsFolders() {
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        List list = ContainerUtil.filter((Collection)ContainerUtil.mapNotNull(this.getLayoutsFolderUrls(), arg_0 -> ((VirtualFileManager)virtualFileManager).findFileByUrl(arg_0)), VirtualFile::isDirectory);
        if (list == null) {
            RailsViewOwner.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public abstract List<String> getLayoutsFolderUrls();

    @NotNull
    private List<RailsLayout> findLayoutsInFolder(@NotNull VirtualFile layoutsDir) {
        if (layoutsDir == null) {
            RailsViewOwner.$$$reportNull$$$0(6);
        }
        String name = this.getName();
        List<RailsLayout> list = Arrays.stream(layoutsDir.getChildren()).filter(file -> ViewsConventions.isLayoutFile(file) && name.equals(ViewsConventions.getActionMethodNameByView(file))).map(file -> new RailsLayout((VirtualFile)file, this.myModule, this)).collect(Collectors.toList());
        if (list == null) {
            RailsViewOwner.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/model/RailsViewOwner";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutsDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/model/RailsViewOwner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllViews";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewsFolders";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLayouts";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayoutsFolders";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findLayoutsInFolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findLayoutsInFolder";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 7 -> new IllegalStateException(string);
        };
    }
}

