/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.InflectorService;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.RailsModelSymbol;
import org.jetbrains.plugins.ruby.rails.model.ActiveRecordModel;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.model.RailsClassItem;
import org.jetbrains.plugins.ruby.rails.model.RailsController;
import org.jetbrains.plugins.ruby.rails.rspec.model.RailsRSpecModelTest;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyFQNUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public class RailsModel
extends RailsClassItem {
    public static final Set<String> CALLBACKS = Set.of("after_initialize", "after_find", "after_touch", "before_validation", "after_validation", "before_save", "around_save", "after_save", "before_create", "around_create", "after_create", "before_update", "around_update", "after_update", "before_destroy", "around_destroy", "after_destroy", "after_commit", "after_rollback", "after_create_commit", "after_update_commit", "after_save_commit", "after_destroy_commit");
    private String myQualifiedName;

    protected RailsModel(@NotNull Module module, RClass rClass) {
        if (module == null) {
            RailsModel.$$$reportNull$$$0(0);
        }
        super(module, rClass);
    }

    @Deprecated
    @Nullable
    public static RailsModel fromFile(Module module, VirtualFile vFile) {
        return RailsModel.fromFile(PsiManager.getInstance((Project)module.getProject()).findFile(vFile));
    }

    @Nullable
    public static RailsModel fromClass(@Nullable RClass clazz) {
        if (clazz == null || !clazz.isValid()) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)clazz);
        return module != null && ActiveRecordModel.isActiveRecordClass(clazz) ? new RailsModel(module, clazz) : null;
    }

    @Deprecated
    @Nullable
    public static RailsModel fromFile(@Nullable PsiFile psiFile) {
        if (!(psiFile instanceof RFile)) {
            return null;
        }
        RFile file = (RFile)psiFile;
        RailsApp app = RailsApp.fromPsiElement((PsiElement)file);
        if (app == null) {
            return null;
        }
        for (RClass clazz : RContainerUtil.getAllClasses((RContainer)file)) {
            if (!ActiveRecordModel.isActiveRecordClass(clazz)) continue;
            return new RailsModel(app.getModule(), clazz);
        }
        return null;
    }

    @Nullable
    public static RailsModel fromModelName(@Nullable Module module, @Nullable String modelName) {
        if (module == null || modelName == null) {
            return null;
        }
        InflectorService inflector = InflectorService.getInstance(module);
        if (!inflector.isInflectorAvailable()) {
            return null;
        }
        String name = inflector.camelize(inflector.singularize(inflector.tableize(modelName)));
        RContainer container = RubyFQNUtil.findContainerByFQN(module.getProject(), SymbolUtil.getClassTypes(), FQN.ofNullable((String)name), null);
        return RailsModel.fromClass((RClass)ObjectUtils.tryCast((Object)container, RClass.class));
    }

    public String getName() {
        return NamingConventions.toUnderscoreCase((String)this.myClass.getFQNWithNesting().getShortName(), (Module)this.myModule);
    }

    @NotNull
    public String getQualifiedName() {
        if (this.myQualifiedName == null) {
            this.myQualifiedName = NamingConventions.toUnderscoreCase((String)this.myClass.getFQNWithNesting().getFullPath(), (Module)this.myModule);
        }
        String string = this.myQualifiedName;
        if (string == null) {
            RailsModel.$$$reportNull$$$0(1);
        }
        return string;
    }

    public String getClassName() {
        return this.myClass.getName();
    }

    @Nullable
    public RClass getUnitTestClass() {
        List<VirtualFile> modelsRoots;
        RailsApp app = this.getApp();
        VirtualFile unitTestRoot = app.getUnitTestsRoot();
        RClass testClass = this.getTestClass(unitTestRoot, modelsRoots = app.getPaths().findFiles("app/models"), this.getName(), this.myClass.getName());
        if (testClass != null) {
            return testClass;
        }
        String pluralName = this.getPluralName();
        if (pluralName == null) {
            return null;
        }
        return this.getTestClass(unitTestRoot, modelsRoots, pluralName, InflectorService.getInstance(app.getModule()).camelize(pluralName));
    }

    @Nullable
    public RailsRSpecModelTest getSpecTest() {
        return RailsRSpecModelTest.fromModel(this);
    }

    @Nullable
    public String getPluralName() {
        InflectorService service = InflectorService.getInstance(this.myModule);
        return service.isInflectorAvailable() ? service.pluralize(this.getName()) : null;
    }

    @Nullable
    public RailsController getController() {
        String qualifiedName = this.getQualifiedName();
        RailsController controller = this.getApp().findController(qualifiedName);
        if (controller != null) {
            return controller;
        }
        String pluralName = this.getPluralName();
        if (pluralName == null) {
            return null;
        }
        String shortName = this.getName();
        String relativePath = qualifiedName.substring(0, qualifiedName.length() - shortName.length());
        return this.getApp().findController(relativePath + pluralName);
    }

    @Nullable
    public VirtualFile getFixtureUnitTestFile() {
        RailsApp app = this.getApp();
        VirtualFile unitTestsRoot = app.getUTestsRoot();
        if (unitTestsRoot != null) {
            VirtualFile[] virtualFiles;
            for (VirtualFile file : virtualFiles = unitTestsRoot.getChildren()) {
                VirtualFile[] fixtureFiles;
                if (!file.isDirectory() || !file.getName().equals("fixtures")) continue;
                for (VirtualFile fixtureFile : fixtureFiles = file.getChildren()) {
                    if (!fixtureFile.isValid() || !fixtureFile.getNameWithoutExtension().equals(this.getPluralName())) continue;
                    return fixtureFile;
                }
            }
        }
        return null;
    }

    @Nullable
    public static RailsModel findByTableName(@NotNull Project project, @NotNull String tableName, @Nullable PsiElement invocationPoint) {
        if (project == null) {
            RailsModel.$$$reportNull$$$0(2);
        }
        if (tableName == null) {
            RailsModel.$$$reportNull$$$0(3);
        }
        Ref modelRef = new Ref();
        RailsModelSymbol.processModels(project, invocationPoint, (Processor<? super Symbol>)((Processor)symbol -> {
            Optional.ofNullable(symbol.getPsiElement()).map(PsiElement::getContainingFile).map(ActiveRecordModel::fromFile).filter(model -> tableName.equals(model.getTableName())).ifPresent(arg_0 -> ((Ref)modelRef).set(arg_0));
            return modelRef.isNull();
        }));
        return (RailsModel)modelRef.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/model/RailsModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/model/RailsModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findByTableName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

