/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.model;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.model.RailsMailer;
import org.jetbrains.plugins.ruby.rails.model.RailsMailerTemplate;
import org.jetbrains.plugins.ruby.rails.model.RailsViewOwnerAction;
import org.jetbrains.plugins.ruby.rails.nameConventions.ViewsConventions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

public class RailsMailerMethod
extends RailsViewOwnerAction {
    private final RailsMailer myMailer;
    private final RMethod myMethod;

    RailsMailerMethod(@NotNull RailsMailer mailer, @NotNull RMethod method) {
        if (mailer == null) {
            RailsMailerMethod.$$$reportNull$$$0(0);
        }
        if (method == null) {
            RailsMailerMethod.$$$reportNull$$$0(1);
        }
        super(mailer.getModule());
        this.myMailer = mailer;
        this.myMethod = method;
    }

    @Override
    @NotNull
    public RailsMailer getViewOwner() {
        RailsMailer railsMailer = this.myMailer;
        if (railsMailer == null) {
            RailsMailerMethod.$$$reportNull$$$0(2);
        }
        return railsMailer;
    }

    @Nullable
    public static RailsMailerMethod fromMethod(@NotNull RMethod method) {
        if (method == null) {
            RailsMailerMethod.$$$reportNull$$$0(3);
        }
        if (!RailsMailerMethod.validateMethod(method)) {
            return null;
        }
        RContainer container = method.getParentContainer();
        if (!(container instanceof RClass)) {
            return null;
        }
        RailsMailer controller = RailsMailer.fromClass((RClass)container);
        return controller != null ? new RailsMailerMethod(controller, method) : null;
    }

    private static boolean validateMethod(RMethod method) {
        return !(method instanceof RSingletonMethod) && method.getVisibility() == Visibility.PUBLIC;
    }

    public List<RailsMailerTemplate> getTemplates() {
        ArrayList<RailsMailerTemplate> result = new ArrayList<RailsMailerTemplate>();
        for (VirtualFile templatesFolder : this.myMailer.getTemplatesFolders()) {
            VirtualFile[] children;
            for (VirtualFile child : children = templatesFolder.getChildren()) {
                String name = ViewsConventions.getViewOrLayoutNameByFileName(child.getName());
                if (!name.equals(this.getName())) continue;
                result.add(new RailsMailerTemplate(child, this.getModule()));
            }
        }
        return result;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myMethod.getName();
        if (string == null) {
            RailsMailerMethod.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mailer";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/model/RailsMailerMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/model/RailsMailerMethod";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewOwner";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromMethod";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }
}

