/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.model.RailsFqns;
import org.jetbrains.plugins.ruby.rails.model.RailsViewOwner;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyFQNUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util.SymbolHierarchy;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public final class RailsMailer
extends RailsViewOwner {
    private RailsMailer(@NotNull Module module, @NotNull RClass aClass) {
        if (module == null) {
            RailsMailer.$$$reportNull$$$0(0);
        }
        if (aClass == null) {
            RailsMailer.$$$reportNull$$$0(1);
        }
        super(module, aClass);
    }

    @Override
    @NotNull
    public String getQualifiedName() {
        String string = NamingConventions.toUnderscoreCase((String)this.getFqnWithNesting().getFullPath(), (Module)this.myModule);
        if (string == null) {
            RailsMailer.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public boolean isAbstract() {
        return this.getFqnWithNesting().equals((Object)RailsFqns.ACTION_MAILER_BASE);
    }

    @Nullable
    public static RailsMailer fromClass(@Nullable RClass clazz) {
        Module module = (Module)ObjectUtils.doIfNotNull((Object)clazz, ModuleUtilCore::findModuleForPsiElement);
        if (module == null) {
            return null;
        }
        return RailsMailer.isMailerClass(clazz) ? new RailsMailer(module, clazz) : null;
    }

    @Deprecated
    @Nullable
    public static RailsMailer fromFile(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            RailsMailer.$$$reportNull$$$0(3);
        }
        return RailsMailer.fromFile(ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile), RubyPsiUtil.getVirtualFileFromElement((PsiElement)psiFile));
    }

    @Deprecated
    @Nullable
    public static RailsMailer fromFile(@Nullable Module module, @Nullable VirtualFile virtualFile) {
        if (module == null || virtualFile == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(virtualFile);
        if (!(psiFile instanceof RFile)) {
            return null;
        }
        RFile file = (RFile)psiFile;
        RClass clazz = (RClass)ContainerUtil.find(RContainerUtil.getAllClasses((RContainer)file), RailsMailer::isMailerClass);
        return clazz != null ? new RailsMailer(module, clazz) : null;
    }

    @Nullable
    public static RailsMailer fromQualifiedName(@Nullable Module module, @NotNull String fullQualifiedName) {
        RailsApp app;
        if (fullQualifiedName == null) {
            RailsMailer.$$$reportNull$$$0(4);
        }
        if ((app = RailsApp.fromModule(module)) == null) {
            return null;
        }
        FQN fqn = FQN.of((String)NamingConventions.toCamelCase((String)app.appendProjectPrefix(fullQualifiedName), (Module)module));
        RContainer container = RubyFQNUtil.findContainerByFQN(module.getProject(), SymbolUtil.getClassTypes(), fqn, null);
        return RailsMailer.fromClass((RClass)ObjectUtils.tryCast((Object)container, RClass.class));
    }

    @Nullable
    public static RailsMailer fromViewsFolder(Module module, String viewsFolderUrl) {
        if (module == null || viewsFolderUrl == null) {
            return null;
        }
        RailsPaths paths = RailsPaths.getInstance(module);
        String mailerRelativePath = paths.getRelativePath("app/views", viewsFolderUrl);
        if (mailerRelativePath == null) {
            return null;
        }
        return RailsMailer.fromQualifiedName(module, mailerRelativePath);
    }

    @Override
    @NotNull
    public List<String> getViewsFolderUrls() {
        String relativePath = NamingConventions.toUnderscoreCase((String)this.myClass.getFQNWithNesting().getFullPath(), (Module)this.myModule);
        if (relativePath.isBlank()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                RailsMailer.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<String> list = RailsPaths.getInstance(this.myModule).getUrls("app/views", relativePath);
        if (list == null) {
            RailsMailer.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static boolean isMailerClass(@NotNull RClass clazz) {
        String name;
        if (clazz == null) {
            RailsMailer.$$$reportNull$$$0(7);
        }
        if ((name = clazz.getName()) == null || !name.endsWith("Mailer")) {
            return false;
        }
        Symbol symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)clazz, null);
        if (symbol == null) {
            return false;
        }
        return SymbolHierarchy.isInheritor(symbol, RailsFqns.ACTION_MAILER_BASE, null);
    }

    @NotNull
    public List<VirtualFile> getTemplatesFolders() {
        List<VirtualFile> list = RailsPaths.getInstance(this.myModule).findFiles("app/views", NamingConventions.toUnderscoreCase((String)this.getFqnWithNesting().getFullPath(), (Module)this.myModule));
        if (list == null) {
            RailsMailer.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Override
    @NotNull
    public List<String> getLayoutsFolderUrls() {
        String path;
        FQN parentFqn = this.myClass.getFQNWithNesting().getCallerFQN();
        String string = path = parentFqn != FQN.INVALID ? NamingConventions.toUnderscoreCase((String)parentFqn.getFullPath(), (Module)this.myModule) : null;
        if (StringUtil.isEmpty(path)) {
            List<String> list = RailsPaths.getInstance(this.myModule).getUrls("app/views", "layouts");
            if (list == null) {
                RailsMailer.$$$reportNull$$$0(9);
            }
            return list;
        }
        List<String> list = RailsPaths.getInstance(this.myModule).getUrls("app/views", "layouts", path);
        if (list == null) {
            RailsMailer.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.getFile().getNameWithoutExtension();
        if (string == null) {
            RailsMailer.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    private FQN getFqnWithNesting() {
        FQN fQN = this.getRClass().getFQNWithNesting();
        if (fQN == null) {
            RailsMailer.$$$reportNull$$$0(12);
        }
        return fQN;
    }

    public static boolean isActionMailerClass(@Nullable Symbol symbol) {
        return symbol != null && SymbolHierarchy.isInheritor(symbol, RailsFqns.ACTION_MAILER_BASE, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 6, 8, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/model/RailsMailer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullQualifiedName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/model/RailsMailer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewsFolderUrls";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplatesFolders";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayoutsFolderUrls";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFqnWithNesting";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fromQualifiedName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isMailerClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 6, 8, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

