/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.model.RailsController;
import org.jetbrains.plugins.ruby.rails.model.RailsFileItem;
import org.jetbrains.plugins.ruby.rails.model.RailsMailer;
import org.jetbrains.plugins.ruby.rails.model.RailsViewOwner;
import org.jetbrains.plugins.ruby.rails.nameConventions.HelpersConventions;
import org.jetbrains.plugins.ruby.rails.rspec.model.RailsRSpecHelperTest;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public final class RailsHelper
extends RailsFileItem {
    private String myFullQualifiedName;
    private final RModule myRModule;

    private RailsHelper(Module module, @NotNull RModule rModule) {
        if (rModule == null) {
            RailsHelper.$$$reportNull$$$0(0);
        }
        super(Objects.requireNonNull(RubyPsiUtil.getVirtualFileFromElement((PsiElement)rModule)), module);
        this.myRModule = rModule;
    }

    @Nullable
    public static RailsHelper fromModule(RModule rModule) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)rModule);
        if (module == null || !RailsFacetUtil.hasRailsSupport(module)) {
            return null;
        }
        if (!HelpersConventions.isHelperModule(module, rModule)) {
            return null;
        }
        return new RailsHelper(module, rModule);
    }

    @Nullable
    public static RailsHelper fromFile(PsiFile file) {
        VirtualFile vFile = file.getVirtualFile();
        return vFile == null ? null : RailsHelper.fromFile(ModuleUtilCore.findModuleForPsiElement((PsiElement)file), vFile);
    }

    @Nullable
    public static RailsHelper fromFile(Module module, VirtualFile file) {
        RailsApp app = RailsApp.fromModule(module);
        if (app == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(file);
        if (!(psiFile instanceof RFile)) {
            return null;
        }
        RFile psiFile2 = (RFile)psiFile;
        if (!VfsUtilCore.isUnderFiles((VirtualFile)file, app.getPaths().findFiles("app/helpers"))) {
            return null;
        }
        ArrayList<RModule> containers = new ArrayList<RModule>(RContainerUtil.getTopLevelModules((RContainer)psiFile2));
        if (app.isEngine()) {
            containers.addAll(ContainerUtil.flatMap(containers, RContainerUtil::getTopLevelModules));
        }
        for (RModule container : containers) {
            FQN fqn = container.getFQN();
            if (fqn == FQN.INVALID || !fqn.getShortName().endsWith("Helper")) continue;
            return new RailsHelper(module, container);
        }
        return null;
    }

    @Nullable
    public static RailsHelper fromQualifiedName(Module module, String qualifiedName) {
        RailsApp app = RailsApp.fromModule(module);
        if (app == null) {
            return null;
        }
        return app.findHelper(qualifiedName);
    }

    @NotNull
    public RModule getRModule() {
        RModule rModule = this.myRModule;
        if (rModule == null) {
            RailsHelper.$$$reportNull$$$0(1);
        }
        return rModule;
    }

    @Override
    public String getName() {
        String shortName = HelpersConventions.getHelperNameByFileName(this.getFile().getName());
        assert (shortName != null);
        return shortName;
    }

    public String getModuleName() {
        return NamingConventions.toCamelCase((String)this.getQualifiedName(), (Module)ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myRModule)) + "Helper";
    }

    public String getQualifiedName() {
        if (this.myFullQualifiedName == null) {
            this.myFullQualifiedName = this.determineQualifiedName();
        }
        return this.myFullQualifiedName;
    }

    public RFile getPsiFile() {
        PsiFile file = super.getPsiFile();
        return file instanceof RFile ? (RFile)file : null;
    }

    private String determineQualifiedName() {
        return HelpersConventions.getHelperNameByModuleName(this.myRModule.getFQNWithNesting().getFullPath(), this.myModule);
    }

    @Nullable
    public RailsRSpecHelperTest getSpecTest() {
        return RailsRSpecHelperTest.fromHelper(this);
    }

    @Nullable
    public RailsController getController() {
        return RailsController.fromQualifiedName(this.myModule, this.getQualifiedName());
    }

    @Nullable
    public RailsMailer getMailer() {
        return RailsMailer.fromQualifiedName(this.myModule, this.getQualifiedName());
    }

    @Nullable
    public RailsViewOwner getViewOwner() {
        return (RailsViewOwner)ObjectUtils.coalesce((Object)this.getController(), (Object)this.getMailer());
    }

    @Nullable
    public RClass getUnitTest() {
        RailsApp app = this.getApp();
        return this.getTestClass(app.getUTestsHelpersRoot(), app.getPaths().findFiles("app/helpers"), this.getFile().getNameWithoutExtension(), this.getModuleName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rModule";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/model/RailsHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/model/RailsHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

