/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.model.RailsController;
import org.jetbrains.plugins.ruby.rails.model.RailsView;
import org.jetbrains.plugins.ruby.rails.nameConventions.ControllersConventions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;

public final class RailsExternalController
extends RailsController {
    @Override
    @NotNull
    public List<? extends RailsView> getAllViews() {
        List<? extends RailsView> list = super.getAllViews();
        if (list == null) {
            RailsExternalController.$$$reportNull$$$0(0);
        }
        return list;
    }

    private RailsExternalController(@NotNull Module module, @NotNull RClass aClass) {
        if (module == null) {
            RailsExternalController.$$$reportNull$$$0(1);
        }
        if (aClass == null) {
            RailsExternalController.$$$reportNull$$$0(2);
        }
        super(module, aClass);
    }

    @Nullable
    public static RailsController fromExternalClass(@Nullable RClass rClass, @Nullable RailsApp railsApp) {
        if (rClass == null) {
            return null;
        }
        if (railsApp == null) {
            return null;
        }
        if (!RailsExternalController.isControllerClass(railsApp, rClass)) {
            return null;
        }
        return new RailsExternalController(railsApp.getModule(), rClass);
    }

    private static boolean isControllerClass(@NotNull RailsApp app, @NotNull RClass rClass) {
        if (app == null) {
            RailsExternalController.$$$reportNull$$$0(3);
        }
        if (rClass == null) {
            RailsExternalController.$$$reportNull$$$0(4);
        }
        if (ControllersConventions.getControllerNameByClassName(rClass.getName(), app.getModule()) == null) {
            return false;
        }
        for (GemInfo gemInfo : RubyProjectGemSearchService.Companion.getAllGems(app.getModule())) {
            if (!RailsExternalController.checkPathEndsWithQualifiedName(rClass, RailsExternalController.getGemControllersFolders(gemInfo))) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<VirtualFile> getGemControllersFolders(@NotNull GemInfo gemInfo) {
        if (gemInfo == null) {
            RailsExternalController.$$$reportNull$$$0(5);
        }
        List list = ContainerUtil.mapNotNull((Collection)RailsPaths.getDefaultPaths().get("app/controllers"), path -> {
            VirtualFile file = gemInfo.getFile();
            if (file == null) {
                return null;
            }
            return VirtualFileManager.getInstance().findFileByUrl(file.getUrl() + "/" + path);
        });
        if (list == null) {
            RailsExternalController.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/model/RailsExternalController";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllViews";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/model/RailsExternalController";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemControllersFolders";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isControllerClass";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getGemControllersFolders";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

