/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.model.RailsClassItem;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public class RailsChannel
extends RailsClassItem {
    public static final String CHANNEL_SUFFIX = "Channel";
    public static final String CHANNEL_FILE_NAME_SUFFIX = "_channel.rb";
    public static final String CHANNEL_CLIENT_SUFFIX = ".coffee";

    protected RailsChannel(@NotNull Module module, @NotNull RClass aClass) {
        if (module == null) {
            RailsChannel.$$$reportNull$$$0(0);
        }
        if (aClass == null) {
            RailsChannel.$$$reportNull$$$0(1);
        }
        super(module, aClass);
    }

    @NotNull
    public String getName() {
        String result = this.getRClass().getName();
        assert (result != null);
        String string = result;
        if (string == null) {
            RailsChannel.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public static RailsChannel fromClass(@NotNull RClass rClass) {
        if (rClass == null) {
            RailsChannel.$$$reportNull$$$0(3);
        }
        return RailsChannel.fromFile(rClass.getContainingFile());
    }

    @Nullable
    public static RailsChannel fromFile(@NotNull PsiFile psiFile) {
        VirtualFile file;
        if (psiFile == null) {
            RailsChannel.$$$reportNull$$$0(4);
        }
        return (file = psiFile.getVirtualFile()) == null ? null : RailsChannel.fromFile(ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile), file);
    }

    @Nullable
    private static RailsChannel fromFile(@Nullable Module module, @NotNull VirtualFile file) {
        if (file == null) {
            RailsChannel.$$$reportNull$$$0(5);
        }
        if (module == null) {
            return null;
        }
        if (!VfsUtilCore.isUnderFiles((VirtualFile)file, RailsPaths.getInstance(module).findFiles("app/channels"))) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(file);
        if (psiFile instanceof RFile) {
            List<RClass> classes = RContainerUtil.getTopLevelClasses((RContainer)((RFile)psiFile));
            for (RClass rClass : classes) {
                if (!RailsChannel.isActionCableClass(rClass)) continue;
                return new RailsChannel(module, rClass);
            }
        }
        return null;
    }

    @Nullable
    public static RailsChannel fromQualifiedName(Module module, @NotNull String fullQualifiedName) {
        RailsApp app;
        if (fullQualifiedName == null) {
            RailsChannel.$$$reportNull$$$0(6);
        }
        if ((app = RailsApp.fromModule(module)) == null || !RailsFacetUtil.hasRailsSupport(module) || !app.isRails5App()) {
            return null;
        }
        String channelName = NamingConventions.toUnderscoreCase((String)fullQualifiedName, (Module)module);
        for (VirtualFile file : RailsPaths.getInstance(module).findFiles("app/channels", app.appendProjectPrefix(channelName) + ".rb")) {
            RailsChannel channel = RailsChannel.fromFile(module, file);
            if (channel == null) continue;
            return channel;
        }
        return null;
    }

    public PsiFile getClient() {
        PsiManager psiManager = PsiManager.getInstance((Project)this.getProject());
        for (String clientFileUrl : this.getClientFileUrls()) {
            VirtualFile clientFile = VirtualFileManager.getInstance().findFileByUrl(clientFileUrl);
            if (clientFile == null) continue;
            return psiManager.findFile(clientFile);
        }
        return null;
    }

    @NotNull
    public List<String> getClientFileUrls() {
        String className = this.getRClass().getName();
        if (className == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                RailsChannel.$$$reportNull$$$0(7);
            }
            return list;
        }
        String channelName = NamingConventions.toUnderscoreCase((String)StringUtil.trimEnd((String)className, (String)CHANNEL_SUFFIX), (Module)this.myModule);
        List<String> list = this.getApp().getPaths().getUrls("app/assets", "javascripts", "channels", channelName + CHANNEL_CLIENT_SUFFIX);
        if (list == null) {
            RailsChannel.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    protected Project getProject() {
        Project project = this.getRClass().getProject();
        if (project == null) {
            RailsChannel.$$$reportNull$$$0(9);
        }
        return project;
    }

    private static boolean isActionCableClass(@NotNull RClass rClass) {
        String className;
        if (rClass == null) {
            RailsChannel.$$$reportNull$$$0(10);
        }
        return (className = rClass.getName()) != null && className.endsWith(CHANNEL_SUFFIX);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/model/RailsChannel";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullQualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/model/RailsChannel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getClientFileUrls";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fromFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fromQualifiedName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isActionCableClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

