/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.model;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.ImplicitSymbolHierarchy;
import org.jetbrains.plugins.ruby.rails.facet.configuration.BaseRailsFacetConfiguration;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.rails.facet.configuration.StandardRailsPaths;
import org.jetbrains.plugins.ruby.rails.facet.versions.BaseRailsFacet;
import org.jetbrains.plugins.ruby.rails.model.RailsClassItem;
import org.jetbrains.plugins.ruby.rails.model.RailsController;
import org.jetbrains.plugins.ruby.rails.model.RailsFileItem;
import org.jetbrains.plugins.ruby.rails.model.RailsHelper;
import org.jetbrains.plugins.ruby.rails.model.RailsLayout;
import org.jetbrains.plugins.ruby.rails.model.RailsMailer;
import org.jetbrains.plugins.ruby.rails.model.RailsModel;
import org.jetbrains.plugins.ruby.rails.model.RailsView;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.RubyModificationTrackers;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyClassModuleNameIndex;
import org.jetbrains.plugins.ruby.ruby.module.RubyModuleManager;
import org.jetbrains.plugins.ruby.utils.NamingConventions;
import org.jetbrains.plugins.ruby.utils.RubyVirtualFileScanner;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;

public final class RailsApp {
    private final Module myModule;
    private final BaseRailsFacet myFacet;
    private static final Key<CachedValue<Pair<Long, List<RailsHelper>>>> HELPERS_CACHE_KEY = Key.create((String)"RAILS_APP_HELPERS");
    private static final Key<CachedValue<Pair<Long, List<RailsView>>>> VIEWS_CACHE_KEY = Key.create((String)"RAILS_APP_VIEWS");
    private static final Key<CachedValue<Pair<Long, List<RailsLayout>>>> LAYOUTS_CACHE_KEY = Key.create((String)"RAILS_APP_LAYOUTS");
    private static final Key<CachedValue<Pair<Long, List<RailsMailer>>>> MAILERS_CACHE_KEY = Key.create((String)"RAILS_APP_MAILERS");
    private static final Key<CachedValue<Pair<Long, List<RailsController>>>> CONTROLLERS_CACHE_KEY = Key.create((String)"RAILS_APP_CONTROLLERS");
    private static final Key<CachedValue<Pair<Long, List<RailsModel>>>> MODELS_CACHE_KEY = Key.create((String)"RAILS_APP_MODELS");

    private RailsApp(@NotNull Module module, BaseRailsFacet facet) {
        if (module == null) {
            RailsApp.$$$reportNull$$$0(0);
        }
        this.myModule = module;
        this.myFacet = facet;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myModule.getProject();
        if (project == null) {
            RailsApp.$$$reportNull$$$0(1);
        }
        return project;
    }

    @Nullable
    public static RailsApp fromFile(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            RailsApp.$$$reportNull$$$0(2);
        }
        if (file == null) {
            RailsApp.$$$reportNull$$$0(3);
        }
        return RailsApp.fromModule(ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project));
    }

    @Contract(value="null -> null")
    @Nullable
    public static RailsApp fromModule(@Nullable Module module) {
        BaseRailsFacet facet;
        if (module != null && (facet = BaseRailsFacet.getInstance(module)) != null) {
            return new RailsApp(module, facet);
        }
        return null;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            RailsApp.$$$reportNull$$$0(4);
        }
        return module;
    }

    @NotNull
    public RailsPaths getPaths() {
        RailsPaths railsPaths = RailsPaths.getInstance(this.myModule);
        if (railsPaths == null) {
            RailsApp.$$$reportNull$$$0(5);
        }
        return railsPaths;
    }

    @NotNull
    public StandardRailsPaths getStaticPaths() {
        StandardRailsPaths standardRailsPaths = ((BaseRailsFacetConfiguration)this.myFacet.getConfiguration()).getStaticPaths();
        if (standardRailsPaths == null) {
            RailsApp.$$$reportNull$$$0(6);
        }
        return standardRailsPaths;
    }

    public boolean isVendorFile(VirtualFile file) {
        return VfsUtilCore.isUnderFiles((VirtualFile)file, this.getPaths().findFiles("vendor"));
    }

    public boolean isVendorGemFile(PsiFile file) {
        return this.isVendorGemFile(RubyPsiUtil.getVirtualFileFromElement((PsiElement)file));
    }

    public boolean isVendorGemFile(VirtualFile file) {
        return VfsUtilCore.isUnderFiles((VirtualFile)file, this.getPaths().findFiles("vendor"));
    }

    public boolean isEdgeRailsFile(PsiFile file) {
        return this.isEdgeRailsFile(file.getVirtualFile());
    }

    public boolean isEdgeRailsFile(VirtualFile file) {
        return VfsUtilCore.isUnderFiles((VirtualFile)file, RailsPaths.getInstance(this.myModule).findFiles("vendor", "rails"));
    }

    public boolean isTestFile(VirtualFile vFile) {
        return RailsApp.isNotNullAncestor(this.getUTestsRoot(), vFile) || RailsApp.isNotNullAncestor(this.getSpecTestsRoot(), vFile) || RailsApp.isNotNullAncestor(this.getFeaturesRoot(), vFile);
    }

    public boolean isInAppFile(PsiElement element) {
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
        return file != null && VfsUtilCore.isUnderFiles((VirtualFile)file, this.getPaths().findFiles("app"));
    }

    @Nullable
    public static RailsApp fromPsiElement(@NotNull PsiElement element) {
        Module module;
        if (element == null) {
            RailsApp.$$$reportNull$$$0(7);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null) {
            return null;
        }
        return RailsApp.fromModule(module);
    }

    @Nullable
    public RailsHelper findHelper(String helperFullQualifiedName) {
        for (VirtualFile candidate : this.getPaths().findFiles("app/helpers", this.appendProjectPrefix(helperFullQualifiedName) + "_helper.rb")) {
            RailsHelper helper = RailsHelper.fromFile(this.myModule, candidate);
            if (helper == null) continue;
            return helper;
        }
        return null;
    }

    public boolean processModels(@NotNull Processor<? super RailsModel> processor) {
        if (processor == null) {
            RailsApp.$$$reportNull$$$0(8);
        }
        for (VirtualFile root : this.getPaths().findFiles("app/models")) {
            boolean stop = !VfsUtilCore.processFilesRecursively((VirtualFile)root, file -> {
                RailsModel railsModel;
                ProgressManager.checkCanceled();
                return file.isDirectory() || !RubyVirtualFileScanner.isRubyFile(file) || (railsModel = RailsModel.fromFile(this.getModule(), file)) == null || processor.process((Object)railsModel);
            });
            if (!stop) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public Pair<Long, List<RailsModel>> getAllModels() {
        Project project = this.getProject();
        if (DumbService.isDumb((Project)project)) {
            Pair pair = (Pair)new MyFromClassProvider<RailsModel>(project, RailsModel::fromClass).compute().getValue();
            if (pair == null) {
                RailsApp.$$$reportNull$$$0(9);
            }
            return pair;
        }
        Pair pair = (Pair)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)this.myModule, MODELS_CACHE_KEY, new MyFromClassProvider<RailsModel>(project, RailsModel::fromClass), false);
        if (pair == null) {
            RailsApp.$$$reportNull$$$0(10);
        }
        return pair;
    }

    @NotNull
    public Pair<Long, List<RailsController>> getAllControllers() {
        Project project = this.getProject();
        Function<RClass, RailsController> controllerFactory = rClass -> RailsController.fromClass(rClass, this);
        if (DumbService.isDumb((Project)project)) {
            Pair pair = (Pair)new MyFromClassProvider<RailsController>(project, controllerFactory).compute().getValue();
            if (pair == null) {
                RailsApp.$$$reportNull$$$0(11);
            }
            return pair;
        }
        Pair pair = (Pair)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)this.myModule, CONTROLLERS_CACHE_KEY, new MyFromClassProvider<RailsController>(project, controllerFactory), false);
        if (pair == null) {
            RailsApp.$$$reportNull$$$0(12);
        }
        return pair;
    }

    @NotNull
    public Pair<Long, List<RailsMailer>> getAllMailers() {
        Project project = this.getProject();
        if (DumbService.isDumb((Project)project)) {
            Pair pair = (Pair)new MyFromClassProvider<RailsMailer>(project, RailsMailer::fromClass).compute().getValue();
            if (pair == null) {
                RailsApp.$$$reportNull$$$0(13);
            }
            return pair;
        }
        Pair pair = (Pair)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)this.myModule, MAILERS_CACHE_KEY, new MyFromClassProvider<RailsMailer>(project, RailsMailer::fromClass), false);
        if (pair == null) {
            RailsApp.$$$reportNull$$$0(14);
        }
        return pair;
    }

    @NotNull
    public Pair<Long, List<RailsHelper>> getAllHelpers() {
        Project project = this.getProject();
        Pair pair = (Pair)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)this.myModule, HELPERS_CACHE_KEY, new MyFromFileProvider<RailsHelper>(project, this, new String[]{"app/helpers"}, file -> RailsHelper.fromFile(this.myModule, file)), false);
        if (pair == null) {
            RailsApp.$$$reportNull$$$0(15);
        }
        return pair;
    }

    @NotNull
    public Pair<Long, List<RailsView>> getAllViews() {
        Project project = this.getProject();
        Pair pair = (Pair)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)this.myModule, VIEWS_CACHE_KEY, new MyFromFileProvider<RailsView>(project, this, new String[]{"app/views"}, file -> RailsView.fromFile(file, this.myModule)), false);
        if (pair == null) {
            RailsApp.$$$reportNull$$$0(16);
        }
        return pair;
    }

    @NotNull
    public Pair<Long, List<RailsLayout>> getAllLayouts() {
        Project project = this.getProject();
        Pair pair = (Pair)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)this.myModule, LAYOUTS_CACHE_KEY, new MyFromFileProvider<RailsLayout>(project, this, new String[]{"app/views", "layouts"}, file -> RailsLayout.fromFile(file, this.myModule)), false);
        if (pair == null) {
            RailsApp.$$$reportNull$$$0(17);
        }
        return pair;
    }

    @Nullable
    public RailsModel findModelByName(@Nullable String qualifiedModelName) {
        return RailsModel.fromModelName(this.myModule, qualifiedModelName);
    }

    @Nullable
    public RailsHelper getApplicationHelper() {
        return this.findHelper("application");
    }

    @NotNull
    public RoutesFiles<VirtualFile> getRoutesFiles() {
        Project project = this.getProject();
        RoutesFiles routesFiles = (RoutesFiles)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)this.myModule, () -> {
            ArrayList dependencies = new ArrayList(RubyModificationTrackers.getRailsSettingsModificationTrackers(project, this.myModule));
            dependencies.add(ProjectRootModificationTracker.getInstance((Project)project));
            dependencies.add(VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS);
            return CachedValueProvider.Result.create(this.computeRoutesFiles(), dependencies);
        });
        if (routesFiles == null) {
            RailsApp.$$$reportNull$$$0(18);
        }
        return routesFiles;
    }

    @Nullable
    public RailsController getApplicationController() {
        return this.findController("application");
    }

    @Nullable
    public VirtualFile getApplicationFile() {
        PsiFile[] files;
        VirtualFile appRoot;
        for (String string : this.getApplicationFileUrls()) {
            VirtualFile applicationRb = VirtualFileManager.getInstance().findFileByUrl(string);
            if (applicationRb == null) continue;
            return applicationRb;
        }
        boolean found = false;
        Iterator<VirtualFile> iterator = this.getPaths().findFiles("app").iterator();
        while (iterator.hasNext() && !(found = GemUtil.findGemspecFile((appRoot = iterator.next()).getParent()) != null)) {
        }
        if (!found) {
            return null;
        }
        List<VirtualFile> list = this.getPaths().findFiles("lib");
        if (!list.isEmpty() && (files = FilenameIndex.getFilesByName((Project)this.getProject(), (String)"engine.rb", (GlobalSearchScope)GlobalSearchScopesCore.directoriesScope((Project)this.getProject(), (boolean)true, (VirtualFile[])list.toArray(VirtualFile.EMPTY_ARRAY)))).length > 0) {
            return files[0].getVirtualFile();
        }
        return null;
    }

    @NotNull
    public List<String> getApplicationFileUrls() {
        List<String> list = this.getPaths().getUrls("config", "application.rb");
        if (list == null) {
            RailsApp.$$$reportNull$$$0(19);
        }
        return list;
    }

    @Nullable
    public String getProjectName() {
        BaseRailsFacet facet = BaseRailsFacet.getInstance(this.myModule);
        return facet != null ? facet.getProjectName() : null;
    }

    @NotNull
    public String getProjectPrefix() {
        return this.isEngine() ? NamingConventions.toUnderscoreCase((String)this.getProjectName()) + "/" : "";
    }

    public String appendProjectPrefix(String qualifiedName) {
        String prefix = this.getProjectPrefix();
        return qualifiedName.startsWith(prefix) ? qualifiedName : prefix + qualifiedName;
    }

    @Nullable
    public RailsController findController(String qualifiedName) {
        return RailsController.fromQualifiedName(this.myModule, qualifiedName);
    }

    @NotNull
    public List<? extends VirtualFile> getFixtureFileRoots() {
        List list = ContainerUtil.mapNotNull(this.getStaticPaths().getFixtureFileRootUrls(), RailsApp::findFile);
        if (list == null) {
            RailsApp.$$$reportNull$$$0(20);
        }
        return list;
    }

    @Nullable
    public VirtualFile getRailsApplicationRoot() {
        return RailsApp.findFile(this.getStaticPaths().getRailsApplicationHomeURL());
    }

    @Nullable
    public VirtualFile getUTestsRoot() {
        return RailsApp.findFile(this.getStaticPaths().getTestsStdUnitRootURL());
    }

    @Nullable
    public VirtualFile getUTestsHelpersRoot() {
        return RailsApp.findUnderRoot("helpers", this.findUnderUTestsRoot("unit"));
    }

    @Nullable
    public VirtualFile getSpecTestsRoot() {
        return RailsApp.findFile(this.getStaticPaths().getTestsSpecRootURL());
    }

    @Nullable
    public VirtualFile getFeaturesRoot() {
        return RailsApp.findUnderRoot("features", this.getRailsApplicationRoot());
    }

    @NotNull
    public String getLogsPath() {
        String url = VirtualFileUtil.buildUrl(this.getStaticPaths().getRailsApplicationHomeURL(), "log");
        String string = VfsUtilCore.urlToPath((String)url);
        if (string == null) {
            RailsApp.$$$reportNull$$$0(21);
        }
        return string;
    }

    @Nullable
    public VirtualFile getFunctionalTestsRoot() {
        return this.findUnderUTestsRoot("functional");
    }

    @Nullable
    public VirtualFile getUnitTestsRoot() {
        return this.findUnderUTestsRoot("unit");
    }

    @Nullable
    public VirtualFile getSpecTestsModelsRoot() {
        return this.findUnderSpecTestRoot("models");
    }

    @Nullable
    public VirtualFile getSpecTestsViewsRoot() {
        return this.findUnderSpecTestRoot("views");
    }

    @Nullable
    public VirtualFile getSpecTestsRoutingRoot() {
        return this.findUnderSpecTestRoot("routing");
    }

    @Nullable
    public VirtualFile getSpecTestsRequestsRoot() {
        return this.findUnderSpecTestRoot("requests");
    }

    @Nullable
    public VirtualFile getSpecTestsHelpersRoot() {
        return this.findUnderSpecTestRoot("helpers");
    }

    @Nullable
    public VirtualFile getSpecTestsControllersRoot() {
        return this.findUnderSpecTestRoot("controllers");
    }

    @Nullable
    public VirtualFile getIntegrationTestRoot() {
        return this.findUnderUTestsRoot("integration");
    }

    @Nullable
    private VirtualFile findUnderUTestsRoot(String path) {
        return RailsApp.findUnderRoot(path, this.getUTestsRoot());
    }

    @Nullable
    private VirtualFile findUnderSpecTestRoot(String path) {
        return RailsApp.findUnderRoot(path, this.getSpecTestsRoot());
    }

    @Nullable
    private static VirtualFile findFile(String url) {
        return VirtualFileManager.getInstance().findFileByUrl(url);
    }

    @Nullable
    private static VirtualFile findUnderRoot(String path, VirtualFile root) {
        if (root != null) {
            return root.findChild(path);
        }
        return null;
    }

    private static boolean isNotNullAncestor(@Nullable VirtualFile ancestor, @NotNull VirtualFile file) {
        if (file == null) {
            RailsApp.$$$reportNull$$$0(22);
        }
        return ancestor != null && VfsUtilCore.isAncestor((VirtualFile)ancestor, (VirtualFile)file, (boolean)true);
    }

    public static boolean isRails5App(Module module) {
        GemInfo gem = module != null ? RubyProjectGemSearchService.Companion.findGem(module, "rails") : null;
        return gem != null && RailsUtil.isRails5OrHigher(gem.getNullableVersion());
    }

    public boolean isRails5App() {
        return RailsApp.isRails5App(this.myModule);
    }

    public boolean isEngine() {
        VirtualFile file = this.getApplicationFile();
        return file != null && !"application.rb".equals(file.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RailsApp app = (RailsApp)o;
        return Objects.equals(this.myModule, app.myModule) && Objects.equals((Object)this.myFacet, (Object)app.myFacet);
    }

    public int hashCode() {
        return 31 * this.myModule.hashCode() + this.myFacet.hashCode();
    }

    @NotNull
    public ImplicitSymbolHierarchy getImplicitSymbolHierarchy() {
        ImplicitSymbolHierarchy implicitSymbolHierarchy = this.myFacet.getImplicitSymbolHierarchy();
        if (implicitSymbolHierarchy == null) {
            RailsApp.$$$reportNull$$$0(23);
        }
        return implicitSymbolHierarchy;
    }

    @NotNull
    private RoutesFiles<VirtualFile> computeRoutesFiles() {
        ArrayList<VirtualFile> mainRoutesFiles = new ArrayList<VirtualFile>();
        ArrayList additionalRoutesFiles = new ArrayList();
        mainRoutesFiles.addAll(this.getPaths().findFiles("config/routes.rb"));
        for (VirtualFile additionalRoutesDir : this.getPaths().findFiles("config/routes")) {
            additionalRoutesFiles.addAll(ContainerUtil.filter((Object[])additionalRoutesDir.getChildren(), file -> "rb".equals(file.getExtension())));
        }
        List<String> configRouteFilePaths = RailsPaths.getDefaultPaths().get("config/routes.rb");
        List<String> configRoutePaths = RailsPaths.getDefaultPaths().get("config/routes");
        for (OrderEntry entry : ModuleRootManager.getInstance((Module)this.myModule).getOrderEntries()) {
            for (VirtualFile root : entry.getFiles(OrderRootType.SOURCES)) {
                if (!root.isDirectory()) continue;
                for (String path : configRouteFilePaths) {
                    if (!root.getName().equalsIgnoreCase((String)ObjectUtils.coalesce((Object)StringUtil.substringBefore((String)path, (String)"/"), (Object)path))) continue;
                    ContainerUtil.addIfNotNull(mainRoutesFiles, (Object)root.getParent().findFileByRelativePath(path));
                }
                for (String path : configRoutePaths) {
                    VirtualFile dir;
                    if (!root.getName().equalsIgnoreCase((String)ObjectUtils.coalesce((Object)StringUtil.substringBefore((String)path, (String)"/"), (Object)path)) || (dir = root.getParent().findFileByRelativePath(path)) == null) continue;
                    additionalRoutesFiles.addAll(ContainerUtil.filter((Object[])dir.getChildren(), it -> "rb".equals(it.getExtension())));
                }
            }
        }
        return new RoutesFiles<VirtualFile>(mainRoutesFiles, additionalRoutesFiles);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5, 6, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/model/RailsApp";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/model/RailsApp";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPaths";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStaticPaths";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllModels";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllControllers";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMailers";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllHelpers";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllViews";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLayouts";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoutesFiles";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationFileUrls";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixtureFileRoots";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogsPath";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitSymbolHierarchy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fromPsiElement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processModels";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isNotNullAncestor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5, 6, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 23 -> new IllegalStateException(string);
        };
    }

    private static final class MyFromClassProvider<T extends RailsClassItem>
    extends RubyTimestampedCachedValueProvider<Pair<Long, List<T>>> {
        @NotNull
        private final @NotNull Function<@NotNull RClass, @Nullable T> myRailsClassItemFactory;

        private MyFromClassProvider(@NotNull Project project, @NotNull @NotNull Function<@NotNull RClass, @Nullable T> railsClassItemFactory) {
            if (project == null) {
                MyFromClassProvider.$$$reportNull$$$0(0);
            }
            if (railsClassItemFactory == null) {
                MyFromClassProvider.$$$reportNull$$$0(1);
            }
            super(project);
            this.myRailsClassItemFactory = railsClassItemFactory;
        }

        @NotNull
        public CachedValueProvider.Result<Pair<Long, List<T>>> compute() {
            ArrayList items = new ArrayList();
            long cacheKey = this.getCacheKey();
            RubyClassModuleNameIndex index = RubyClassModuleNameIndex.getInstance();
            ReadAction.nonBlocking(() -> {
                DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> index.processAllElements(this.myProject, (SearchScope)GlobalSearchScope.allScope((Project)this.myProject), psiElement -> {
                    RClass rClass;
                    RailsClassItem item;
                    if (psiElement instanceof RClass && (item = (RailsClassItem)this.myRailsClassItemFactory.apply(rClass = (RClass)psiElement)) != null) {
                        items.add(item);
                    }
                    return true;
                }));
                return null;
            }).executeSynchronously();
            CachedValueProvider.Result result = CachedValueProvider.Result.create((Object)Pair.create((Object)cacheKey, items), (Collection)this.myModificationTrackers);
            if (result == null) {
                MyFromClassProvider.$$$reportNull$$$0(2);
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "railsClassItemFactory";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/model/RailsApp$MyFromClassProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/model/RailsApp$MyFromClassProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "compute";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static final class MyFromFileProvider<T extends RailsFileItem>
    extends RubyTimestampedCachedValueProvider<Pair<Long, List<T>>> {
        @NotNull
        private final RailsApp myApp;
        @NotNull
        private final @NotNull String @NotNull [] myPaths;
        @NotNull
        private final @NotNull Function<@NotNull VirtualFile, @Nullable T> myRailsFileItemFactory;

        private MyFromFileProvider(@NotNull Project project, @NotNull RailsApp app, @NotNull @NotNull String @NotNull [] paths, @NotNull @NotNull Function<@NotNull VirtualFile, @Nullable T> railsFileItemFactory) {
            if (project == null) {
                MyFromFileProvider.$$$reportNull$$$0(0);
            }
            if (app == null) {
                MyFromFileProvider.$$$reportNull$$$0(1);
            }
            if (railsFileItemFactory == null) {
                MyFromFileProvider.$$$reportNull$$$0(2);
            }
            if (paths == null) {
                MyFromFileProvider.$$$reportNull$$$0(3);
            }
            super(project);
            this.myApp = app;
            this.myPaths = paths;
            this.myRailsFileItemFactory = railsFileItemFactory;
            if (this.myPaths.length == 0) {
                throw new IllegalArgumentException("Paths must not be empty");
            }
        }

        @NotNull
        public CachedValueProvider.Result<Pair<Long, List<T>>> compute() {
            ArrayList results = new ArrayList();
            long timestamp = this.getCacheKey();
            List<VirtualFile> roots = this.myApp.getPaths().findFiles(this.myPaths[0], Arrays.copyOfRange(this.myPaths, 1, this.myPaths.length));
            roots.forEach(root -> VfsUtilCore.processFilesRecursively((VirtualFile)root, file -> {
                RailsFileItem item = (RailsFileItem)this.myRailsFileItemFactory.apply((VirtualFile)file);
                if (item != null) {
                    results.add(item);
                }
                return true;
            }));
            CachedValueProvider.Result result = CachedValueProvider.Result.create((Object)Pair.create((Object)timestamp, results), (Collection)this.myModificationTrackers);
            if (result == null) {
                MyFromFileProvider.$$$reportNull$$$0(4);
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "app";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "railsFileItemFactory";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "paths";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/model/RailsApp$MyFromFileProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/model/RailsApp$MyFromFileProvider";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "compute";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    public static final class RoutesFiles<T> {
        private static final RoutesFiles<?> EMPTY = new RoutesFiles(Collections.emptyList(), Collections.emptyList());
        private final Collection<T> myMainRoutesFiles;
        private final Collection<T> myAdditionalRoutesFiles;

        private RoutesFiles(@NotNull Collection<T> mainRoutesFiles, @NotNull Collection<T> additionalRoutesFiles) {
            if (mainRoutesFiles == null) {
                RoutesFiles.$$$reportNull$$$0(0);
            }
            if (additionalRoutesFiles == null) {
                RoutesFiles.$$$reportNull$$$0(1);
            }
            this.myMainRoutesFiles = mainRoutesFiles;
            this.myAdditionalRoutesFiles = additionalRoutesFiles;
        }

        @NotNull
        public Collection<T> getMainRoutesFiles() {
            Collection<T> collection = this.myMainRoutesFiles;
            if (collection == null) {
                RoutesFiles.$$$reportNull$$$0(2);
            }
            return collection;
        }

        @NotNull
        public Collection<T> getAdditionalRoutesFiles() {
            Collection<T> collection = this.myAdditionalRoutesFiles;
            if (collection == null) {
                RoutesFiles.$$$reportNull$$$0(3);
            }
            return collection;
        }

        @NotNull
        public Stream<T> allFiles() {
            Stream<T> stream = Stream.concat(this.myMainRoutesFiles.stream(), this.myAdditionalRoutesFiles.stream());
            if (stream == null) {
                RoutesFiles.$$$reportNull$$$0(4);
            }
            return stream;
        }

        public boolean contains(@Nullable T file) {
            return this.myMainRoutesFiles.contains(file) || this.myAdditionalRoutesFiles.contains(file);
        }

        public boolean isEmpty() {
            return this == EMPTY;
        }

        @NotNull
        public static <T> RoutesFiles<T> create(@NotNull Collection<T> mainRoutesFiles, @NotNull Collection<T> additionalRoutesFiles) {
            if (mainRoutesFiles == null) {
                RoutesFiles.$$$reportNull$$$0(5);
            }
            if (additionalRoutesFiles == null) {
                RoutesFiles.$$$reportNull$$$0(6);
            }
            return !mainRoutesFiles.isEmpty() ? new RoutesFiles<T>(mainRoutesFiles, additionalRoutesFiles) : RoutesFiles.empty();
        }

        @NotNull
        public static <T> RoutesFiles<T> empty() {
            RoutesFiles<?> routesFiles = EMPTY;
            if (routesFiles == null) {
                RoutesFiles.$$$reportNull$$$0(7);
            }
            return routesFiles;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mainRoutesFiles";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "additionalRoutesFiles";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/model/RailsApp$RoutesFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/model/RailsApp$RoutesFiles";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMainRoutesFiles";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAdditionalRoutesFiles";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "allFiles";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "empty";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 7: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 7 -> new IllegalStateException(string);
            };
        }
    }

    private static abstract class RubyTimestampedCachedValueProvider<T>
    implements CachedValueProvider<T> {
        @NotNull
        protected final Project myProject;
        @NotNull
        protected final Set<ModificationTracker> myModificationTrackers;

        private RubyTimestampedCachedValueProvider(@NotNull Project project) {
            if (project == null) {
                RubyTimestampedCachedValueProvider.$$$reportNull$$$0(0);
            }
            this.myProject = project;
            this.myModificationTrackers = new HashSet<ModificationTracker>(RubyModificationTrackers.getModelModificationTrackers(this.myProject));
        }

        protected long getCacheKey() {
            long projectOpenTimestamp = RubyModuleManager.getInstance(this.myProject).getProjectOpenTimestamp();
            long modificationCount = this.myModificationTrackers.stream().mapToLong(ModificationTracker::getModificationCount).sum();
            int year_bits = 32;
            long mod_mask = 0xFFFFFFFFL;
            return projectOpenTimestamp << 32 | modificationCount & 0xFFFFFFFFL;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/ruby/rails/model/RailsApp$RubyTimestampedCachedValueProvider", "<init>"));
        }
    }
}

