/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.InflectorService;
import org.jetbrains.plugins.ruby.rails.codeInsight.RailsCallTypeProvider;
import org.jetbrains.plugins.ruby.rails.model.ActiveRecordModel;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.attribute.StringValueAttribute;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.summary.Summary;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.attribute.AttributeKey;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyClassResolveUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.methods.RMethodBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyEvalCallType;

public final class ModelsTableMappingUtil {
    private static final List<RubyCallType<List<String>>> TABLE_NAME_CALL_TYPES = List.of(RailsCallTypeProvider.TABLE_NAME_CALL, RailsCallTypeProvider.SET_TABLE_NAME_CALL);
    private static final String TABLE_NAME_PREFIX = "table_name_prefix";
    private static final String TABLE_NAME_SUFFIX = "table_name_suffix";

    private ModelsTableMappingUtil() {
    }

    @Nullable
    static String getExplicitTableName(@NotNull RClass model) {
        String string;
        if (model == null) {
            ModelsTableMappingUtil.$$$reportNull$$$0(0);
        }
        RPossibleCall call = RubyClassResolveUtil.findCall(model, TABLE_NAME_CALL_TYPES::contains);
        if (call == null) {
            return null;
        }
        RubyCallType rubyCallType = call.getCallType();
        if (rubyCallType instanceof RubyEvalCallType) {
            RubyEvalCallType callType = (RubyEvalCallType)rubyCallType;
            string = (String)ContainerUtil.getOnlyItem((Collection)((Collection)call.getData(new RubyCallType[]{callType})));
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    static String getExplicitTableNamePrefix(@NotNull RClass model) {
        if (model == null) {
            ModelsTableMappingUtil.$$$reportNull$$$0(1);
        }
        return ModelsTableMappingUtil.getExplicitTableNamePrefixOrSuffix(model, TABLE_NAME_PREFIX, RailsCallTypeProvider.TABLE_NAME_PREFIX_CALL);
    }

    @Nullable
    static String getExplicitTableNameSuffix(@NotNull RClass model) {
        if (model == null) {
            ModelsTableMappingUtil.$$$reportNull$$$0(2);
        }
        return ModelsTableMappingUtil.getExplicitTableNamePrefixOrSuffix(model, TABLE_NAME_SUFFIX, RailsCallTypeProvider.TABLE_NAME_SUFFIX_CALL);
    }

    @Nullable
    static String getImplicitTableName(@NotNull FQN modelFqn, @NotNull Module module) {
        if (modelFqn == null) {
            ModelsTableMappingUtil.$$$reportNull$$$0(3);
        }
        if (module == null) {
            ModelsTableMappingUtil.$$$reportNull$$$0(4);
        }
        return Optional.ofNullable(InflectorService.getInstance(module)).filter(service -> service.isInflectorAvailable()).map(service -> service.tableize(modelFqn.getFullPath())).map(name -> name.replace('/', '_')).orElse(null);
    }

    @Nullable
    static String getImplicitTableNameContained(@NotNull RClass model) {
        Module module;
        if (model == null) {
            ModelsTableMappingUtil.$$$reportNull$$$0(5);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)model)) == null) {
            return null;
        }
        List names = model.getFQNWithNesting().asList();
        if (names.size() <= 1) {
            return "";
        }
        FQN fqn = FQN.of((String)String.join((CharSequence)"::", names.subList(0, names.size() - 1)));
        ActiveRecordModel containedModel = ActiveRecordModel.fromModelName(module, fqn.getFullPath());
        if (containedModel == null) {
            return "";
        }
        return (String)ObjectUtils.doIfNotNull((Object)containedModel.getTableName(), it -> InflectorService.getInstance(module).singularize((String)it) + "_");
    }

    static boolean isAbstract(@NotNull RClass model) {
        FQN fqn;
        if (model == null) {
            ModelsTableMappingUtil.$$$reportNull$$$0(6);
        }
        if (FQN.same((FQN)(fqn = model.getFQNWithNesting()), (String)"ActiveRecord::Base") || FQN.same((FQN)fqn, (String)"ApplicationRecord")) {
            return true;
        }
        RPossibleCall call = RubyClassResolveUtil.findCall(model, arg_0 -> RailsCallTypeProvider.ABSTRACT_CLASS_CALL.equals(arg_0));
        return call != null && "true".equals(ContainerUtil.getOnlyItem((Collection)((Collection)call.getData(new RubyCallType[]{RailsCallTypeProvider.ABSTRACT_CLASS_CALL}))));
    }

    @Nullable
    private static String findMethodAndEvaluateReturnValue(@NotNull Project project, @NotNull FQN fqn, @NotNull String method, @Nullable PsiElement invocationPoint) {
        Symbol symbol;
        if (project == null) {
            ModelsTableMappingUtil.$$$reportNull$$$0(7);
        }
        if (fqn == null) {
            ModelsTableMappingUtil.$$$reportNull$$$0(8);
        }
        if (method == null) {
            ModelsTableMappingUtil.$$$reportNull$$$0(9);
        }
        if ((symbol = SymbolUtil.findConstantByFQN(project, Types.MODULE_OR_CLASS, fqn, invocationPoint)) == null) {
            return null;
        }
        Symbol methodSymbol = (Symbol)ObjectUtils.doIfNotNull((Object)symbol.getSingletonClassSymbol(), it -> SymbolUtil.lookupMethod(it, FQN.of((String)method), Type.CLASS_METHOD.asSet(), invocationPoint));
        if (methodSymbol == null) {
            if (ActiveRecordModel.isActiveRecordClass(symbol)) {
                return "";
            }
            return null;
        }
        return Optional.ofNullable((RMethodBase)ObjectUtils.tryCast((Object)methodSymbol.getPsiElement(), RMethodBase.class)).map(RMethodBase::getSummary).map(Summary::getReturnValue).map(expression -> (String)expression.getAttributeValue((AttributeKey)StringValueAttribute.INSTANCE)).orElse(null);
    }

    @Nullable
    private static String getExplicitTableNamePrefixOrSuffix(@NotNull RClass model, @NotNull String getterMethodName, @NotNull RubyCallType<? extends List<String>> setterCallType) {
        if (model == null) {
            ModelsTableMappingUtil.$$$reportNull$$$0(10);
        }
        if (getterMethodName == null) {
            ModelsTableMappingUtil.$$$reportNull$$$0(11);
        }
        if (setterCallType == null) {
            ModelsTableMappingUtil.$$$reportNull$$$0(12);
        }
        Project project = model.getProject();
        List names = model.getFQNWithNesting().asList();
        if (names.isEmpty()) {
            return "";
        }
        for (int i = names.size() - 1; i > 0; --i) {
            FQN fqn = FQN.of((String)String.join((CharSequence)"::", names.subList(0, i)));
            String prefix = ModelsTableMappingUtil.findMethodAndEvaluateReturnValue(project, fqn, getterMethodName, (PsiElement)model);
            if (prefix == null) continue;
            return prefix;
        }
        RPossibleCall call = RContainerUtil.findCall((RContainer)model, arg_0 -> setterCallType.equals(arg_0));
        if (call != null) {
            return (String)ContainerUtil.getOnlyItem((Collection)((Collection)call.getData(new RubyCallType[]{setterCallType})));
        }
        return ModelsTableMappingUtil.findMethodAndEvaluateReturnValue(project, model.getFQNWithNesting(), getterMethodName, (PsiElement)model);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelFqn";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getterMethodName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setterCallType";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/model/ModelsTableMappingUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getExplicitTableName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getExplicitTableNamePrefix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getExplicitTableNameSuffix";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getImplicitTableName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getImplicitTableNameContained";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isAbstract";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "findMethodAndEvaluateReturnValue";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getExplicitTableNamePrefixOrSuffix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

