/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.inspections.paramdefs;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.model.psi.PsiSymbolReferenceService;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.inspections.paramdefs.InspectionResult;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.RubyParamDefInspectableReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.RubyParamDefPsiSymbolReference;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RNumericConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArray;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssocList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBracedExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RField;

public class ParamDefResolveVisitor
extends RubyInspectionVisitor {
    public ParamDefResolveVisitor(@NotNull ProblemsHolder holder) {
        if (holder == null) {
            ParamDefResolveVisitor.$$$reportNull$$$0(0);
        }
        super(holder);
    }

    @Override
    protected void registerProblem(PsiElement element, String message) {
        super.registerProblem(element, message, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new LocalQuickFix[0]);
    }

    public void visitRSymbol(@NotNull RSymbol rSymbol) {
        if (rSymbol == null) {
            ParamDefResolveVisitor.$$$reportNull$$$0(1);
        }
        this.inspectElement((PsiElement)rSymbol);
    }

    public void visitRStringLiteral(@NotNull RStringLiteral rStringLiteral) {
        if (rStringLiteral == null) {
            ParamDefResolveVisitor.$$$reportNull$$$0(2);
        }
        this.inspectElement((PsiElement)rStringLiteral);
    }

    public void visitRDStringLiteral(@NotNull RStringLiteral rDStringLiteral) {
        if (rDStringLiteral == null) {
            ParamDefResolveVisitor.$$$reportNull$$$0(3);
        }
        if (!rDStringLiteral.hasExpressionSubstitutions()) {
            this.inspectElement((PsiElement)rDStringLiteral);
        }
    }

    public void visitRArray(@NotNull RArray array) {
        if (array == null) {
            ParamDefResolveVisitor.$$$reportNull$$$0(4);
        }
        this.inspectElement((PsiElement)array);
    }

    public void visitRAssocList(@NotNull RAssocList assocList) {
        if (assocList == null) {
            ParamDefResolveVisitor.$$$reportNull$$$0(5);
        }
        this.inspectElement((PsiElement)assocList);
    }

    private void inspectElement(PsiElement psiElement) {
        ParamDefReference paramDefReference;
        Collection<? extends RubyParamDefPsiSymbolReference> references = ParamDefResolveVisitor.findParamDefSymbolReferences(psiElement);
        RubyParamDefInspectableReference reference = (RubyParamDefInspectableReference)ObjectUtils.tryCast((Object)ContainerUtil.getOnlyItem(references), RubyParamDefInspectableReference.class);
        if (reference != null) {
            reference.inspectReference(this.myHolder, this.myOnTheFly);
        }
        if ((paramDefReference = ParamDefResolveVisitor.findParamDefReference(psiElement)) == null) {
            return;
        }
        InspectionResult inspectionResult = paramDefReference.inspect();
        InspectionResult.Type resultType = inspectionResult.getType();
        if (resultType != InspectionResult.Type.PROBLEM && resultType != InspectionResult.Type.NOT_APPLICABLE) {
            return;
        }
        LocalQuickFix[] quickFixes = inspectionResult.getQuickFixes();
        PsiElement affectedPsiElement = inspectionResult.getAffectedPsiElement();
        String msg = (String)ObjectUtils.chooseNotNull((Object)inspectionResult.getProblemDescription(), (Object)RBundle.message((String)"inspection.paramdef.unexpected.param.value"));
        if (quickFixes.length == 0) {
            this.registerProblem(affectedPsiElement, msg, (ProblemHighlightType)ObjectUtils.chooseNotNull((Object)inspectionResult.getHighlightingType(), (Object)ProblemHighlightType.GENERIC_ERROR_OR_WARNING), new LocalQuickFix[0]);
        } else {
            this.registerProblem(affectedPsiElement, msg, quickFixes);
        }
    }

    @Nullable
    private static ParamDefReference findParamDefReference(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            ParamDefResolveVisitor.$$$reportNull$$$0(6);
        }
        ProgressManager.checkCanceled();
        return (ParamDefReference)ContainerUtil.findInstance((Object[])(ParamDefResolveVisitor.isCompositeElement(psiElement) ? ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)psiElement) : psiElement.getReferences()), ParamDefReference.class);
    }

    @NotNull
    private static Collection<? extends RubyParamDefPsiSymbolReference> findParamDefSymbolReferences(@NotNull PsiElement element) {
        if (element == null) {
            ParamDefResolveVisitor.$$$reportNull$$$0(7);
        }
        Collection collection = PsiSymbolReferenceService.getService().getReferences(element, RubyParamDefPsiSymbolReference.class);
        if (collection == null) {
            ParamDefResolveVisitor.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @Contract(value="null -> false")
    public static boolean isSimple(@Nullable PsiElement element) {
        return element instanceof RNumericConstant || RubyPsiUtil.isSimpleStringOrSymbol(element);
    }

    @Contract(value="null -> false")
    public static boolean isProbablyAcceptable(@Nullable PsiElement element) {
        return element instanceof RPossibleCall || element instanceof RField || RubyPsiUtil.isStringWithExpressionSubstitutions(element);
    }

    @Contract(value="null -> false")
    public static boolean isCompositeElement(@Nullable PsiElement element) {
        return element instanceof RBracedExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rSymbol";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rStringLiteral";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rDStringLiteral";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assocList";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/inspections/paramdefs/ParamDefResolveVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/inspections/paramdefs/ParamDefResolveVisitor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findParamDefSymbolReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitRSymbol";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitRStringLiteral";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitRDStringLiteral";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitRArray";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitRAssocList";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findParamDefReference";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findParamDefSymbolReferences";
                break;
            }
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

