/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.indexes;

import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.SingleEntryIndexer;
import com.intellij.util.indexing.hints.BinaryFileTypePolicy;
import com.intellij.util.indexing.hints.ExactFileNameInputFilter;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyInterpretUtil;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;

public final class RailsRubySchemaVersionIndex
extends SingleEntryFileBasedIndexExtension<String> {
    public static final ID<Integer, String> KEY = ID.create((String)"rails.ruby.schema.version");

    @NotNull
    public SingleEntryIndexer<String> getIndexer() {
        return new SingleEntryIndexer<String>(this, false){

            @Nullable
            protected String computeValue(@NotNull FileContent inputData) {
                RFile file;
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((file = (RFile)ObjectUtils.tryCast((Object)inputData.getPsiFile(), RFile.class)) == null) {
                    return null;
                }
                RBlockCall defineCall = file.getStructureElements().stream().map(statement -> statement instanceof RBlockCall ? (RBlockCall)statement : (RBlockCall)ObjectUtils.tryCast((Object)statement.getParent(), RBlockCall.class)).filter(Objects::nonNull).filter(blockCall -> RubyPsiUtil.isCallWithCommand((PsiElement)blockCall, "define")).findFirst().orElse(null);
                if (defineCall == null) {
                    return null;
                }
                RPsiElement value = RubyInterpretUtil.getOptionValueElement(defineCall.getCall().getArguments(), "version");
                if (value == null) {
                    return null;
                }
                String version = value.getText().replaceAll("_", "");
                return TextUtil.isInteger((String)version) ? version : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "org/jetbrains/plugins/ruby/rails/indexes/RailsRubySchemaVersionIndex$1", "computeValue"));
            }
        };
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new ExactFileNameInputFilter("schema.rb", false, BinaryFileTypePolicy.NON_BINARY);
    }

    @NotNull
    public ID<Integer, String> getName() {
        ID<Integer, String> iD = KEY;
        if (iD == null) {
            RailsRubySchemaVersionIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataExternalizer<String> getValueExternalizer() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            RailsRubySchemaVersionIndex.$$$reportNull$$$0(1);
        }
        return enumeratorStringDescriptor;
    }

    public int getVersion() {
        return 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/ruby/rails/indexes/RailsRubySchemaVersionIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

