/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.gems;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.bundler.BundleConfig;
import org.jetbrains.plugins.ruby.gem.bundler.BundleConfigServiceImpl;
import org.jetbrains.plugins.ruby.rails.gems.GemsWithSpecsProvider;

public final class LocalBundlerGitGemsProvider
extends GemsWithSpecsProvider {
    @Override
    @NotNull
    protected List<VirtualFile> getGemsDirectories(@NotNull Module module) {
        if (module == null) {
            LocalBundlerGitGemsProvider.$$$reportNull$$$0(0);
        }
        throw new RuntimeException("Should never be invoked");
    }

    @Override
    @Nullable
    protected VirtualFile getGemPathDirectory(Module module) {
        throw new RuntimeException("Should never be invoked");
    }

    @Override
    public boolean isUnderDependenciesRoot(@NotNull VirtualFile virtualFile, @NotNull Module module) {
        if (virtualFile == null) {
            LocalBundlerGitGemsProvider.$$$reportNull$$$0(1);
        }
        if (module == null) {
            LocalBundlerGitGemsProvider.$$$reportNull$$$0(2);
        }
        for (String path : LocalBundlerGitGemsProvider.getLocalGemsPathNamesMap(module).values()) {
            VirtualFile gemsDirectory;
            if (path == null || (gemsDirectory = VfsUtil.findFileByIoFile((File)new File(path), (boolean)false)) == null || !VfsUtilCore.isAncestor((VirtualFile)gemsDirectory, (VirtualFile)virtualFile, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isGitGem(@NotNull VirtualFile gemDirectory) {
        if (gemDirectory == null) {
            LocalBundlerGitGemsProvider.$$$reportNull$$$0(3);
        }
        return true;
    }

    @NotNull
    private static Map<String, String> getLocalGemsPathNamesMap(@NotNull Module module) {
        BundleConfig bundleConfig;
        if (module == null) {
            LocalBundlerGitGemsProvider.$$$reportNull$$$0(4);
        }
        Map<Object, Object> map = (bundleConfig = BundleConfigServiceImpl.getInstance(module.getProject()).getConfig(module)) == null ? Collections.emptyMap() : bundleConfig.getLocalGemsPathNamesMap();
        if (map == null) {
            LocalBundlerGitGemsProvider.$$$reportNull$$$0(5);
        }
        return map;
    }

    @Override
    @NotNull
    public List<GemInfo> getGemsList(@NotNull Module module) {
        Map<String, String> localGemPathNamesMap;
        if (module == null) {
            LocalBundlerGitGemsProvider.$$$reportNull$$$0(6);
        }
        if ((localGemPathNamesMap = LocalBundlerGitGemsProvider.getLocalGemsPathNamesMap(module)).isEmpty()) {
            List<GemInfo> list = Collections.emptyList();
            if (list == null) {
                LocalBundlerGitGemsProvider.$$$reportNull$$$0(7);
            }
            return list;
        }
        HashSet<GemInfo> result = new HashSet<GemInfo>();
        String defaultGemVersion = this.getDefaultGemVersion(module);
        for (Map.Entry<String, String> entry : localGemPathNamesMap.entrySet()) {
            GemInfo gemInfo;
            VirtualFile gemDirectory;
            String gemName = entry.getKey();
            String gemPath = entry.getValue();
            if (StringUtil.isEmpty((String)gemPath) || (gemDirectory = VfsUtil.findFileByIoFile((File)new File(gemPath), (boolean)false)) == null || !gemDirectory.isValid() || (gemInfo = this.createDirectoryGem(gemDirectory, defaultGemVersion)) == null || !StringUtil.equals((CharSequence)gemName, (CharSequence)gemInfo.getName())) continue;
            gemInfo.setLocalGitRepo(true);
            result.add(gemInfo);
        }
        return result.isEmpty() ? Collections.emptyList() : new ArrayList(result);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemDirectory";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/gems/LocalBundlerGitGemsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/gems/LocalBundlerGitGemsProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalGemsPathNamesMap";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemsList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getGemsDirectories";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isUnderDependenciesRoot";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isGitGem";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLocalGemsPathNamesMap";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getGemsList";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7 -> new IllegalStateException(string);
        };
    }
}

