/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.facet.ui.wizard.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ComboBoxCompositeEditor;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.RubyIcons;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.gem.GemCompatibilityUtil;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.facet.ui.wizard.ui.SelectNewRailsVersionDialog;

public class RailsVersionComboBox
extends ComboBox<String> {
    private static final Comparator<String> COMPARATOR = Collections.reverseOrder((o1, o2) -> VersionComparatorUtil.compare((String)o1, (String)o2));
    private final @NotNull ObservableMutableProperty<@Nullable Sdk> mySdkProperty;
    private final @NotNull ObservableMutableProperty<@Nullable String> myMinRailsVersionProperty;
    @NotNull
    private final RailsUtil.AllVersionsGemCache myRailsVersionsCache;
    @NotNull
    private List<String> myInstalledRailsVersion;
    @NotNull
    private final JLabel myNewRailsVersionIcon;

    public RailsVersionComboBox(@NotNull ObservableMutableProperty<@Nullable Sdk> sdkProperty, @NotNull ObservableMutableProperty<@Nullable String> railsVersionProperty, @NotNull ObservableMutableProperty<@Nullable String> minRailsVersionProperty) {
        if (sdkProperty == null) {
            RailsVersionComboBox.$$$reportNull$$$0(0);
        }
        if (railsVersionProperty == null) {
            RailsVersionComboBox.$$$reportNull$$$0(1);
        }
        if (minRailsVersionProperty == null) {
            RailsVersionComboBox.$$$reportNull$$$0(2);
        }
        this.myRailsVersionsCache = new RailsUtil.AllVersionsGemCache();
        this.myInstalledRailsVersion = Collections.emptyList();
        this.myNewRailsVersionIcon = RailsVersionComboBox.createNewRailsVersionIcon();
        this.mySdkProperty = sdkProperty;
        this.myMinRailsVersionProperty = minRailsVersionProperty;
        this.initRailsVersionsModel();
        sdkProperty.afterChange(it -> {
            this.refreshRailsVersionsAfterSdkChanged();
            return null;
        });
        minRailsVersionProperty.afterChange(it -> {
            this.refreshRailsVersionsAfterConstraintsChanged();
            return null;
        });
        JBLabel selectedRailsVersionLabel = new JBLabel();
        selectedRailsVersionLabel.setPreferredSize(new Dimension(0, 0));
        selectedRailsVersionLabel.setBackground(UIUtil.getListBackground());
        selectedRailsVersionLabel.setForeground(UIUtil.getListForeground());
        ComboBoxCompositeEditor editor = new ComboBoxCompositeEditor((JComponent)selectedRailsVersionLabel, new JComponent[]{this.myNewRailsVersionIcon, this.createAddRailsVersionLabel()});
        editor.onSetItem((railsVersion, label) -> {
            if (railsVersion == null) {
                label.setIcon(RubyIcons.Rails.Rails);
                label.setText(RBundle.message((String)"rails.renderer.no.version.chosen"));
                label.setForeground((Color)JBColor.RED);
                return;
            }
            label.setIcon(RubyIcons.Rails.Rails);
            label.setText((String)railsVersion);
            label.setForeground(UIUtil.getListForeground());
        });
        this.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

            public void popupMenuWillBecomeVisible(@NotNull PopupMenuEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                RailsVersionComboBox.this.requestFocusInWindow();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/ruby/rails/facet/ui/wizard/ui/RailsVersionComboBox$1", "popupMenuWillBecomeVisible"));
            }
        });
        this.setEditable(true);
        this.setEditor((ComboBoxEditor)editor);
        this.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label, value, index) -> {
            label.setText(value);
            label.setIcon(RubyIcons.Rails.Rails);
        }));
        ComboboxSpeedSearch.installSpeedSearch((JComboBox)((Object)this), item -> item);
        this.addActionListener(event -> {
            railsVersionProperty.set((Object)((String)this.getItem()));
            this.updateRailsVersionIcon();
        });
        this.addPropertyChangeListener(event -> {
            if (event.getPropertyName().equals("model")) {
                railsVersionProperty.set((Object)((String)this.getItem()));
            }
        });
        if (this.getModel().getSize() != 0) {
            this.setSelectedIndex(0);
        }
    }

    public void initRailsVersionsModel() {
        List<String> newRailsVersions = this.computeRailsVersion((Sdk)this.mySdkProperty.get());
        this.myInstalledRailsVersion = newRailsVersions;
        String newSelectedItem = (String)ContainerUtil.getFirstItem(newRailsVersions);
        this.setModel((ComboBoxModel)RailsVersionComboBox.createModel(newRailsVersions, newSelectedItem));
        this.updateRailsVersionIcon();
    }

    public void refreshRailsVersionsAfterSdkChanged() {
        List<String> newRailsVersions = this.computeRailsVersion((Sdk)this.mySdkProperty.get());
        this.myInstalledRailsVersion = newRailsVersions;
        String newSelectedVersion = (String)this.getSelectedItem();
        if (newSelectedVersion == null) {
            newSelectedVersion = (String)ContainerUtil.getFirstItem(newRailsVersions);
        }
        this.setModel((ComboBoxModel)RailsVersionComboBox.createModel(newRailsVersions, newSelectedVersion));
        this.updateRailsVersionIcon();
    }

    public void refreshRailsVersionsAfterConstraintsChanged() {
        List<String> newRailsVersions = this.computeRailsVersion((Sdk)this.mySdkProperty.get());
        this.myInstalledRailsVersion = newRailsVersions;
        String selectedItem = (String)this.getSelectedItem();
        if (selectedItem == null) {
            this.setModel((ComboBoxModel)RailsVersionComboBox.createModel(newRailsVersions, (String)ContainerUtil.getFirstItem(newRailsVersions)));
            this.updateRailsVersionIcon();
            return;
        }
        if (newRailsVersions.contains(selectedItem) || VersionComparatorUtil.compare((String)selectedItem, (String)((String)this.myMinRailsVersionProperty.get())) >= 0) {
            this.setModel((ComboBoxModel)RailsVersionComboBox.createModel(newRailsVersions, selectedItem));
            this.updateRailsVersionIcon();
            return;
        }
        this.setModel((ComboBoxModel)RailsVersionComboBox.createModel(newRailsVersions, (String)ContainerUtil.getFirstItem(newRailsVersions)));
        this.updateRailsVersionIcon();
    }

    private void updateRailsVersionIcon() {
        String selectedItem = (String)this.getSelectedItem();
        this.myNewRailsVersionIcon.setVisible(!this.myInstalledRailsVersion.contains(selectedItem) && selectedItem != null);
    }

    @NotNull
    private JLabel createAddRailsVersionLabel() {
        JLabel label = new JLabel(AllIcons.General.Add);
        label.setToolTipText(RBundle.message((String)"rails.application.generator.install.rails.gem"));
        label.setCursor(Cursor.getPredefinedCursor(12));
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(@NotNull MouseEvent event) {
                String newInstalledRailsVersion;
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((newInstalledRailsVersion = RailsVersionComboBox.this.selectNewRailsGemVersion()) != null) {
                    RailsVersionComboBox.this.setSelectedItem(newInstalledRailsVersion);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ruby/rails/facet/ui/wizard/ui/RailsVersionComboBox$2", "mouseClicked"));
            }
        });
        JLabel jLabel = label;
        if (jLabel == null) {
            RailsVersionComboBox.$$$reportNull$$$0(3);
        }
        return jLabel;
    }

    @NlsSafe
    @Nullable
    private String selectNewRailsGemVersion() {
        SelectNewRailsVersionDialog dialog;
        GemInfo gemInfo;
        List<String> versions;
        Sdk sdk = (Sdk)this.mySdkProperty.get();
        if (sdk == null) {
            return null;
        }
        if (this.myRailsVersionsCache.getGemInfo() == null || this.myRailsVersionsCache.getGemVersions() == null) {
            Set<GemInfo> gemsInfos = RailsUtil.loadGemsList(null, "rails", sdk);
            if (gemsInfos == null) {
                return null;
            }
            versions = ContainerUtil.map(gemsInfos, info -> info.getVersion());
            gemInfo = gemsInfos.iterator().next();
        } else {
            gemInfo = this.myRailsVersionsCache.getGemInfo();
            versions = this.myRailsVersionsCache.getGemVersions();
        }
        if (this.myRailsVersionsCache.getGemInfo() == null || this.myRailsVersionsCache.getGemVersions() == null) {
            this.myRailsVersionsCache.setGemInfo(gemInfo);
            this.myRailsVersionsCache.setGemVersions(versions);
        }
        List filteredVersions = ContainerUtil.filter(versions, t -> !this.myInstalledRailsVersion.contains(t));
        String maxVersion = GemCompatibilityUtil.getTopCompatibleVersion(sdk, "rails");
        if (maxVersion != null) {
            filteredVersions = ContainerUtil.filter((Collection)filteredVersions, t -> VersionComparatorUtil.compare((String)t, (String)maxVersion) <= 0);
        }
        if (this.myMinRailsVersionProperty.get() != null) {
            filteredVersions = ContainerUtil.filter((Collection)filteredVersions, t -> VersionComparatorUtil.compare((String)t, (String)((String)this.myMinRailsVersionProperty.get())) >= 0);
        }
        if ((dialog = new SelectNewRailsVersionDialog(null, filteredVersions)).showAndGet()) {
            return dialog.getVersion();
        }
        return null;
    }

    private @Unmodifiable @NotNull List<String> computeRailsVersion(@Nullable Sdk sdk) {
        ThrowableComputable throwableComputable = () -> this.getRailsGems(sdk);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            List list = (List)throwableComputable.compute();
            if (list == null) {
                RailsVersionComboBox.$$$reportNull$$$0(4);
            }
            return list;
        }
        List list = (List)ProgressManager.getInstance().runProcessWithProgressSynchronously(throwableComputable, RBundle.message((String)"rails.facet.wizard.tab.rails.project.rails.version.title"), true, null);
        if (list == null) {
            RailsVersionComboBox.$$$reportNull$$$0(5);
        }
        return list;
    }

    private @Unmodifiable @NotNull List<String> getRailsGems(@Nullable Sdk sdk) {
        List<GemInfo> railsGems = GemManager.getInstance().getAllGems(sdk, "rails");
        List<String> railsVersion = railsGems.stream().map(gemInfo -> gemInfo.getVersion()).distinct().sorted(COMPARATOR).collect(Collectors.toList());
        if (this.myMinRailsVersionProperty.get() == null) {
            List<String> list = railsVersion;
            if (list == null) {
                RailsVersionComboBox.$$$reportNull$$$0(6);
            }
            return list;
        }
        List list = ContainerUtil.filter(railsVersion, name -> VersionComparatorUtil.compare((String)name, (String)((String)this.myMinRailsVersionProperty.get())) >= 0);
        if (list == null) {
            RailsVersionComboBox.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    private static CollectionComboBoxModel<String> createModel(@NotNull @Unmodifiable List<String> railsVersions, @Nullable String selectedItem) {
        if (railsVersions == null) {
            RailsVersionComboBox.$$$reportNull$$$0(8);
        }
        return new CollectionComboBoxModel(new ArrayList<String>(railsVersions), (Object)selectedItem);
    }

    @NotNull
    private static JLabel createNewRailsVersionIcon() {
        JLabel label = new JLabel(AllIcons.General.Information);
        label.setBorder((Border)JBUI.Borders.empty((int)0, (int)5));
        label.setToolTipText(RBundle.message((String)"rails.wizard.project.rails.version.tooltip"));
        JLabel jLabel = label;
        if (jLabel == null) {
            RailsVersionComboBox.$$$reportNull$$$0(9);
        }
        return jLabel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkProperty";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "railsVersionProperty";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minRailsVersionProperty";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/facet/ui/wizard/ui/RailsVersionComboBox";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "railsVersions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/facet/ui/wizard/ui/RailsVersionComboBox";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createAddRailsVersionLabel";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRailsVersion";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRailsGems";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewRailsVersionIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 9 -> new IllegalStateException(string);
        };
    }
}

