/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.facet.ui;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.util.ArrayUtilRt;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.MutableComboBoxModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.facet.RailsApplicationSettings;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;

public final class RailsUIUtil {
    private RailsUIUtil() {
    }

    public static void customizeTemplateSelector(ComboboxWithBrowseButton template) {
        template.getComboBox().setEditable(true);
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileDescriptor((FileType)RubyFileType.RUBY).withTitle(RBundle.message((String)"module.rails.generate.app.template.select")).withDescription(RBundle.message((String)"module.rails.generate.app.template.description"));
        template.addBrowseFolderListener(null, descriptor, (TextComponentAccessor)new TextComponentAccessor<JComboBox>(){

            public String getText(JComboBox component) {
                String result = (String)component.getSelectedItem();
                return result != null ? result : "";
            }

            public void setText(JComboBox component, @NotNull String text) {
                if (text == null) {
                    1.$$$reportNull$$$0(0);
                }
                component.setSelectedItem(text);
                RailsUIUtil.updateComboModel(component);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/ruby/rails/facet/ui/RailsUIUtil$1", "setText"));
            }
        });
        final JComboBox combo = template.getComboBox();
        combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RailsUIUtil.updateComboModel(combo);
            }
        });
        RailsUIUtil.setUpTemplatesFromSavedSettings(template);
    }

    private static void setUpTemplatesFromSavedSettings(ComboboxWithBrowseButton template) {
        String[] templates = RailsApplicationSettings.getInstance().wizardRailsFacetTemplates;
        template.getComboBox().setModel(new DefaultComboBoxModel<String>(templates));
        template.getComboBox().setSelectedItem(templates.length > 0 ? templates[0] : "");
    }

    private static void updateComboModel(JComboBox combo) {
        MutableComboBoxModel model = (MutableComboBoxModel)combo.getModel();
        String value = (String)combo.getSelectedItem();
        if (value != null) {
            for (int i = 0; i < model.getSize(); ++i) {
                if (!value.equals(model.getElementAt(i))) continue;
                return;
            }
        }
        if (RailsUIUtil.isValidTemplateItem(value)) {
            model.insertElementAt(value, 0);
        }
    }

    private static boolean isValidTemplateItem(String element) {
        return element != null && !RailsUIUtil.isNotSupportedTemplateString(element);
    }

    public static boolean isNotSupportedTemplateString(String currentText) {
        return Comparing.strEqual((String)RBundle.message((String)"module.rails.generate.app.template.not.supported"), (String)currentText);
    }

    public static void saveTemplateSettings(ComboboxWithBrowseButton template) {
        JComboBox comboBox = template.getComboBox();
        RailsApplicationSettings settings = RailsApplicationSettings.getInstance();
        ComboBoxModel model = comboBox.getModel();
        ArrayList<String> templates = new ArrayList<String>();
        String element = (String)comboBox.getSelectedItem();
        if (RailsUIUtil.isValidTemplateItem(element)) {
            templates.add(element);
        }
        for (int i = 0; i < model.getSize(); ++i) {
            element = (String)model.getElementAt(i);
            if (!RailsUIUtil.isValidTemplateItem(element) || templates.contains(element)) continue;
            templates.add(element);
        }
        settings.wizardRailsFacetTemplates = ArrayUtilRt.toStringArray(templates);
    }
}

