/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.facet.configuration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.gem.bundler.BundlerGemInfrastructure;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;

public abstract class RailsPathsQuery
implements Runnable {
    private static final Logger LOG = Logger.getInstance(RailsPathsQuery.class);
    @Language(value="ruby")
    private static final String SCRIPT = "paths = Rails.configuration.paths; puts paths.keys.each_with_object({}) { |key, hash| hash[key] = paths[key].to_ary }.to_json";
    private final Module myModule;

    public RailsPathsQuery(@NotNull Module module) {
        if (module == null) {
            RailsPathsQuery.$$$reportNull$$$0(0);
        }
        this.myModule = module;
    }

    @Override
    public void run() {
        try {
            String output2 = this.doRun();
            if (output2 == null) {
                return;
            }
            JsonNode root = new ObjectMapper().readTree(output2);
            if (root == null) {
                return;
            }
            String rootUrl = RailsFacetUtil.getRailsAppHomeDirUrl(this.myModule);
            TreeMap urls = new TreeMap();
            root.properties().forEach(field -> {
                String key = (String)field.getKey();
                if (key == null || key.isBlank()) {
                    return;
                }
                ArrayList paths = new ArrayList();
                ((JsonNode)field.getValue()).elements().forEachRemaining(node -> {
                    String text = node.textValue();
                    if (text == null || text.isBlank()) {
                        return;
                    }
                    paths.add(OSAgnosticPathUtil.isAbsolute((String)text) ? VfsUtilCore.pathToUrl((String)text) : FileUtil.toSystemIndependentName((String)FileUtil.join((String[])new String[]{rootUrl, text})));
                });
                urls.put(key, ContainerUtil.sorted(paths));
            });
            ApplicationManager.getApplication().invokeLater(() -> this.onSuccess(urls));
        }
        catch (JsonProcessingException | ExecutionException e) {
            ApplicationManager.getApplication().invokeLater(() -> this.lambda$run$3((Exception)e));
        }
    }

    public abstract void onError(@NotNull Exception var1);

    public abstract void onSuccess(@NotNull Map<String, List<String>> var1);

    @Nullable
    private String doRun() throws ExecutionException {
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(this.myModule);
        if (sdk == null) {
            LOG.warn("Cannot import paths; unable to find a Ruby SDK for %s".formatted(this.myModule));
            return null;
        }
        VirtualFile workingDir = (VirtualFile)ObjectUtils.doIfNotNull((Object)RailsApp.fromModule(this.myModule), RailsApp::getRailsApplicationRoot);
        if (workingDir == null) {
            LOG.warn("Cannot import paths; unable to find the Rails application root for %s".formatted(this.myModule));
            return null;
        }
        ProcessOutput output2 = ((RubyGemExecutionContext)((RubyGemExecutionContext)((RubyGemExecutionContext)((RubyGemExecutionContext)RubyGemExecutionContext.create(sdk, "rails").withModule(this.myModule)).withArguments("runner", SCRIPT)).withWorkingDir(workingDir)).inSameThread(60)).executeScript();
        if (output2 == null || !output2.isExitCodeSet()) {
            return null;
        }
        int code = output2.getExitCode();
        if (code != 0 || output2.isTimeout()) {
            throw new ExecutionException(!output2.getStdout().isBlank() ? output2.getStdout() : output2.getStderr());
        }
        List lines = output2.getStdoutLines();
        if (!lines.isEmpty()) {
            return ((String)lines.get(0)).trim();
        }
        return null;
    }

    public static boolean isAvailable(@NotNull Module module) {
        if (module == null) {
            RailsPathsQuery.$$$reportNull$$$0(1);
        }
        if (!TrustedProjects.isProjectTrusted((Project)module.getProject())) {
            return false;
        }
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        VirtualFile workingDir = (VirtualFile)ObjectUtils.doIfNotNull((Object)RailsApp.fromModule(module), RailsApp::getRailsApplicationRoot);
        if (sdk == null || workingDir == null) {
            return false;
        }
        VirtualFile gemfile = BundlerUtil.getGemfile(module);
        return gemfile == null || !BundlerGemInfrastructure.hasMissingGems(gemfile);
    }

    private /* synthetic */ void lambda$run$3(Exception e) {
        this.onError(e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "module";
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/facet/configuration/RailsPathsQuery";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

