/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.BaseRailsFacetConfiguration;
import org.jetbrains.plugins.ruby.rails.facet.configuration.BaseRailsFacetConfigurationLowLevel;
import org.jetbrains.plugins.ruby.rails.facet.configuration.StandardRailsPaths;
import org.jetbrains.plugins.ruby.rails.facet.versions.BaseRailsFacet;
import org.jetbrains.plugins.ruby.rails.facet.versions.RailsFacetType;

public final class RailsFacetUtil {
    private static final Logger LOG = Logger.getInstance(RailsFacetUtil.class);

    private RailsFacetUtil() {
    }

    @Contract(value="null -> false")
    public static boolean hasRailsSupport(@Nullable Module module) {
        return BaseRailsFacet.getInstance(module) != null;
    }

    @Nullable
    public static String getRailsAppHomeDirPath(@NotNull Module module) {
        if (module == null) {
            RailsFacetUtil.$$$reportNull$$$0(0);
        }
        return (String)ObjectUtils.doIfNotNull((Object)RailsFacetUtil.getRailsFacetConfiguration(module), BaseRailsFacetConfiguration::getRailsApplicationRootPath);
    }

    @Nullable
    public static String getRailsAppHomeDirUrl(@NotNull Module module) {
        if (module == null) {
            RailsFacetUtil.$$$reportNull$$$0(1);
        }
        return (String)ObjectUtils.doIfNotNull((Object)RailsFacetUtil.getRailsFacetConfiguration(module), BaseRailsFacetConfiguration::getRailsApplicationRootUrl);
    }

    @Nullable
    public static VirtualFile getRailsAppHomeDir(@NotNull Module module) {
        if (module == null) {
            RailsFacetUtil.$$$reportNull$$$0(2);
        }
        return (VirtualFile)ObjectUtils.doIfNotNull((Object)RailsFacetUtil.getRailsAppHomeDirUrl(module), arg_0 -> ((VirtualFileManager)VirtualFileManager.getInstance()).findFileByUrl(arg_0));
    }

    @Nullable
    public static StandardRailsPaths getRailsAppStaticPaths(@NotNull Module module) {
        if (module == null) {
            RailsFacetUtil.$$$reportNull$$$0(3);
        }
        return (StandardRailsPaths)ObjectUtils.doIfNotNull((Object)((Object)BaseRailsFacet.getInstance(module)), facet -> ((BaseRailsFacetConfiguration)facet.getConfiguration()).getStaticPaths());
    }

    @Nullable
    public static BaseRailsFacetConfiguration getRailsFacetConfiguration(@NotNull Module module) {
        if (module == null) {
            RailsFacetUtil.$$$reportNull$$$0(4);
        }
        return (BaseRailsFacetConfiguration)ObjectUtils.doIfNotNull((Object)((Object)BaseRailsFacet.getInstance(module)), Facet::getConfiguration);
    }

    public static void refreshRailsAppHomeContent(@NotNull Module module) {
        String homeDirPath;
        if (module == null) {
            RailsFacetUtil.$$$reportNull$$$0(5);
        }
        if ((homeDirPath = RailsFacetUtil.getRailsAppHomeDirPath(module)) == null) {
            LOG.warn("Cannot refresh since Rails Application home directory was not found. Module [" + module.getName() + "] has " + (RailsFacetUtil.hasRailsSupport(module) ? "" : "no") + " Rails support.", new Throwable().fillInStackTrace());
            return;
        }
        try {
            ApplicationManager.getApplication().invokeAndWait(() -> WriteAction.run(() -> {
                VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(homeDirPath);
                if (virtualFile != null) {
                    virtualFile.refresh(false, true);
                }
            }));
        }
        catch (Exception e) {
            LOG.error("Cannot refresh Rails home content due to " + String.valueOf(e));
        }
    }

    @NotNull
    public static BaseRailsFacet configureRailsFacet(@NotNull VirtualFile baseDir, @NotNull Module module) {
        BaseRailsFacet existingFacet;
        if (baseDir == null) {
            RailsFacetUtil.$$$reportNull$$$0(6);
        }
        if (module == null) {
            RailsFacetUtil.$$$reportNull$$$0(7);
        }
        if ((existingFacet = BaseRailsFacet.getInstance(module)) != null) {
            BaseRailsFacet baseRailsFacet = existingFacet;
            if (baseRailsFacet == null) {
                RailsFacetUtil.$$$reportNull$$$0(8);
            }
            return baseRailsFacet;
        }
        RailsFacetType facetType = RailsFacetType.getInstance();
        BaseRailsFacetConfiguration config = (BaseRailsFacetConfiguration)ProjectFacetManager.getInstance((Project)module.getProject()).createDefaultConfiguration((FacetType)facetType);
        ((BaseRailsFacetConfigurationLowLevel)config).setRailsApplicationRootPath(baseDir.getPath());
        FacetManager facetManager = FacetManager.getInstance((Module)module);
        ModifiableFacetModel model = facetManager.createModifiableModel();
        BaseRailsFacet facet = (BaseRailsFacet)facetManager.createFacet((FacetType)facetType, facetType.getDefaultFacetName(), (FacetConfiguration)config, null);
        model.addFacet((Facet)facet);
        WriteAction.runAndWait(() -> model.commit());
        RailsUtil.createRailsRunConfiguration(module);
        BaseRailsFacet baseRailsFacet = facet;
        if (baseRailsFacet == null) {
            RailsFacetUtil.$$$reportNull$$$0(9);
        }
        return baseRailsFacet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/facet/RailsFacetUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/facet/RailsFacetUtil";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "configureRailsFacet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRailsAppHomeDirPath";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRailsAppHomeDirUrl";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRailsAppHomeDir";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRailsAppStaticPaths";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRailsFacetConfiguration";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "refreshRailsAppHomeContent";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "configureRailsFacet";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9 -> new IllegalStateException(string);
        };
    }
}

