/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.facet;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.ex.FileChooserDialogImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemInstallCommandOptions;
import org.jetbrains.plugins.ruby.gem.GemInstallProcessOptions;
import org.jetbrains.plugins.ruby.gem.GemInstallUtil;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.ui.GemUiUtil;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.BaseRailsFacetConfiguration;
import org.jetbrains.plugins.ruby.rails.facet.configuration.BaseRailsFacetConfigurationLowLevel;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.rails.facet.configuration.StandardRailsPaths;
import org.jetbrains.plugins.ruby.rails.facet.ui.wizard.RailsWizardSettings;
import org.jetbrains.plugins.ruby.rails.facet.versions.BaseRailsFacet;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.workspace.sync.RailsGeneratorsManager;
import org.jetbrains.plugins.ruby.rake.workspace.sync.RakeTasksManager;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.run.RunContentDescriptorFactory;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;
import org.jetbrains.plugins.ruby.utils.RubyPluginUtil;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;

public final class BaseRailsFacetBuilder {
    private static final Logger LOG = Logger.getInstance(BaseRailsFacetBuilder.class);

    private BaseRailsFacetBuilder() {
    }

    public static void constructOrInitFacetInstance(BaseRailsFacet railsFacet, @Nullable Sdk rubySdk, boolean isConstructorContext) {
        BaseRailsFacetConfigurationLowLevel conf = (BaseRailsFacetConfigurationLowLevel)railsFacet.getConfiguration();
        conf.setSdk(rubySdk);
        Module uncommittedModule = railsFacet.getModule();
        if (!conf.isInitialized()) {
            if (!isConstructorContext) {
                conf.setInitialized();
            }
            if (uncommittedModule.isLoaded()) {
                if (isConstructorContext) {
                    BaseRailsFacetBuilder.constructGreenhornFacetForLoadedModuleInstance(railsFacet, rubySdk);
                } else {
                    BaseRailsFacetBuilder.configureRailsSourcePaths(railsFacet, uncommittedModule, rubySdk);
                }
            } else if (conf.getNullableRailsApplicationRootPath() != null && isConstructorContext) {
                StartupManager.getInstance((Project)uncommittedModule.getProject()).runWhenProjectIsInitialized(() -> BaseRailsFacetBuilder.configureRailsSourcePaths(railsFacet, uncommittedModule, rubySdk));
            }
        } else if (!conf.wereTestSourcesPatched()) {
            StartupManager.getInstance((Project)uncommittedModule.getProject()).runWhenProjectIsInitialized(() -> {
                RailsApp app = RailsApp.fromModule(uncommittedModule);
                if (app != null) {
                    ModifiableRootModel rootModel = ModuleRootManager.getInstance((Module)uncommittedModule).getModifiableModel();
                    ContentEntry[] contentEntries = rootModel.getContentEntries();
                    if (contentEntries.length > 0) {
                        BaseRailsFacetBuilder.addTestRoots(contentEntries[0], ((BaseRailsFacetConfiguration)railsFacet.getConfiguration()).getStaticPaths());
                    }
                    WriteAction.run(() -> rootModel.commit());
                }
            });
        }
        conf.setTestSourcesPatched(true);
    }

    public static void constructGreenhornFacetForLoadedModuleInstance(BaseRailsFacet railsFacet, @Nullable Sdk rubySdk) {
        String railsApplicationRootUrl;
        BaseRailsFacetConfigurationLowLevel conf = (BaseRailsFacetConfigurationLowLevel)railsFacet.getConfiguration();
        final Module module = railsFacet.getModule();
        Project project = module.getProject();
        assert (!conf.isInitialized());
        assert (module.isLoaded());
        final Ref railsFacetHomePathRef = new Ref();
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        String railsApplicationRootPath = conf.getNullableRailsApplicationRootPath();
        if (railsApplicationRootPath != null && !ApplicationManager.getApplication().isUnitTestMode()) {
            railsApplicationRootUrl = VirtualFileUtil.constructLocalUrl(railsApplicationRootPath);
        } else if (conf.getNullableRailsApplicationRootUrl() != null) {
            railsApplicationRootUrl = conf.getRailsApplicationRootUrl();
        } else {
            ProgressManager.getInstance().run((Task)new Task.Modal(project, RBundle.message((String)"rails.facet.builder.rails.application.searching"), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    indicator.setText(RBundle.message((String)"progress.indicator.title.directories.scanning"));
                    indicator.setText2(RBundle.message((String)"progress.indicator.title.please.wait"));
                    railsFacetHomePathRef.set((Object)BaseRailsFacetBuilder.searchRailsAppInUnderDirectory(module, indicator));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/rails/facet/BaseRailsFacetBuilder$1", "run"));
                }
            });
            if (railsFacetHomePathRef.get() != null) {
                railsApplicationRootUrl = VirtualFileUtil.constructLocalUrl((String)railsFacetHomePathRef.get());
            } else {
                String defaultAppHome = railsFacet.getDefaultRailsApplicationHomePath((ModuleRootModel)rootManager);
                FileChooserDescriptor desc = FileChooserDescriptorFactory.createSingleFolderDescriptor();
                desc.setTitle(RBundle.message((String)"rails.facet.builder.rails.application.choose.title"));
                desc.setDescription(RBundle.message((String)"rails.facet.builder.rails.application.choose.relative.path"));
                desc.putUserData(LangDataKeys.MODULE_CONTEXT, (Object)module);
                desc.setRoots(new VirtualFile[]{LocalFileSystem.getInstance().findFileByPath(defaultAppHome)});
                desc.withTreeRootVisible(true);
                FileChooserDialogImpl dialog = new FileChooserDialogImpl(desc, project);
                VirtualFile[] selectedFiles = dialog.choose(project, new VirtualFile[0]);
                railsApplicationRootUrl = selectedFiles.length > 0 ? selectedFiles[0].getUrl() : VirtualFileUtil.constructLocalUrl(defaultAppHome);
            }
        }
        BaseRailsFacetBuilder.initGreenhornFacetConfiguration(railsApplicationRootUrl, rubySdk, (BaseRailsFacetConfiguration)railsFacet.getConfiguration());
    }

    public static void initGreenhornFacetConfiguration(@NotNull String applicationHomeUrl, @Nullable Sdk sdk, @NotNull BaseRailsFacetConfiguration configuration) {
        if (applicationHomeUrl == null) {
            BaseRailsFacetBuilder.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            BaseRailsFacetBuilder.$$$reportNull$$$0(1);
        }
        BaseRailsFacetConfigurationLowLevel facetConfiguration = (BaseRailsFacetConfigurationLowLevel)configuration;
        facetConfiguration.setRailsApplicationRootUrl(applicationHomeUrl);
        facetConfiguration.setSdk(sdk);
    }

    public static void setupGreenhornFacet(@NotNull Module module, @NotNull BaseRailsFacet railsFacet, @NotNull ModifiableRootModel rootModel, @NotNull RailsWizardSettings settings) {
        ContentEntry[] contentEntries;
        if (module == null) {
            BaseRailsFacetBuilder.$$$reportNull$$$0(2);
        }
        if (railsFacet == null) {
            BaseRailsFacetBuilder.$$$reportNull$$$0(3);
        }
        if (rootModel == null) {
            BaseRailsFacetBuilder.$$$reportNull$$$0(4);
        }
        if (settings == null) {
            BaseRailsFacetBuilder.$$$reportNull$$$0(5);
        }
        Sdk sdk = settings.getProjectSdk();
        String applicationHomePath = RailsFacetUtil.getRailsAppHomeDirPath(module);
        assert (applicationHomePath != null);
        if (sdk != null) {
            BaseRailsFacetBuilder.installComponents(module, railsFacet, sdk, settings, applicationHomePath);
        }
        if ((contentEntries = rootModel.getContentEntries()).length > 0) {
            BaseRailsFacetBuilder.addTestRoots(contentEntries[0], ((BaseRailsFacetConfiguration)railsFacet.getConfiguration()).getStaticPaths());
        }
        if (module.getUserData(RailsUtil.GENERATE_RAILS_VERSION) == null) {
            module.putUserData(RailsUtil.GENERATE_RAILS_VERSION, (Object)settings.getRailsVersion());
        }
        if (!PlatformUtils.isRubyMine()) {
            RailsUtil.createRailsRunConfiguration(module);
        }
        RModuleUtil.getInstance().refreshRubyModuleTypeContent(module);
    }

    private static void installComponents(@NotNull Module uncommittedModule, @NotNull BaseRailsFacet railsFacet, @NotNull Sdk sdk, @NotNull RailsWizardSettings settings, @NotNull String applicationHomePath) {
        if (uncommittedModule == null) {
            BaseRailsFacetBuilder.$$$reportNull$$$0(6);
        }
        if (railsFacet == null) {
            BaseRailsFacetBuilder.$$$reportNull$$$0(7);
        }
        if (sdk == null) {
            BaseRailsFacetBuilder.$$$reportNull$$$0(8);
        }
        if (settings == null) {
            BaseRailsFacetBuilder.$$$reportNull$$$0(9);
        }
        if (applicationHomePath == null) {
            BaseRailsFacetBuilder.$$$reportNull$$$0(10);
        }
        String moduleName = uncommittedModule.getName();
        Project project = uncommittedModule.getProject();
        Runnable runnable = () -> {
            RunContentDescriptorFactory.PinTabsFactory descFactory = new RunContentDescriptorFactory.PinTabsFactory();
            BaseRailsFacetBuilder.installNewRailsVersionIfNeeded(sdk, settings, project);
            BaseRailsFacetBuilder.generateRailsApplication(uncommittedModule, sdk, descFactory, settings, applicationHomePath, BaseRailsFacetBuilder.createOnRailsAppGenerated(descFactory, uncommittedModule, sdk, railsFacet, project, moduleName));
        };
        StartupManager.getInstance((Project)project).runAfterOpened(() -> ApplicationManager.getApplication().invokeLater(runnable, ModalityState.nonModal()));
    }

    private static void installNewRailsVersionIfNeeded(@NotNull Sdk sdk, @NotNull RailsWizardSettings settings, Project project) {
        List<GemInfo> railsGems;
        boolean isRailsVersionInstalled;
        if (sdk == null) {
            BaseRailsFacetBuilder.$$$reportNull$$$0(11);
        }
        if (settings == null) {
            BaseRailsFacetBuilder.$$$reportNull$$$0(12);
        }
        if (isRailsVersionInstalled = (railsGems = GemManager.getInstance().getAllGems(sdk, "rails")).stream().map(gemInfo -> gemInfo.getVersion()).collect(Collectors.toSet()).contains(settings.getRailsVersion())) {
            return;
        }
        HashMap<GemDependency, String> installRailsErrors = new HashMap<GemDependency, String>();
        GemDependency dependency = GemDependency.create("rails", settings.getRailsVersion());
        if (dependency == null) {
            LOG.warn(StringUtil.join((String[])new String[]{"Failed to create a dependency from gem ", "rails", "with version ", settings.getRailsVersion()}));
        }
        GemInstallUtil.installGemsInBackground(sdk, null, ContainerUtil.createMaybeSingletonList((Object)dependency), new GemInstallCommandOptions().withNoDocument(), GemInstallProcessOptions.updateExistingSync(installRailsErrors));
        GemUiUtil.showInstallErrors(project, installRailsErrors);
    }

    private static void generateRailsApplication(Module module, @NotNull Sdk sdk, RunContentDescriptorFactory descriptorFactory, @NotNull RailsWizardSettings settings, @NotNull String applicationHomePath, @Nullable Runnable onDone) {
        int dialogResult;
        if (sdk == null) {
            BaseRailsFacetBuilder.$$$reportNull$$$0(13);
        }
        if (settings == null) {
            BaseRailsFacetBuilder.$$$reportNull$$$0(14);
        }
        if (applicationHomePath == null) {
            BaseRailsFacetBuilder.$$$reportNull$$$0(15);
        }
        RailsWizardSettings.PreconfiguredDatabaseTypes preconfigureDatabaseType = settings.getPreconfiguredDatabaseType();
        String railsVersion = settings.getRailsVersion();
        RailsWizardSettings.RailsProjectTypes railsProjectTypes = settings.getRailsProjectType();
        boolean useRailsJavaScriptFramework = settings.getUseJavaScriptFramework();
        RailsWizardSettings.RailsJavaScriptFramework railsJavaScriptFramework = settings.getJavaScriptFramework();
        String additionalRailsOptions = settings.getAdditionalRailsOptions();
        VirtualFile appHomeDir = LocalFileSystem.getInstance().findFileByPath(applicationHomePath);
        boolean toOverwrite = appHomeDir != null && appHomeDir.isDirectory() && RailsUtil.containsRailsApp(applicationHomePath) ? (dialogResult = Messages.showYesNoDialog((Project)module.getProject(), (String)RBundle.message((String)"module.rails.generate.app.rails.new.overwrite.message", (Object[])new Object[]{applicationHomePath}), (String)RBundle.message((String)"module.rails.generate.app.rails.new.overwrite.title"), (Icon)Messages.getQuestionIcon())) == 0 : false;
        RailsUtil.generateRailsApp(module, sdk, applicationHomePath, toOverwrite, railsVersion, railsProjectTypes, preconfigureDatabaseType, useRailsJavaScriptFramework, railsJavaScriptFramework, additionalRailsOptions, descriptorFactory, onDone);
    }

    private static void addTestRoots(@NotNull ContentEntry contentEntry, @NotNull StandardRailsPaths paths) {
        if (contentEntry == null) {
            BaseRailsFacetBuilder.$$$reportNull$$$0(16);
        }
        if (paths == null) {
            BaseRailsFacetBuilder.$$$reportNull$$$0(17);
        }
        contentEntry.addSourceFolder(paths.getTestsStdUnitRootURL(), true);
        contentEntry.addSourceFolder(paths.getTestsSpecRootURL(), true);
        contentEntry.addSourceFolder(paths.getFeaturesRootURL(), true);
    }

    private static Runnable createOnRailsAppGenerated(RunContentDescriptorFactory.PinTabsFactory descFactory, Module uncommittedModule, Sdk sdk, BaseRailsFacet railsFacet, Project project, String moduleName) {
        return () -> {
            try {
                descFactory.unpinAll();
                if (!uncommittedModule.isDisposed()) {
                    RailsGeneratorsManager.getInstance(project).refresh(false);
                    RakeTasksManager.getInstance(project).refresh(false);
                }
                RailsFacetUtil.refreshRailsAppHomeContent(uncommittedModule);
                BaseRailsFacetBuilder.configureRailsSourcePaths(railsFacet, uncommittedModule, sdk);
            }
            catch (Exception e) {
                BaseRailsFacetBuilder.showError(e, project, moduleName);
            }
        };
    }

    private static void showError(Exception e, Project project, String moduleName) {
        String title = RBundle.message((String)"module.create.dialog.init.errors.title", (Object[])new Object[]{moduleName});
        RunnerUtil.showErrorMessage(project, title, e);
        LOG.warn((Throwable)e);
    }

    @Nullable
    private static String searchRailsAppInUnderDirectory(@NotNull Module module, @NotNull ProgressIndicator indicator) {
        if (module == null) {
            BaseRailsFacetBuilder.$$$reportNull$$$0(18);
        }
        if (indicator == null) {
            BaseRailsFacetBuilder.$$$reportNull$$$0(19);
        }
        Ref railsRootPathRef = new Ref();
        ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance((Module)module).getFileIndex();
        moduleFileIndex.iterateContent(fileOrDir -> {
            String path;
            if (indicator.isCanceled()) {
                return false;
            }
            if (fileOrDir.isDirectory() && RailsUtil.containsRailsApp(path = fileOrDir.getPath())) {
                railsRootPathRef.set((Object)path);
                return false;
            }
            return true;
        });
        return (String)railsRootPathRef.get();
    }

    public static void configureRailsSourcePaths(BaseRailsFacet facet, final Module module, @Nullable Sdk sdk) {
        if (module.isDisposed()) {
            return;
        }
        final Runnable addExcludedAndTestFolders = () -> {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            WriteAction.runAndWait(() -> {
                @NotNull ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                ContentEntry[] entries = modifiableModel.getContentEntries();
                if (entries.length == 0) {
                    modifiableModel.dispose();
                    return;
                }
                @NotNull String railsAppHomeRootUrl = ((BaseRailsFacetConfiguration)facet.getConfiguration()).getRailsApplicationRootUrl();
                ContentEntry railsContentEntry = BaseRailsFacetBuilder.findRailsContentEntry(railsAppHomeRootUrl, entries);
                if (railsContentEntry == null) {
                    StringBuilder buf = new StringBuilder();
                    buf.append("Unable to find rails app in content roots.\nRails app home: ").append(railsAppHomeRootUrl).append(", Entries: [");
                    for (ContentEntry entry : entries) {
                        buf.append(entry.getUrl());
                        buf.append(", ");
                    }
                    buf.append("]");
                    LOG.error(buf.toString());
                    return;
                }
                BaseRailsFacetBuilder.addDefaultRailsExcludedFolders(railsAppHomeRootUrl, railsContentEntry);
                Runnable addRailsExcludedFolder = () -> RbenvGemsetManager.addRbenvLocalGemsetsExcludedFolders(module, sdk, railsContentEntry);
                Project project = module.getProject();
                if (!project.isDisposed()) {
                    if (project.isInitialized()) {
                        addRailsExcludedFolder.run();
                    } else {
                        StartupManager.getInstance((Project)project).runAfterOpened(() -> ((AppUIExecutor)AppUIExecutor.onWriteThread().inSmartMode(project).expireWith((Disposable)module)).execute(addRailsExcludedFolder));
                    }
                }
                BaseRailsFacetBuilder.addTestRoots(railsContentEntry, ((BaseRailsFacetConfiguration)facet.getConfiguration()).getStaticPaths());
                modifiableModel.commit();
            });
        };
        if (module.isLoaded()) {
            addExcludedAndTestFolders.run();
        } else {
            final MessageBusConnection connection = module.getProject().getMessageBus().connect(RubyPluginUtil.getUnloadAwareDisposable(module));
            connection.subscribe(ModuleListener.TOPIC, (Object)new ModuleListener(){

                public void moduleAdded(@NotNull Project project, @NotNull Module addedModule) {
                    if (project == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (addedModule == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (module.equals((Object)addedModule)) {
                        connection.disconnect();
                        addExcludedAndTestFolders.run();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "project";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "addedModule";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/plugins/ruby/rails/facet/BaseRailsFacetBuilder$2";
                    objectArray[2] = "moduleAdded";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    @Nullable
    private static ContentEntry findRailsContentEntry(String railsAppHomeRootUrl, ContentEntry[] entries) {
        ContentEntry railsContentEntry = null;
        for (ContentEntry entry : entries) {
            if (!railsAppHomeRootUrl.contains(entry.getUrl())) continue;
            railsContentEntry = entry;
            break;
        }
        return railsContentEntry;
    }

    private static void addDefaultRailsExcludedFolders(String railsAppHomeRootURL, ContentEntry contentEntry) {
        String componentsUrl = StandardRailsPaths.buildComponentsUrl(railsAppHomeRootURL);
        VirtualFileManager manager = VirtualFileManager.getInstance();
        contentEntry.addExcludeFolder(VirtualFileUtil.buildUrl(railsAppHomeRootURL, ".bundle"));
        contentEntry.addExcludeFolder(VirtualFileUtil.buildUrl(railsAppHomeRootURL, "public/packs"));
        contentEntry.addExcludeFolder(VirtualFileUtil.buildUrl(railsAppHomeRootURL, "vendor/bundle"));
        contentEntry.addExcludeFolder(VirtualFileUtil.buildUrl(railsAppHomeRootURL, "vendor/cache"));
        contentEntry.addExcludeFolder(VirtualFileUtil.buildUrl(railsAppHomeRootURL, "log"));
        for (String path : RailsPaths.getDefaultPaths().get("tmp")) {
            contentEntry.addExcludeFolder(VirtualFileUtil.buildUrl(railsAppHomeRootURL, path));
        }
        for (String path : RailsPaths.getDefaultPaths().get("public")) {
            contentEntry.addExcludeFolder(VirtualFileUtil.buildUrl(railsAppHomeRootURL, path + "/system"));
        }
        contentEntry.addExcludeFolder(componentsUrl);
        for (String path : ContainerUtil.map((Collection)RailsPaths.getDefaultPaths().get("vendor/assets"), it -> it + "/rails")) {
            VirtualFile vendor = manager.findFileByUrl(VirtualFileUtil.buildUrl(railsAppHomeRootURL, path));
            if (vendor == null) continue;
            for (VirtualFile railsGem : vendor.getChildren()) {
                VirtualFile test = railsGem.findChild("test");
                if (test == null) continue;
                contentEntry.addExcludeFolder(test);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationHomeUrl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "railsFacet";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 5: 
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uncommittedModule";
                break;
            }
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationHomePath";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentEntry";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/facet/BaseRailsFacetBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "initGreenhornFacetConfiguration";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setupGreenhornFacet";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "installComponents";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "installNewRailsVersionIfNeeded";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "generateRailsApplication";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "addTestRoots";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "searchRailsAppInUnderDirectory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

