/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.devise;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.ControllerSymbol;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.ViewSymbol;
import org.jetbrains.plugins.ruby.rails.devise.DeviseCallTypeProvider;
import org.jetbrains.plugins.ruby.rails.devise.DeviseForCallType;
import org.jetbrains.plugins.ruby.rails.devise.DeviseForNameIndex;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.RubySymbolProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.ArgumentFakePsiElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.RTypedSyntheticSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SymbolPsiProcessor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeFactory;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.REmptyType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;

public final class DeviseForSymbolProvider
implements RubySymbolProvider {
    @Override
    public boolean processDynamicSymbols(@NotNull Symbol symbol, @Nullable RPsiElement element, @NotNull FQN fqn, @NotNull SymbolPsiProcessor processor, @Nullable PsiElement invocationPoint) {
        if (symbol == null) {
            DeviseForSymbolProvider.$$$reportNull$$$0(0);
        }
        if (fqn == null) {
            DeviseForSymbolProvider.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            DeviseForSymbolProvider.$$$reportNull$$$0(2);
        }
        if (symbol instanceof ControllerSymbol || symbol instanceof ViewSymbol) {
            Project project = symbol.getProject();
            Module module = symbol.getModule();
            if (module == null) {
                return true;
            }
            ArrayList<Symbol> symbols = new ArrayList<Symbol>(DeviseForSymbolProvider.createAllSymbols(project, module));
            for (Symbol newSymbol : symbols) {
                if (processor.process(newSymbol)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static List<Symbol> createAllSymbols(@NotNull Project project, @NotNull Module module) {
        if (project == null) {
            DeviseForSymbolProvider.$$$reportNull$$$0(3);
        }
        if (module == null) {
            DeviseForSymbolProvider.$$$reportNull$$$0(4);
        }
        Collection deviseForNames = DeviseForNameIndex.getInstance().getAllKeys(project);
        ArrayList<Symbol> symbols = new ArrayList<Symbol>();
        for (String deviseForName : deviseForNames) {
            ProgressManager.checkCanceled();
            symbols.addAll(DeviseForSymbolProvider.createMethodSymbolsForName(project, module, deviseForName));
        }
        ArrayList<Symbol> arrayList = symbols;
        if (arrayList == null) {
            DeviseForSymbolProvider.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    public static List<Symbol> createMethodSymbolsForName(@NotNull Project project, @NotNull Module module, @NotNull String name) {
        if (project == null) {
            DeviseForSymbolProvider.$$$reportNull$$$0(6);
        }
        if (module == null) {
            DeviseForSymbolProvider.$$$reportNull$$$0(7);
        }
        if (name == null) {
            DeviseForSymbolProvider.$$$reportNull$$$0(8);
        }
        GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)project);
        Collection deviseForCallTypeCollection = DeviseForNameIndex.getInstance().getElements(project, (SearchScope)searchScope, name);
        if (deviseForCallTypeCollection.isEmpty()) {
            List<Symbol> list = Collections.emptyList();
            if (list == null) {
                DeviseForSymbolProvider.$$$reportNull$$$0(9);
            }
            return list;
        }
        RCall deviseForCall = (RCall)deviseForCallTypeCollection.iterator().next();
        DeviseForCallType.DeviseData deviseData = (DeviseForCallType.DeviseData)deviseForCall.getData(new RubyCallType[]{DeviseCallTypeProvider.DEVISE_FOR});
        if (deviseData.getPluralModelName() == null) {
            List<Symbol> list = Collections.emptyList();
            if (list == null) {
                DeviseForSymbolProvider.$$$reportNull$$$0(10);
            }
            return list;
        }
        return DeviseForSymbolProvider.createMethodSymbols(project, module, deviseData, deviseForCall);
    }

    @NotNull
    public static List<Symbol> createMethodSymbols(@NotNull Project project, @NotNull Module module, @NotNull DeviseForCallType.DeviseData deviseData, @NotNull RCall rCall) {
        String modelNameLowerCase;
        if (project == null) {
            DeviseForSymbolProvider.$$$reportNull$$$0(11);
        }
        if (module == null) {
            DeviseForSymbolProvider.$$$reportNull$$$0(12);
        }
        if (deviseData == null) {
            DeviseForSymbolProvider.$$$reportNull$$$0(13);
        }
        if (rCall == null) {
            DeviseForSymbolProvider.$$$reportNull$$$0(14);
        }
        ArrayList<Symbol> symbols = new ArrayList<Symbol>();
        RType modelRType = deviseData.getModelType(project, module);
        if (modelRType == null) {
            modelRType = REmptyType.INSTANCE;
        }
        if ((modelNameLowerCase = deviseData.getNestedSingularModelName(module)) == null) {
            List<Symbol> list = Collections.emptyList();
            if (list == null) {
                DeviseForSymbolProvider.$$$reportNull$$$0(15);
            }
            return list;
        }
        symbols.add(DeviseForSymbolProvider.createMethodSymbol("authenticate_" + modelNameLowerCase + "!", modelNameLowerCase, rCall, (RType)REmptyType.INSTANCE));
        symbols.add(DeviseForSymbolProvider.createMethodSymbol("current_" + modelNameLowerCase, modelNameLowerCase, rCall, modelRType));
        symbols.add(DeviseForSymbolProvider.createMethodSymbol(modelNameLowerCase + "_signed_in?", modelNameLowerCase, rCall, RTypeFactory.createBoolType(project)));
        symbols.add(DeviseForSymbolProvider.createMethodSymbol(modelNameLowerCase + "_session", modelNameLowerCase, rCall, RTypeFactory.createTypeByFQN(project, "Session")));
        ArrayList<Symbol> arrayList = symbols;
        if (arrayList == null) {
            DeviseForSymbolProvider.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @NotNull
    private static Symbol createMethodSymbol(@NotNull String name, @NotNull String navigationElementName, @NotNull RCall rCall, @NotNull RType returnType) {
        if (name == null) {
            DeviseForSymbolProvider.$$$reportNull$$$0(17);
        }
        if (navigationElementName == null) {
            DeviseForSymbolProvider.$$$reportNull$$$0(18);
        }
        if (rCall == null) {
            DeviseForSymbolProvider.$$$reportNull$$$0(19);
        }
        if (returnType == null) {
            DeviseForSymbolProvider.$$$reportNull$$$0(20);
        }
        MyPsiElement declaration = new MyPsiElement(rCall, name, navigationElementName, AllIcons.Nodes.Method);
        return new RTypedSyntheticSymbol(declaration.getProject(), declaration.getName(), Type.INSTANCE_METHOD, null, returnType, Collections.emptyList(), (PsiElement)declaration);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 9, 10, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/devise/DeviseForSymbolProvider";
                break;
            }
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviseData";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rCall";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigationElementName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/devise/DeviseForSymbolProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createAllSymbols";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodSymbolsForName";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodSymbols";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processDynamicSymbols";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createAllSymbols";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 15: 
            case 16: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createMethodSymbolsForName";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createMethodSymbols";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createMethodSymbol";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 9, 10, 15, 16 -> new IllegalStateException(string);
        };
    }

    public static final class MyPsiElement
    extends ArgumentFakePsiElement {
        private final String myNavigationElementName;
        private final Icon myIcon;

        public MyPsiElement(@NotNull RCall call, @NotNull String name, @NotNull String navigationElementName, @NotNull Icon icon) {
            if (call == null) {
                MyPsiElement.$$$reportNull$$$0(0);
            }
            if (name == null) {
                MyPsiElement.$$$reportNull$$$0(1);
            }
            if (navigationElementName == null) {
                MyPsiElement.$$$reportNull$$$0(2);
            }
            if (icon == null) {
                MyPsiElement.$$$reportNull$$$0(3);
            }
            super(call, name);
            this.myNavigationElementName = navigationElementName;
            this.myIcon = icon;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!super.equals(other)) {
                return false;
            }
            MyPsiElement element = (MyPsiElement)((Object)other);
            return this.myNavigationElementName.equals(element.myNavigationElementName) && this.myIcon.equals(element.myIcon);
        }

        @Nullable
        public PsiElement getNameIdentifier() {
            return this.getArgumentByName(this.myNavigationElementName);
        }

        @NotNull
        public String getTypeName() {
            String string = RBundle.message((String)"method");
            if (string == null) {
                MyPsiElement.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = this.myIcon;
            if (icon == null) {
                MyPsiElement.$$$reportNull$$$0(5);
            }
            return icon;
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.myNavigationElementName.hashCode();
            result = 31 * result + this.myIcon.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "navigationElementName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/devise/DeviseForSymbolProvider$MyPsiElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/devise/DeviseForSymbolProvider$MyPsiElement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

