/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.database;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.RailsIcons;
import org.jetbrains.plugins.ruby.rails.codeInsight.callTypes.RailsActiveRecordAttributeCallType;
import org.jetbrains.plugins.ruby.rails.codeInsight.callTypes.RailsCreateTableCallType;
import org.jetbrains.plugins.ruby.rails.database.MigrationField;
import org.jetbrains.plugins.ruby.rails.database.RailsSchemaParser;
import org.jetbrains.plugins.ruby.rails.database.RailsTableDefinition;
import org.jetbrains.plugins.ruby.rails.indexes.RailsRubySchemaVersionIndex;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.ArgumentFakePsiElement;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyInterpretUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RFileImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RDoBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyRecursiveElementVisitor;

public final class RailsRubySchemaParser
implements RailsSchemaParser {
    @Override
    @NotNull
    public Map<String, RailsTableDefinition> parseSchema(@NotNull PsiFile file) {
        if (file == null) {
            RailsRubySchemaParser.$$$reportNull$$$0(0);
        }
        Map map = (Map)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            if (!(file instanceof RFileImpl)) {
                return new CachedValueProvider.Result(Collections.emptyMap(), new Object[]{file});
            }
            RFileImpl rfile = (RFileImpl)file;
            HashMap<String, RailsTableDefinition> definitions = new HashMap<String, RailsTableDefinition>();
            for (RCall rCall : RailsRubySchemaParser.getStructureCallElements(rfile)) {
                String tableName;
                RailsCreateTableCallType parentCallType;
                RCall parentCall;
                ProgressManager.checkCanceled();
                RailsActiveRecordAttributeCallType callType = (RailsActiveRecordAttributeCallType)((Object)((Object)ObjectUtils.tryCast((Object)rCall.getCallType(), RailsActiveRecordAttributeCallType.class)));
                if (callType == null || (parentCall = (RCall)PsiTreeUtil.getStubChildOfType((PsiElement)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)rCall, RDoBlockCall.class), RCall.class)) == null || (parentCallType = (RailsCreateTableCallType)((Object)((Object)ObjectUtils.tryCast((Object)parentCall.getCallType(), RailsCreateTableCallType.class)))) == null || (tableName = parentCallType.getTableName((RPossibleCall)parentCall)) == null) continue;
                RailsTableDefinition definition = definitions.computeIfAbsent(tableName, __ -> {
                    RailsTableDefinition instance = new RailsTableDefinition((PsiElement)new MyTableFakePsiElement(parentCall, tableName));
                    String primaryKeyName = parentCallType.getPrimaryKeyName((RPossibleCall)parentCall);
                    String primaryKeyType = parentCallType.getPrimaryKeyType((RPossibleCall)parentCall);
                    if (primaryKeyName != null && primaryKeyType != null) {
                        instance.addField(new MigrationField(primaryKeyName, primaryKeyType, (PsiElement)new MyPrimaryKeyFakePsiElement(parentCall)));
                    }
                    return instance;
                });
                String name = callType.getColumnName((RPossibleCall)rCall);
                String type = callType.getColumnType((RPossibleCall)rCall);
                definition.addField(new MigrationField(name, type, (PsiElement)new MyColumnFakePsiElement(rCall, (String)ObjectUtils.coalesce((Object)name, (Object)""))));
            }
            return new CachedValueProvider.Result(Collections.unmodifiableMap(definitions), new Object[]{file});
        });
        if (map == null) {
            RailsRubySchemaParser.$$$reportNull$$$0(1);
        }
        return map;
    }

    @Override
    @Nullable
    public String parseSchemaVersion(@NotNull PsiFile file) {
        if (file == null) {
            RailsRubySchemaParser.$$$reportNull$$$0(2);
        }
        Project project = file.getProject();
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)file);
        if (virtualFile == null) {
            return null;
        }
        return (String)FileBasedIndex.getInstance().getSingleEntryIndexData(RailsRubySchemaVersionIndex.KEY, virtualFile, project);
    }

    @NotNull
    private static List<? extends RCall> getStructureCallElements(@NotNull RFileImpl file) {
        if (file == null) {
            RailsRubySchemaParser.$$$reportNull$$$0(3);
        }
        List list = (List)file.withGreenStubOrAst(stub -> ContainerUtil.filterIsInstance((Collection)file.getStructureElements(), RCall.class), ast -> {
            final ArrayList calls = new ArrayList();
            file.accept((PsiElementVisitor)new RubyRecursiveElementVisitor(){

                public void visitRCall(@NotNull RCall call) {
                    if (call == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.visitRCall(call);
                    calls.add(call);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/plugins/ruby/rails/database/RailsRubySchemaParser$1", "visitRCall"));
                }
            });
            return Collections.unmodifiableList(calls);
        });
        if (list == null) {
            RailsRubySchemaParser.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/database/RailsRubySchemaParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/database/RailsRubySchemaParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSchema";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStructureCallElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseSchema";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseSchemaVersion";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getStructureCallElements";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4 -> new IllegalStateException(string);
        };
    }

    public static final class MyColumnFakePsiElement
    extends ArgumentFakePsiElement {
        private MyColumnFakePsiElement(@NotNull RCall call, @NotNull String name) {
            if (call == null) {
                MyColumnFakePsiElement.$$$reportNull$$$0(0);
            }
            if (name == null) {
                MyColumnFakePsiElement.$$$reportNull$$$0(1);
            }
            super(call, name);
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = RailsIcons.RAILS_MODEL_ATTRIBUTE_ICON;
            if (icon == null) {
                MyColumnFakePsiElement.$$$reportNull$$$0(2);
            }
            return icon;
        }

        @Nls
        @Nullable
        public String getTypeName() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/database/RailsRubySchemaParser$MyColumnFakePsiElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/database/RailsRubySchemaParser$MyColumnFakePsiElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static final class MyTableFakePsiElement
    extends ArgumentFakePsiElement {
        private MyTableFakePsiElement(@NotNull RCall call, @NotNull String name) {
            if (call == null) {
                MyTableFakePsiElement.$$$reportNull$$$0(0);
            }
            if (name == null) {
                MyTableFakePsiElement.$$$reportNull$$$0(1);
            }
            super(call, name);
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = AllIcons.Nodes.DataTables;
            if (icon == null) {
                MyTableFakePsiElement.$$$reportNull$$$0(2);
            }
            return icon;
        }

        @Nls
        @Nullable
        public String getTypeName() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/database/RailsRubySchemaParser$MyTableFakePsiElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/database/RailsRubySchemaParser$MyTableFakePsiElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static final class MyPrimaryKeyFakePsiElement
    extends ArgumentFakePsiElement {
        private MyPrimaryKeyFakePsiElement(@NotNull RCall call) {
            if (call == null) {
                MyPrimaryKeyFakePsiElement.$$$reportNull$$$0(0);
            }
            super(call, "");
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = RailsIcons.RAILS_MODEL_ATTRIBUTE_ICON;
            if (icon == null) {
                MyPrimaryKeyFakePsiElement.$$$reportNull$$$0(1);
            }
            return icon;
        }

        @Nullable
        public PsiElement getNameIdentifier() {
            PsiElement value = (PsiElement)ObjectUtils.doIfNotNull((Object)RubyInterpretUtil.getOptionAssocElement((RPossibleCall)this.getCall(), "primary_key"), RAssoc::getValue);
            return (PsiElement)ObjectUtils.coalesce((Object)value, (Object)((PsiElement)ContainerUtil.getFirstItem((List)this.getCall().getArguments())));
        }

        @Nls
        @Nullable
        public String getTypeName() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/database/RailsRubySchemaParser$MyPrimaryKeyFakePsiElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/database/RailsRubySchemaParser$MyPrimaryKeyFakePsiElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

